/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collections;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.MiningFieldUtil;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.mining.MiningModelEvaluationContext;

public class ModelEvaluationContext
extends EvaluationContext {
    private MiningModelEvaluationContext parent = null;
    private ModelEvaluator<?> modelEvaluator = null;
    private Map<FieldName, ?> arguments = Collections.emptyMap();
    private boolean compatible = false;

    public ModelEvaluationContext(ModelEvaluator<?> modelEvaluator) {
        this(null, modelEvaluator);
    }

    public ModelEvaluationContext(MiningModelEvaluationContext parent, ModelEvaluator<?> modelEvaluator) {
        this.setParent(parent);
        this.setModelEvaluator(modelEvaluator);
    }

    @Override
    protected FieldValue createFieldValue(FieldName name, Object value) {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        DataField dataField = modelEvaluator.getDataField(name);
        if (dataField == null) {
            throw new MissingFieldException(name);
        }
        MiningField miningField = modelEvaluator.getMiningField(name);
        if (miningField == null) {
            throw new EvaluationException();
        }
        MiningField.UsageType usageType = miningField.getUsageType();
        switch (usageType) {
            case ACTIVE: 
            case GROUP: 
            case ORDER: {
                return FieldValueUtil.prepareInputValue((Field)dataField, miningField, value);
            }
            case PREDICTED: 
            case TARGET: {
                Target target = modelEvaluator.getTarget(name);
                return FieldValueUtil.prepareTargetValue(dataField, miningField, target, value);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)miningField, (Enum<?>)usageType);
    }

    @Override
    public void reset() {
        super.reset();
        this.arguments = Collections.emptyMap();
        this.compatible = false;
    }

    public void reset(ModelEvaluator<?> modelEvaluator) {
        this.reset();
        this.setModelEvaluator(modelEvaluator);
    }

    @Override
    protected FieldValue resolve(FieldName name) {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        MiningModelEvaluationContext parent = this.getParent();
        MiningField miningField = modelEvaluator.getMiningField(name);
        if (miningField == null) {
            DerivedField localDerivedField = modelEvaluator.getLocalDerivedField(name);
            if (localDerivedField != null) {
                FieldValue value = ExpressionUtil.evaluate(localDerivedField, (EvaluationContext)this);
                return this.declare(name, value);
            }
            DerivedField derivedField = modelEvaluator.getDerivedField(name);
            if (derivedField != null) {
                FieldValue value = parent != null && this.isCompatible() ? parent.evaluate(name) : ExpressionUtil.evaluate(derivedField, (EvaluationContext)this);
                return this.declare(name, value);
            }
        } else {
            Field field;
            DataField dataField = modelEvaluator.getDataField(name);
            if (dataField != null) {
                Map<FieldName, ?> arguments = this.getArguments();
                if (parent != null) {
                    FieldValue value = parent.evaluate(name);
                    return this.declare(name, ModelEvaluationContext.performValueTreatment((Field)dataField, miningField, value));
                }
                Object value = arguments.get(name);
                return this.declare(name, value);
            }
            if (parent != null && (field = ModelEvaluationContext.resolveField(name, parent)) != null) {
                FieldValue value = parent.evaluate(name);
                return this.declare(name, ModelEvaluationContext.performValueTreatment(field, miningField, value));
            }
            DerivedField localDerivedField = modelEvaluator.getLocalDerivedField(name);
            DerivedField derivedField = modelEvaluator.getDerivedField(name);
            if (localDerivedField != null || derivedField != null) {
                throw new InvalidFeatureException((PMMLObject)miningField);
            }
        }
        throw new MissingFieldException(name);
    }

    @Override
    protected DefineFunction getDefineFunction(String name) {
        ModelEvaluator<?> modelEvaluator = this.getModelEvaluator();
        DefineFunction defineFunction = modelEvaluator.getDefineFunction(name);
        return defineFunction;
    }

    public MiningModelEvaluationContext getParent() {
        return this.parent;
    }

    private void setParent(MiningModelEvaluationContext parent) {
        this.parent = parent;
    }

    public ModelEvaluator<?> getModelEvaluator() {
        return this.modelEvaluator;
    }

    private void setModelEvaluator(ModelEvaluator<?> modelEvaluator) {
        this.modelEvaluator = modelEvaluator;
    }

    public Map<FieldName, ?> getArguments() {
        return this.arguments;
    }

    public void setArguments(Map<FieldName, ?> arguments) {
        this.arguments = arguments;
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    public void setCompatible(boolean compatible) {
        MiningModelEvaluationContext parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException();
        }
        this.compatible = compatible;
    }

    private static Field resolveField(FieldName name, MiningModelEvaluationContext context) {
        while (context != null) {
            OutputField outputField = context.getOutputField(name);
            if (outputField != null) {
                return outputField;
            }
            DerivedField localDerivedField = context.getLocalDerivedField(name);
            if (localDerivedField != null) {
                return localDerivedField;
            }
            context = context.getParent();
        }
        return null;
    }

    private static FieldValue performValueTreatment(Field field, MiningField miningField, FieldValue value) {
        if (MiningFieldUtil.isDefault(miningField)) {
            return value;
        }
        if (value == null) {
            return FieldValueUtil.performMissingValueTreatment(field, miningField);
        }
        return FieldValueUtil.performValidValueTreatment(field, miningField, value);
    }
}

