/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import org.jpmml.evaluator.DoubleVector;
import org.jpmml.evaluator.EvaluationException;

public class RegressionAggregator {
    private DoubleVector values = null;
    private DoubleVector weights = null;
    private DoubleVector weightedValues = null;

    public RegressionAggregator() {
        this(0);
    }

    public RegressionAggregator(int capacity) {
        this.values = new DoubleVector(capacity);
        this.weights = new DoubleVector(capacity);
        this.weightedValues = new DoubleVector(0);
    }

    public int size() {
        return this.weightedValues.size();
    }

    public void add(double value) {
        this.add(value, 1.0);
    }

    public void add(double value, double weight) {
        if (weight < 0.0) {
            throw new IllegalArgumentException();
        }
        this.values.add(value);
        this.weights.add(weight);
        this.weightedValues.add(value * weight);
    }

    public double average() {
        return this.values.sum() / this.weights.sum();
    }

    public double weightedAverage() {
        return this.weightedValues.sum() / this.weights.sum();
    }

    public double sum() {
        return this.values.sum();
    }

    public double weightedSum() {
        return this.weightedValues.sum();
    }

    public double median() {
        return this.values.median();
    }

    public double weightedMedian() {
        int size = this.size();
        ArrayList<Entry> entries = new ArrayList<Entry>(size);
        for (int i = 0; i < size; ++i) {
            Entry entry = new Entry(this.values.get(i), this.weights.get(i));
            entries.add(entry);
        }
        Collections.sort(entries);
        double weightSumThreshold = 0.5 * this.weights.sum();
        double weightSum = 0.0;
        for (Entry entry : entries) {
            if (!((weightSum += entry.weight) >= weightSumThreshold)) continue;
            return entry.value;
        }
        throw new EvaluationException();
    }

    private static class Entry
    implements Comparable<Entry> {
        private double value;
        private double weight;

        private Entry(double value) {
            this(value, 1.0);
        }

        private Entry(double value, double weight) {
            this.value = value;
            this.weight = weight;
        }

        @Override
        public int compareTo(Entry that) {
            return Double.compare(this.value, that.value);
        }
    }
}

