/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class TextTokenizer {
    private Pattern pattern = null;

    public TextTokenizer(Pattern pattern) {
        this.setPattern(pattern);
    }

    public List<String> tokenize(String string) {
        Pattern pattern = this.getPattern();
        if ("".equals(string)) {
            return Collections.emptyList();
        }
        int count = 0;
        Object[] tokens = pattern.split(string, -1);
        int max = tokens.length;
        for (int i = 0; i < max; ++i) {
            char c;
            int begin;
            String token = tokens[i];
            int end = token.length();
            for (begin = 0; begin < end && TextTokenizer.isPunctuation(c = token.charAt(begin)); ++begin) {
            }
            while (end > begin && TextTokenizer.isPunctuation(c = token.charAt(end - 1))) {
                --end;
            }
            if (begin > 0 || end < token.length()) {
                token = token.substring(begin, end);
            }
            if (token.length() <= 0) continue;
            tokens[count] = token;
            ++count;
        }
        if (count < tokens.length) {
            String[] tmpTokens = new String[count];
            System.arraycopy(tokens, 0, tmpTokens, 0, count);
            tokens = tmpTokens;
        }
        return ImmutableList.copyOf((Object[])tokens);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    private void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public static boolean isPunctuation(char c) {
        int type = Character.getType(c);
        switch (type) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }
}

