/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.general_regression;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.Matrix;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TypeDefinitionField;
import org.dmg.pmml.general_regression.BaseCumHazardTables;
import org.dmg.pmml.general_regression.BaselineCell;
import org.dmg.pmml.general_regression.BaselineStratum;
import org.dmg.pmml.general_regression.Categories;
import org.dmg.pmml.general_regression.Category;
import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.dmg.pmml.general_regression.PCell;
import org.dmg.pmml.general_regression.PPCell;
import org.dmg.pmml.general_regression.PPMatrix;
import org.dmg.pmml.general_regression.ParamMatrix;
import org.dmg.pmml.general_regression.Parameter;
import org.dmg.pmml.general_regression.ParameterCell;
import org.dmg.pmml.general_regression.ParameterList;
import org.dmg.pmml.general_regression.Predictor;
import org.dmg.pmml.general_regression.PredictorList;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.HasParsedValueMapping;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MatrixUtil;
import org.jpmml.evaluator.MissingValueException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.NormalDistributionUtil;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.Values;

public class GeneralRegressionModelEvaluator
extends ModelEvaluator<GeneralRegressionModel> {
    private transient BiMap<String, Parameter> parameterRegistry = null;
    private transient Map<String, Map<String, Row>> ppMatrixMap = null;
    private transient Map<String, List<PCell>> paramMatrixMap = null;
    private transient List<String> targetCategories = null;
    private static final LoadingCache<GeneralRegressionModel, BiMap<String, Parameter>> parameterCache = CacheUtil.buildLoadingCache(new CacheLoader<GeneralRegressionModel, BiMap<String, Parameter>>(){

        public BiMap<String, Parameter> load(GeneralRegressionModel generalRegressionModel) {
            return ImmutableBiMap.copyOf((Map)GeneralRegressionModelEvaluator.parseParameterRegistry(generalRegressionModel.getParameterList()));
        }
    });
    private static final LoadingCache<GeneralRegressionModel, BiMap<FieldName, Predictor>> factorCache = CacheUtil.buildLoadingCache(new CacheLoader<GeneralRegressionModel, BiMap<FieldName, Predictor>>(){

        public BiMap<FieldName, Predictor> load(GeneralRegressionModel generalRegressionModel) {
            return ImmutableBiMap.copyOf((Map)GeneralRegressionModelEvaluator.parsePredictorRegistry((PredictorList)generalRegressionModel.getFactorList()));
        }
    });
    private static final LoadingCache<GeneralRegressionModel, BiMap<FieldName, Predictor>> covariateCache = CacheUtil.buildLoadingCache(new CacheLoader<GeneralRegressionModel, BiMap<FieldName, Predictor>>(){

        public BiMap<FieldName, Predictor> load(GeneralRegressionModel generalRegressionModel) {
            return ImmutableBiMap.copyOf((Map)GeneralRegressionModelEvaluator.parsePredictorRegistry((PredictorList)generalRegressionModel.getCovariateList()));
        }
    });
    private static final LoadingCache<GeneralRegressionModel, Map<String, Map<String, Row>>> ppMatrixCache = CacheUtil.buildLoadingCache(new CacheLoader<GeneralRegressionModel, Map<String, Map<String, Row>>>(){

        public Map<String, Map<String, Row>> load(GeneralRegressionModel generalRegressionModel) {
            return Collections.unmodifiableMap(GeneralRegressionModelEvaluator.parsePPMatrix(generalRegressionModel));
        }
    });
    private static final LoadingCache<GeneralRegressionModel, Map<String, List<PCell>>> paramMatrixCache = CacheUtil.buildLoadingCache(new CacheLoader<GeneralRegressionModel, Map<String, List<PCell>>>(){

        public Map<String, List<PCell>> load(GeneralRegressionModel generalRegressionModel) {
            return Collections.unmodifiableMap(GeneralRegressionModelEvaluator.parseParamMatrix(generalRegressionModel));
        }
    });

    public GeneralRegressionModelEvaluator(PMML pmml) {
        this(pmml, GeneralRegressionModelEvaluator.selectModel(pmml, GeneralRegressionModel.class));
    }

    public GeneralRegressionModelEvaluator(PMML pmml, GeneralRegressionModel generalRegressionModel) {
        super(pmml, generalRegressionModel);
        ParameterList parameterList = generalRegressionModel.getParameterList();
        if (parameterList == null) {
            throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
        }
        PPMatrix ppMatrix = generalRegressionModel.getPPMatrix();
        if (ppMatrix == null) {
            throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
        }
        ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
        if (paramMatrix == null) {
            throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
        }
    }

    @Override
    public String getSummary() {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        switch (modelType) {
            case COX_REGRESSION: {
                return "Cox regression";
            }
        }
        return "General regression";
    }

    @Override
    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, Object> predictions;
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        if (!generalRegressionModel.isScorable()) {
            throw new InvalidResultException((PMMLObject)generalRegressionModel);
        }
        MiningFunction miningFunction = generalRegressionModel.getMiningFunction();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(context);
                break;
            }
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    private Map<FieldName, ?> evaluateRegression(ModelEvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        switch (modelType) {
            case COX_REGRESSION: {
                return this.evaluateCoxRegression(context);
            }
        }
        return this.evaluateGeneralRegression(context);
    }

    private Map<FieldName, ? extends Double> evaluateCoxRegression(ModelEvaluationContext context) {
        FieldValue value;
        Double maxTime;
        List baselineCells;
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        BaseCumHazardTables baseCumHazardTables = generalRegressionModel.getBaseCumHazardTables();
        if (baseCumHazardTables == null) {
            throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
        }
        FieldName baselineStrataVariable = generalRegressionModel.getBaselineStrataVariable();
        if (baselineStrataVariable != null) {
            FieldValue value2 = GeneralRegressionModelEvaluator.getVariable(baselineStrataVariable, context);
            BaselineStratum baselineStratum = GeneralRegressionModelEvaluator.getBaselineStratum(baseCumHazardTables, value2);
            if (baselineStratum == null) {
                return null;
            }
            baselineCells = baselineStratum.getBaselineCells();
            maxTime = baselineStratum.getMaxTime();
        } else {
            baselineCells = baseCumHazardTables.getBaselineCells();
            maxTime = baseCumHazardTables.getMaxTime();
            if (maxTime == null) {
                throw new InvalidFeatureException((PMMLObject)baseCumHazardTables);
            }
        }
        Comparator<BaselineCell> comparator = new Comparator<BaselineCell>(){

            @Override
            public int compare(BaselineCell left, BaselineCell right) {
                return Double.compare(left.getTime(), right.getTime());
            }
        };
        Ordering ordering = Ordering.from((Comparator)comparator);
        FieldName startTimeVariable = generalRegressionModel.getStartTimeVariable();
        FieldName endTimeVariable = generalRegressionModel.getEndTimeVariable();
        if (endTimeVariable != null) {
            FieldValue minTimeValue;
            BaselineCell minBaselineCell = (BaselineCell)ordering.min((Iterable)baselineCells);
            Double minTime = minBaselineCell.getTime();
            value = GeneralRegressionModelEvaluator.getVariable(endTimeVariable, context);
            if (value.compareToValue(minTimeValue = FieldValueUtil.create(DataType.DOUBLE, OpType.CONTINUOUS, minTime)) < 0) {
                return Collections.singletonMap(this.getTargetFieldName(), Values.DOUBLE_ZERO);
            }
            FieldValue maxTimeValue = FieldValueUtil.create(DataType.DOUBLE, OpType.CONTINUOUS, maxTime);
            if (value.compareToValue(maxTimeValue) > 0) {
                return null;
            }
        } else {
            throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
        }
        Predicate<BaselineCell> predicate = new Predicate<BaselineCell>(){
            private double time;
            {
                this.time = value.asNumber().doubleValue();
            }

            public boolean apply(BaselineCell baselineCell) {
                return baselineCell.getTime() <= this.time;
            }
        };
        BaselineCell baselineCell = (BaselineCell)ordering.max(Iterables.filter((Iterable)baselineCells, (Predicate)predicate));
        double baselineCumHazard = baselineCell.getCumHazard();
        Double r = this.computeDotProduct(context);
        Double s = this.computeReferencePoint();
        if (r == null || s == null) {
            return null;
        }
        Double cumHazard = baselineCumHazard * Math.exp(r - s);
        return Collections.singletonMap(this.getTargetFieldName(), cumHazard);
    }

    private Map<FieldName, ?> evaluateGeneralRegression(ModelEvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        Double result = this.computeDotProduct(context);
        if (result == null) {
            return TargetUtil.evaluateRegressionDefault(context);
        }
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        switch (modelType) {
            case REGRESSION: 
            case GENERAL_LINEAR: {
                break;
            }
            case GENERALIZED_LINEAR: {
                result = this.computeLink(result, context);
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
            }
        }
        return TargetUtil.evaluateRegression(result, context);
    }

    private Map<FieldName, ? extends Classification> evaluateClassification(ModelEvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        List<String> targetCategories = this.getTargetCategories();
        Map<String, Map<String, Row>> ppMatrixMap = this.getPPMatrixMap();
        Map<String, List<PCell>> paramMatrixMap = this.getParamMatrixMap();
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        ProbabilityDistribution result = new ProbabilityDistribution();
        double previousValue = 0.0;
        for (int i = 0; i < targetCategories.size(); ++i) {
            double value;
            String targetCategory = targetCategories.get(i);
            if (i < targetCategories.size() - 1) {
                Double dotProduct;
                Iterable parameterCells;
                Map<String, Row> parameterPredictorRows;
                if (ppMatrixMap.isEmpty()) {
                    parameterPredictorRows = Collections.emptyMap();
                } else {
                    parameterPredictorRows = ppMatrixMap.get(targetCategory);
                    if (parameterPredictorRows == null) {
                        parameterPredictorRows = ppMatrixMap.get(null);
                    }
                    if (parameterPredictorRows == null) {
                        PPMatrix ppMatrix = generalRegressionModel.getPPMatrix();
                        throw new InvalidFeatureException((PMMLObject)ppMatrix);
                    }
                }
                switch (modelType) {
                    case GENERALIZED_LINEAR: 
                    case MULTINOMIAL_LOGISTIC: {
                        parameterCells = paramMatrixMap.get(targetCategory);
                        if (parameterCells == null && targetCategories.size() == 2) {
                            parameterCells = paramMatrixMap.get(null);
                        }
                        if (parameterCells != null) break;
                        ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
                        throw new InvalidFeatureException((PMMLObject)paramMatrix);
                    }
                    case ORDINAL_MULTINOMIAL: {
                        List<PCell> interceptCells = paramMatrixMap.get(targetCategory);
                        if (interceptCells == null || interceptCells.size() != 1) {
                            ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
                            throw new InvalidFeatureException((PMMLObject)paramMatrix);
                        }
                        parameterCells = paramMatrixMap.get(null);
                        if (parameterCells == null) {
                            ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
                            throw new InvalidFeatureException((PMMLObject)paramMatrix);
                        }
                        parameterCells = Iterables.concat(interceptCells, (Iterable)parameterCells);
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
                    }
                }
                if ((dotProduct = this.computeDotProduct(parameterCells, parameterPredictorRows, context)) == null) {
                    return TargetUtil.evaluateClassificationDefault(context);
                }
                value = dotProduct;
                switch (modelType) {
                    case GENERALIZED_LINEAR: {
                        value = this.computeLink(value, context);
                        break;
                    }
                    case MULTINOMIAL_LOGISTIC: {
                        value = Math.exp(value);
                        break;
                    }
                    case ORDINAL_MULTINOMIAL: {
                        value = this.computeCumulativeLink(value, context);
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
                    }
                }
            } else {
                switch (modelType) {
                    case GENERALIZED_LINEAR: {
                        value = 1.0 - previousValue;
                        break;
                    }
                    case MULTINOMIAL_LOGISTIC: {
                        value = Math.exp(0.0);
                        break;
                    }
                    case ORDINAL_MULTINOMIAL: {
                        value = 1.0;
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
                    }
                }
            }
            switch (modelType) {
                case GENERALIZED_LINEAR: 
                case MULTINOMIAL_LOGISTIC: {
                    result.put(targetCategory, value);
                    break;
                }
                case ORDINAL_MULTINOMIAL: {
                    result.put(targetCategory, value - previousValue);
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
                }
            }
            previousValue = value;
        }
        switch (modelType) {
            case GENERALIZED_LINEAR: {
                break;
            }
            case MULTINOMIAL_LOGISTIC: {
                result.normalizeValues();
                break;
            }
            case ORDINAL_MULTINOMIAL: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
            }
        }
        return TargetUtil.evaluateClassification(result, context);
    }

    private Double computeDotProduct(EvaluationContext context) {
        Map<String, Row> parameterPredictorRows;
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        Map<String, Map<String, Row>> ppMatrixMap = this.getPPMatrixMap();
        if (ppMatrixMap.isEmpty()) {
            parameterPredictorRows = Collections.emptyMap();
        } else {
            parameterPredictorRows = ppMatrixMap.get(null);
            if (parameterPredictorRows == null) {
                PPMatrix ppMatrix = generalRegressionModel.getPPMatrix();
                throw new InvalidFeatureException((PMMLObject)ppMatrix);
            }
        }
        Map<String, List<PCell>> paramMatrixMap = this.getParamMatrixMap();
        if (paramMatrixMap.size() != 1 || !paramMatrixMap.containsKey(null)) {
            ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
            throw new InvalidFeatureException((PMMLObject)paramMatrix);
        }
        List<PCell> parameterCells = paramMatrixMap.get(null);
        return this.computeDotProduct(parameterCells, parameterPredictorRows, context);
    }

    private Double computeDotProduct(Iterable<PCell> parameterCells, Map<String, Row> parameterPredictorRows, EvaluationContext context) {
        double sum = 0.0;
        int count = 0;
        for (PCell parameterCell : parameterCells) {
            double value;
            Row parameterPredictorRow = parameterPredictorRows.get(parameterCell.getParameterName());
            if (parameterPredictorRow != null) {
                Double x = parameterPredictorRow.evaluate(context);
                if (x == null) {
                    return null;
                }
                value = x * parameterCell.getBeta();
            } else {
                value = parameterCell.getBeta();
            }
            sum += value;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        return sum;
    }

    private Double computeReferencePoint() {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        BiMap<String, Parameter> parameters = this.getParameterRegistry();
        Map<String, List<PCell>> paramMatrixMap = this.getParamMatrixMap();
        if (paramMatrixMap.size() != 1 || !paramMatrixMap.containsKey(null)) {
            ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
            throw new InvalidFeatureException((PMMLObject)paramMatrix);
        }
        Iterable parameterCells = paramMatrixMap.get(null);
        Double sum = null;
        for (PCell parameterCell : parameterCells) {
            Parameter parameter = (Parameter)parameters.get((Object)parameterCell.getParameterName());
            if (parameter == null) {
                return null;
            }
            double value = parameter.getReferencePoint() * parameterCell.getBeta();
            sum = sum != null ? sum + value : value;
        }
        return sum;
    }

    private double computeLink(double value, EvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        GeneralRegressionModel.LinkFunction linkFunction = generalRegressionModel.getLinkFunction();
        if (linkFunction == null) {
            throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
        }
        Double a = GeneralRegressionModelEvaluator.getOffset(generalRegressionModel, context);
        Integer b = GeneralRegressionModelEvaluator.getTrials(generalRegressionModel, context);
        Double c = generalRegressionModel.getDistParameter();
        Double d = generalRegressionModel.getLinkParameter();
        switch (linkFunction) {
            case CLOGLOG: {
                return (1.0 - Math.exp(-Math.exp(value + a))) * (double)b.intValue();
            }
            case IDENTITY: {
                return (value + a) * (double)b.intValue();
            }
            case LOG: {
                return Math.exp(value + a) * (double)b.intValue();
            }
            case LOGC: {
                return (1.0 - Math.exp(value + a)) * (double)b.intValue();
            }
            case LOGIT: {
                return 1.0 / (1.0 + Math.exp(-(value + a))) * (double)b.intValue();
            }
            case LOGLOG: {
                return Math.exp(-Math.exp(-(value + a))) * (double)b.intValue();
            }
            case NEGBIN: {
                if (c == null) {
                    throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
                }
                return 1.0 / (c * (Math.exp(-(value + a)) - 1.0)) * (double)b.intValue();
            }
            case ODDSPOWER: {
                if (d == null) {
                    throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
                }
                if (d < 0.0 || d > 0.0) {
                    return 1.0 / (1.0 + Math.pow(1.0 + d * (value + a), -(1.0 / d))) * (double)b.intValue();
                }
                return 1.0 / (1.0 + Math.exp(-(value + a))) * (double)b.intValue();
            }
            case POWER: {
                if (d == null) {
                    throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
                }
                if (d < 0.0 || d > 0.0) {
                    return Math.pow(value + a, 1.0 / d) * (double)b.intValue();
                }
                return Math.exp(value + a) * (double)b.intValue();
            }
            case PROBIT: {
                return NormalDistributionUtil.cumulativeProbability(value + a) * (double)b.intValue();
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)linkFunction);
    }

    private double computeCumulativeLink(double value, EvaluationContext context) {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        GeneralRegressionModel.CumulativeLinkFunction cumulativeLinkFunction = generalRegressionModel.getCumulativeLinkFunction();
        if (cumulativeLinkFunction == null) {
            throw new InvalidFeatureException((PMMLObject)generalRegressionModel);
        }
        Double a = GeneralRegressionModelEvaluator.getOffset(generalRegressionModel, context);
        switch (cumulativeLinkFunction) {
            case LOGIT: {
                return 1.0 / (1.0 + Math.exp(-(value + a)));
            }
            case PROBIT: {
                return NormalDistributionUtil.cumulativeProbability(value + a);
            }
            case CLOGLOG: {
                return 1.0 - Math.exp(-Math.exp(value + a));
            }
            case LOGLOG: {
                return Math.exp(-Math.exp(-(value + a)));
            }
            case CAUCHIT: {
                return 0.5 + 0.3183098861837907 * Math.atan(value + a);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)cumulativeLinkFunction);
    }

    public BiMap<String, Parameter> getParameterRegistry() {
        if (this.parameterRegistry == null) {
            this.parameterRegistry = this.getValue(parameterCache);
        }
        return this.parameterRegistry;
    }

    private Map<String, Map<String, Row>> getPPMatrixMap() {
        if (this.ppMatrixMap == null) {
            this.ppMatrixMap = this.getValue(ppMatrixCache);
        }
        return this.ppMatrixMap;
    }

    private Map<String, List<PCell>> getParamMatrixMap() {
        if (this.paramMatrixMap == null) {
            this.paramMatrixMap = this.getValue(paramMatrixCache);
        }
        return this.paramMatrixMap;
    }

    private List<String> getTargetCategories() {
        if (this.targetCategories == null) {
            this.targetCategories = ImmutableList.copyOf(this.parseTargetCategories());
        }
        return this.targetCategories;
    }

    private List<String> parseTargetCategories() {
        GeneralRegressionModel generalRegressionModel = (GeneralRegressionModel)this.getModel();
        TargetField targetField = this.getTargetField();
        DataField dataField = targetField.getDataField();
        OpType opType = dataField.getOpType();
        switch (opType) {
            case CONTINUOUS: {
                throw new InvalidFeatureException((PMMLObject)dataField);
            }
            case CATEGORICAL: 
            case ORDINAL: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)dataField, (Enum<?>)opType);
            }
        }
        List<String> targetCategories = FieldValueUtil.getTargetCategories((TypeDefinitionField)dataField);
        if (targetCategories.size() > 0 && targetCategories.size() < 2) {
            throw new InvalidFeatureException((PMMLObject)dataField);
        }
        String targetReferenceCategory = generalRegressionModel.getTargetReferenceCategory();
        GeneralRegressionModel.ModelType modelType = generalRegressionModel.getModelType();
        switch (modelType) {
            case GENERALIZED_LINEAR: 
            case MULTINOMIAL_LOGISTIC: {
                if (targetReferenceCategory != null) break;
                Predicate<String> filter = new Predicate<String>(){
                    private Map<String, List<PCell>> paramMatrixMap;
                    {
                        this.paramMatrixMap = GeneralRegressionModelEvaluator.this.getParamMatrixMap();
                    }

                    public boolean apply(String string) {
                        return !this.paramMatrixMap.containsKey(string);
                    }
                };
                LinkedHashSet targetReferenceCategories = Sets.newLinkedHashSet((Iterable)Iterables.filter(targetCategories, (Predicate)filter));
                if (targetReferenceCategories.size() != 1) {
                    ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
                    throw new InvalidFeatureException((PMMLObject)paramMatrix);
                }
                targetReferenceCategory = (String)Iterables.getOnlyElement((Iterable)targetReferenceCategories);
                break;
            }
            case ORDINAL_MULTINOMIAL: {
                break;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)generalRegressionModel, (Enum<?>)modelType);
            }
        }
        if (targetReferenceCategory != null && (targetCategories = new ArrayList<String>(targetCategories)).remove(targetReferenceCategory)) {
            targetCategories.add(targetReferenceCategory);
        }
        return targetCategories;
    }

    private static Double getOffset(GeneralRegressionModel generalRegressionModel, EvaluationContext context) {
        FieldName offsetVariable = generalRegressionModel.getOffsetVariable();
        if (offsetVariable != null) {
            FieldValue value = GeneralRegressionModelEvaluator.getVariable(offsetVariable, context);
            return value.asDouble();
        }
        Double offsetValue = generalRegressionModel.getOffsetValue();
        if (offsetValue != null) {
            return offsetValue;
        }
        return Values.DOUBLE_ZERO;
    }

    private static Integer getTrials(GeneralRegressionModel generalRegressionModel, EvaluationContext context) {
        FieldName trialsVariable = generalRegressionModel.getTrialsVariable();
        if (trialsVariable != null) {
            FieldValue value = GeneralRegressionModelEvaluator.getVariable(trialsVariable, context);
            return value.asInteger();
        }
        Integer trialsValue = generalRegressionModel.getTrialsValue();
        if (trialsValue != null) {
            return trialsValue;
        }
        return Values.INTEGER_ONE;
    }

    private static FieldValue getVariable(FieldName name, EvaluationContext context) {
        FieldValue value = context.evaluate(name);
        if (value == null) {
            throw new MissingValueException(name);
        }
        return value;
    }

    private static BaselineStratum getBaselineStratum(BaseCumHazardTables baseCumHazardTables, FieldValue value) {
        if (baseCumHazardTables instanceof HasParsedValueMapping) {
            HasParsedValueMapping hasParsedValueMapping = (HasParsedValueMapping)baseCumHazardTables;
            return (BaselineStratum)value.getMapping(hasParsedValueMapping);
        }
        List baselineStrata = baseCumHazardTables.getBaselineStrata();
        for (BaselineStratum baselineStratum : baselineStrata) {
            if (!value.equalsString(baselineStratum.getValue())) continue;
            return baselineStratum;
        }
        return null;
    }

    private static BiMap<String, Parameter> parseParameterRegistry(ParameterList parameterList) {
        HashBiMap result = HashBiMap.create();
        if (!parameterList.hasParameters()) {
            return result;
        }
        List parameters = parameterList.getParameters();
        for (Parameter parameter : parameters) {
            result.put((Object)parameter.getName(), (Object)parameter);
        }
        return result;
    }

    private static BiMap<FieldName, Predictor> parsePredictorRegistry(PredictorList predictorList) {
        HashBiMap result = HashBiMap.create();
        if (predictorList == null || !predictorList.hasPredictors()) {
            return result;
        }
        List predictors = predictorList.getPredictors();
        for (Predictor predictor : predictors) {
            result.put((Object)predictor.getName(), (Object)predictor);
        }
        return result;
    }

    private static Map<String, Map<String, Row>> parsePPMatrix(final GeneralRegressionModel generalRegressionModel) {
        Function<List<PPCell>, Row> function = new Function<List<PPCell>, Row>(){
            private BiMap<FieldName, Predictor> factors;
            private BiMap<FieldName, Predictor> covariates;
            {
                this.factors = (BiMap)CacheUtil.getValue(generalRegressionModel, factorCache);
                this.covariates = (BiMap)CacheUtil.getValue(generalRegressionModel, covariateCache);
            }

            public Row apply(List<PPCell> ppCells) {
                Row result = new Row();
                for (PPCell ppCell : ppCells) {
                    FieldName name = ppCell.getPredictorName();
                    Predictor factor = (Predictor)this.factors.get((Object)name);
                    if (factor != null) {
                        result.addFactor(ppCell, factor);
                        continue;
                    }
                    Predictor covariate = (Predictor)this.covariates.get((Object)name);
                    if (covariate != null) {
                        result.addCovariate(ppCell);
                        continue;
                    }
                    throw new InvalidFeatureException((PMMLObject)ppCell);
                }
                return result;
            }
        };
        PPMatrix ppMatrix = generalRegressionModel.getPPMatrix();
        ListMultimap targetCategoryMap = GeneralRegressionModelEvaluator.groupByTargetCategory(ppMatrix.getPPCells());
        LinkedHashMap<String, Map<String, Row>> result = new LinkedHashMap<String, Map<String, Row>>();
        Set targetCategoryEntries = GeneralRegressionModelEvaluator.asMap(targetCategoryMap).entrySet();
        for (Map.Entry entry : targetCategoryEntries) {
            LinkedHashMap predictorMap = new LinkedHashMap();
            ListMultimap parameterNameMap = GeneralRegressionModelEvaluator.groupByParameterName((List)entry.getValue());
            Set parameterNameEntries = GeneralRegressionModelEvaluator.asMap(parameterNameMap).entrySet();
            for (Map.Entry entry2 : parameterNameEntries) {
                predictorMap.put(entry2.getKey(), function.apply(entry2.getValue()));
            }
            result.put((String)entry.getKey(), predictorMap);
        }
        return result;
    }

    private static Map<String, List<PCell>> parseParamMatrix(GeneralRegressionModel generalRegressionModel) {
        ParamMatrix paramMatrix = generalRegressionModel.getParamMatrix();
        ListMultimap targetCategoryCells = GeneralRegressionModelEvaluator.groupByTargetCategory(paramMatrix.getPCells());
        return GeneralRegressionModelEvaluator.asMap(targetCategoryCells);
    }

    private static <C extends ParameterCell> Map<String, List<C>> asMap(ListMultimap<String, C> multimap) {
        return multimap.asMap();
    }

    private static <C extends ParameterCell> ListMultimap<String, C> groupByParameterName(List<C> cells) {
        Function function = new Function<C, String>(){

            public String apply(C cell) {
                return cell.getParameterName();
            }
        };
        return GeneralRegressionModelEvaluator.groupCells(cells, function);
    }

    private static <C extends ParameterCell> ListMultimap<String, C> groupByTargetCategory(List<C> cells) {
        Function function = new Function<C, String>(){

            public String apply(C cell) {
                return cell.getTargetCategory();
            }
        };
        return GeneralRegressionModelEvaluator.groupCells(cells, function);
    }

    private static <C extends ParameterCell> ListMultimap<String, C> groupCells(List<C> cells, Function<C, String> function) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (ParameterCell cell : cells) {
            result.put(function.apply((Object)cell), (Object)cell);
        }
        return result;
    }

    private static class Row {
        private List<FactorHandler> factorHandlers = new ArrayList<FactorHandler>();
        private List<CovariateHandler> covariateHandlers = new ArrayList<CovariateHandler>();

        private Row() {
        }

        public Double evaluate(EvaluationContext context) {
            List<FactorHandler> factorHandlers = this.getFactorHandlers();
            List<CovariateHandler> covariateHandlers = this.getCovariateHandlers();
            if (factorHandlers.isEmpty() && covariateHandlers.isEmpty()) {
                return Values.DOUBLE_ONE;
            }
            Double factorProduct = Row.computeProduct(factorHandlers, context);
            Double covariateProduct = Row.computeProduct(covariateHandlers, context);
            if (covariateHandlers.isEmpty()) {
                return factorProduct;
            }
            if (factorHandlers.isEmpty()) {
                return covariateProduct;
            }
            if (factorProduct != null && covariateProduct != null) {
                return factorProduct * covariateProduct;
            }
            return null;
        }

        public void addFactor(PPCell ppCell, Predictor predictor) {
            List<FactorHandler> factorHandlers = this.getFactorHandlers();
            Matrix matrix = predictor.getMatrix();
            if (matrix != null) {
                Categories categories = predictor.getCategories();
                if (categories == null) {
                    throw new UnsupportedFeatureException((PMMLObject)predictor);
                }
                Function<Category, String> function = new Function<Category, String>(){

                    public String apply(Category category) {
                        return category.getValue();
                    }
                };
                List values = Lists.transform((List)categories.getCategories(), (Function)function);
                factorHandlers.add(new ContrastMatrixHandler(ppCell, matrix, values));
            } else {
                factorHandlers.add(new FactorHandler(ppCell));
            }
        }

        private void addCovariate(PPCell ppCell) {
            List<CovariateHandler> covariateHandlers = this.getCovariateHandlers();
            covariateHandlers.add(new CovariateHandler(ppCell));
        }

        public List<FactorHandler> getFactorHandlers() {
            return this.factorHandlers;
        }

        public List<CovariateHandler> getCovariateHandlers() {
            return this.covariateHandlers;
        }

        private static Double computeProduct(List<? extends PredictorHandler> predictorHandlers, EvaluationContext context) {
            if (predictorHandlers.isEmpty()) {
                return null;
            }
            double product = 1.0;
            int max = predictorHandlers.size();
            for (int i = 0; i < max; ++i) {
                PredictorHandler predictorHandler = predictorHandlers.get(i);
                FieldValue value = context.evaluate(predictorHandler.getPredictorName());
                if (value == null) {
                    return null;
                }
                if (max == 1) {
                    return predictorHandler.evaluate(value);
                }
                product *= predictorHandler.evaluate(value).doubleValue();
            }
            return product;
        }

        private class CovariateHandler
        extends PredictorHandler {
            private CovariateHandler(PPCell ppCell) {
                super(ppCell);
            }

            @Override
            public Double evaluate(FieldValue value) {
                double multiplicity = this.getMultiplicity();
                if (multiplicity == 1.0) {
                    return value.asDouble();
                }
                return Math.pow(value.asNumber().doubleValue(), multiplicity);
            }

            public double getMultiplicity() {
                PPCell ppCell = this.getPPCell();
                String value = ppCell.getValue();
                if ("1".equals(value) || "1.0".equals(value)) {
                    return 1.0;
                }
                return Double.parseDouble(value);
            }
        }

        private class ContrastMatrixHandler
        extends FactorHandler {
            private Matrix matrix;
            private List<String> categories;
            private List<FieldValue> parsedValueList;

            private ContrastMatrixHandler(PPCell ppCell, Matrix matrix, List<String> categories) {
                super(ppCell);
                this.matrix = null;
                this.categories = null;
                this.parsedValueList = null;
                this.setMatrix(matrix);
                this.setCategories(categories);
            }

            @Override
            public Double evaluate(FieldValue value) {
                Matrix matrix = this.getMatrix();
                int row = this.getIndex(value);
                int column = this.getIndex(this.getCategory());
                if (row < 0 || column < 0) {
                    throw new EvaluationException();
                }
                Number result = MatrixUtil.getElementAt(matrix, row + 1, column + 1);
                if (result == null) {
                    throw new EvaluationException();
                }
                if (result instanceof Double) {
                    return (Double)result;
                }
                return result.doubleValue();
            }

            public int getIndex(FieldValue value) {
                if (this.parsedValueList == null) {
                    this.parsedValueList = ImmutableList.copyOf(this.parseCategories(value.getDataType(), value.getOpType()));
                }
                return this.parsedValueList.indexOf(value);
            }

            public int getIndex(String category) {
                List<String> categories = this.getCategories();
                return categories.indexOf(category);
            }

            private List<FieldValue> parseCategories(final DataType dataType, final OpType opType) {
                List<String> categories = this.getCategories();
                Function<String, FieldValue> function = new Function<String, FieldValue>(){

                    public FieldValue apply(String value) {
                        return FieldValueUtil.create(dataType, opType, value);
                    }
                };
                return Lists.transform(categories, (Function)function);
            }

            public Matrix getMatrix() {
                return this.matrix;
            }

            private void setMatrix(Matrix matrix) {
                this.matrix = matrix;
            }

            public List<String> getCategories() {
                return this.categories;
            }

            private void setCategories(List<String> categories) {
                this.categories = categories;
            }
        }

        private class FactorHandler
        extends PredictorHandler {
            private FactorHandler(PPCell ppCell) {
                super(ppCell);
            }

            @Override
            public Double evaluate(FieldValue value) {
                PPCell ppCell = this.getPPCell();
                boolean equals = value.equals((HasValue<?>)ppCell);
                return equals ? Values.DOUBLE_ONE : Values.DOUBLE_ZERO;
            }

            public String getCategory() {
                PPCell ppCell = this.getPPCell();
                return ppCell.getValue();
            }
        }

        private abstract class PredictorHandler {
            private PPCell ppCell = null;

            private PredictorHandler(PPCell ppCell) {
                this.setPPCell(ppCell);
            }

            public abstract Double evaluate(FieldValue var1);

            public FieldName getPredictorName() {
                PPCell ppCell = this.getPPCell();
                return ppCell.getPredictorName();
            }

            public PPCell getPPCell() {
                return this.ppCell;
            }

            private void setPPCell(PPCell ppCell) {
                this.ppCell = ppCell;
            }
        }
    }
}

