/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.mining;

import com.google.common.collect.ForwardingMap;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.mining.Segment;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.HasEntityId;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;

public class SegmentResult
extends ForwardingMap<FieldName, Object>
implements HasEntityId {
    private Segment segment = null;
    private String segmentId = null;
    private Map<FieldName, ?> result = null;
    private FieldName targetFieldName = null;

    public SegmentResult(Segment segment, String segmentId, Map<FieldName, ?> result, FieldName targetFieldName) {
        this.setSegment(segment);
        this.setSegmentId(segmentId);
        this.setResult(result);
        this.setTargetFieldName(targetFieldName);
    }

    @Override
    public String getEntityId() {
        return this.getSegmentId();
    }

    public Map<FieldName, Object> delegate() {
        Map<FieldName, Object> result = this.getResult();
        return result;
    }

    public double getWeight() {
        Segment segment = this.getSegment();
        return segment.getWeight();
    }

    public Object getTargetValue() {
        FieldName targetFieldName = this.getTargetFieldName();
        return this.get(targetFieldName);
    }

    public Object getTargetValue(DataType dataType) {
        Object targetValue = EvaluatorUtil.decode(this.getTargetValue());
        try {
            return TypeUtil.cast(dataType, targetValue);
        }
        catch (TypeCheckException tce) {
            throw this.ensureContext(tce);
        }
    }

    public <V> V getTargetValue(Class<V> clazz) {
        Object targetValue = this.getTargetValue();
        try {
            return TypeUtil.cast(clazz, targetValue);
        }
        catch (TypeCheckException tce) {
            throw this.ensureContext(tce);
        }
    }

    public Segment getSegment() {
        return this.segment;
    }

    private void setSegment(Segment segment) {
        this.segment = segment;
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    private void setSegmentId(String segmentId) {
        this.segmentId = segmentId;
    }

    public Map<FieldName, ?> getResult() {
        return this.result;
    }

    private void setResult(Map<FieldName, ?> result) {
        this.result = result;
    }

    public FieldName getTargetFieldName() {
        return this.targetFieldName;
    }

    private void setTargetFieldName(FieldName targetFieldName) {
        this.targetFieldName = targetFieldName;
    }

    private <E extends PMMLException> E ensureContext(E exception) {
        Segment segment = this.getSegment();
        exception.ensureContext((PMMLObject)segment);
        return exception;
    }
}

