/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Joiner;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.OutputField;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.dmg.pmml.TypeDefinitionField;
import org.dmg.pmml.Value;
import org.dmg.pmml.association.AssociationRule;
import org.dmg.pmml.association.Item;
import org.dmg.pmml.association.ItemRef;
import org.dmg.pmml.association.Itemset;
import org.dmg.pmml.mining.MiningModel;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.HasAffinity;
import org.jpmml.evaluator.HasAffinityRanking;
import org.jpmml.evaluator.HasDisplayValue;
import org.jpmml.evaluator.HasEntityAffinity;
import org.jpmml.evaluator.HasEntityId;
import org.jpmml.evaluator.HasEntityIdRanking;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.HasReasonCodeRanking;
import org.jpmml.evaluator.HasRuleValues;
import org.jpmml.evaluator.InvalidFeatureException;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.MissingValueException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.TypeAnalysisException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedFeatureException;
import org.jpmml.evaluator.mining.MiningModelEvaluationContext;
import org.jpmml.evaluator.mining.SegmentResult;

public class OutputUtil {
    private OutputUtil() {
    }

    public static Map<FieldName, ?> evaluate(Map<FieldName, ?> predictions, ModelEvaluationContext context) {
        ModelEvaluator<?> modelEvaluator = context.getModelEvaluator();
        Object model = modelEvaluator.getModel();
        Output output = model.getOutput();
        if (output == null || !output.hasOutputFields()) {
            return predictions;
        }
        LinkedHashMap result = new LinkedHashMap(predictions);
        List outputFields = output.getOutputFields();
        for (OutputField outputField : outputFields) {
            Object value;
            FieldName targetFieldName = outputField.getTargetField();
            Object targetValue = null;
            ResultFeature resultFeature = outputField.getResultFeature();
            String segmentId = outputField.getSegmentId();
            SegmentResult segmentPredictions = null;
            if (segmentId != null) {
                if (!(model instanceof MiningModel)) {
                    throw new InvalidFeatureException((PMMLObject)outputField);
                }
                MiningModelEvaluationContext miningModelContext = (MiningModelEvaluationContext)context;
                segmentPredictions = miningModelContext.getResult(segmentId);
                if (segmentPredictions == null) continue;
                if (targetFieldName != null) {
                    if (!segmentPredictions.containsKey(targetFieldName)) {
                        throw new MissingValueException(targetFieldName, (PMMLObject)outputField);
                    }
                    targetValue = segmentPredictions.get(targetFieldName);
                } else {
                    targetValue = segmentPredictions.getTargetValue();
                }
            } else {
                switch (resultFeature) {
                    case ENTITY_ID: {
                        if (model instanceof MiningModel) {
                            targetValue = TypeUtil.cast(HasEntityId.class, predictions);
                            break;
                        }
                    }
                    default: {
                        if (targetFieldName == null) {
                            targetFieldName = modelEvaluator.getTargetFieldName();
                        }
                        if (!predictions.containsKey(targetFieldName)) {
                            throw new MissingValueException(targetFieldName, (PMMLObject)outputField);
                        }
                        targetValue = predictions.get(targetFieldName);
                    }
                }
            }
            if (targetValue == null) continue;
            block3 : switch (resultFeature) {
                case PREDICTED_VALUE: {
                    value = OutputUtil.getPredictedValue(targetValue);
                    break;
                }
                case PREDICTED_DISPLAY_VALUE: {
                    DataField dataField = modelEvaluator.getDataField(targetFieldName);
                    if (dataField == null) {
                        throw new MissingFieldException(targetFieldName, (PMMLObject)outputField);
                    }
                    Target target = modelEvaluator.getTarget(targetFieldName);
                    value = OutputUtil.getPredictedDisplayValue(targetValue, dataField, target);
                    break;
                }
                case TRANSFORMED_VALUE: 
                case DECISION: {
                    if (segmentId != null) {
                        String name = outputField.getValue();
                        if (name == null) {
                            throw new InvalidFeatureException((PMMLObject)outputField);
                        }
                        Expression expression = outputField.getExpression();
                        if (expression != null) {
                            throw new InvalidFeatureException((PMMLObject)outputField);
                        }
                        value = segmentPredictions.get(FieldName.create((String)name));
                        break;
                    }
                    Expression expression = outputField.getExpression();
                    if (expression == null) {
                        throw new InvalidFeatureException((PMMLObject)outputField);
                    }
                    value = FieldValueUtil.getValue(ExpressionUtil.evaluate(expression, (EvaluationContext)context));
                    break;
                }
                case PROBABILITY: {
                    value = OutputUtil.getProbability(targetValue, outputField);
                    break;
                }
                case RESIDUAL: {
                    FieldValue expectedTargetValue = context.evaluate(targetFieldName);
                    if (expectedTargetValue == null) {
                        throw new MissingValueException(targetFieldName, (PMMLObject)outputField);
                    }
                    DataField dataField = modelEvaluator.getDataField(targetFieldName);
                    OpType opType = dataField.getOpType();
                    switch (opType) {
                        case CONTINUOUS: {
                            value = OutputUtil.getContinuousResidual(targetValue, expectedTargetValue);
                            break block3;
                        }
                        case CATEGORICAL: {
                            value = OutputUtil.getCategoricalResidual(targetValue, expectedTargetValue);
                            break block3;
                        }
                    }
                    throw new UnsupportedFeatureException((PMMLObject)dataField, (Enum<?>)opType);
                }
                case CLUSTER_ID: {
                    value = OutputUtil.getClusterId(targetValue);
                    break;
                }
                case ENTITY_ID: {
                    if (targetValue instanceof HasRuleValues) {
                        value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.RULE_ID);
                        break;
                    }
                    value = OutputUtil.getEntityId(targetValue, outputField);
                    break;
                }
                case AFFINITY: {
                    value = OutputUtil.getAffinity(targetValue, outputField);
                    break;
                }
                case CLUSTER_AFFINITY: 
                case ENTITY_AFFINITY: {
                    String entityId = outputField.getValue();
                    if (entityId != null) {
                        value = OutputUtil.getAffinity(targetValue, outputField);
                        break;
                    }
                    value = OutputUtil.getEntityAffinity(targetValue);
                    break;
                }
                case REASON_CODE: {
                    value = OutputUtil.getReasonCode(targetValue, outputField);
                    break;
                }
                case RULE_VALUE: {
                    value = OutputUtil.getRuleValue(targetValue, outputField);
                    break;
                }
                case ANTECEDENT: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.ANTECEDENT);
                    break;
                }
                case CONSEQUENT: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.CONSEQUENT);
                    break;
                }
                case RULE: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.RULE);
                    break;
                }
                case RULE_ID: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.RULE_ID);
                    break;
                }
                case CONFIDENCE: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.CONFIDENCE);
                    break;
                }
                case SUPPORT: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.SUPPORT);
                    break;
                }
                case LIFT: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.LIFT);
                    break;
                }
                case LEVERAGE: {
                    value = OutputUtil.getRuleValue(targetValue, outputField, OutputField.RuleFeature.LEVERAGE);
                    break;
                }
                case WARNING: {
                    value = context.getWarnings();
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException((PMMLObject)outputField, (Enum<?>)resultFeature);
                }
            }
            FieldValue outputValue = FieldValueUtil.create((Field)outputField, value);
            context.declare(outputField.getName(), outputValue);
            result.put(outputField.getName(), FieldValueUtil.getValue(outputValue));
        }
        return result;
    }

    public static DataType getDataType(OutputField outputField, ModelEvaluator<?> modelEvaluator) {
        FieldName name = outputField.getName();
        DataType dataType = outputField.getDataType();
        if (dataType != null) {
            return dataType;
        }
        String segmentId = outputField.getSegmentId();
        if (segmentId != null) {
            throw new TypeAnalysisException((PMMLObject)outputField);
        }
        ResultFeature resultFeature = outputField.getResultFeature();
        switch (resultFeature) {
            case PREDICTED_VALUE: 
            case TRANSFORMED_VALUE: 
            case DECISION: {
                OutputField evaluatorOutputField = modelEvaluator.getOutputField(name);
                if (outputField.equals(evaluatorOutputField)) break;
                throw new TypeAnalysisException((PMMLObject)outputField);
            }
        }
        switch (resultFeature) {
            case PREDICTED_VALUE: {
                DataField dataField;
                FieldName targetFieldName = outputField.getTargetField();
                if (targetFieldName == null) {
                    targetFieldName = modelEvaluator.getTargetFieldName();
                }
                if ((dataField = modelEvaluator.getDataField(targetFieldName)) == null) {
                    throw new MissingFieldException(targetFieldName, (PMMLObject)outputField);
                }
                return dataField.getDataType();
            }
            case PREDICTED_DISPLAY_VALUE: {
                return DataType.STRING;
            }
            case TRANSFORMED_VALUE: 
            case DECISION: {
                Expression expression = outputField.getExpression();
                if (expression == null) {
                    throw new InvalidFeatureException((PMMLObject)outputField);
                }
                return ExpressionUtil.getDataType(expression, modelEvaluator);
            }
            case PROBABILITY: 
            case RESIDUAL: 
            case STANDARD_ERROR: {
                return DataType.DOUBLE;
            }
            case ENTITY_ID: 
            case CLUSTER_ID: {
                return DataType.STRING;
            }
            case AFFINITY: 
            case CLUSTER_AFFINITY: 
            case ENTITY_AFFINITY: {
                return DataType.DOUBLE;
            }
            case REASON_CODE: {
                return DataType.STRING;
            }
            case RULE_VALUE: {
                return OutputUtil.getRuleDataType(outputField);
            }
            case ANTECEDENT: {
                return OutputUtil.getRuleDataType(outputField, OutputField.RuleFeature.ANTECEDENT);
            }
            case CONSEQUENT: {
                return OutputUtil.getRuleDataType(outputField, OutputField.RuleFeature.CONSEQUENT);
            }
            case RULE: {
                return OutputUtil.getRuleDataType(outputField, OutputField.RuleFeature.RULE);
            }
            case RULE_ID: {
                return OutputUtil.getRuleDataType(outputField, OutputField.RuleFeature.RULE_ID);
            }
            case SUPPORT: {
                return OutputUtil.getRuleDataType(outputField, OutputField.RuleFeature.SUPPORT);
            }
            case CONFIDENCE: {
                return OutputUtil.getRuleDataType(outputField, OutputField.RuleFeature.CONFIDENCE);
            }
            case LIFT: {
                return OutputUtil.getRuleDataType(outputField, OutputField.RuleFeature.LIFT);
            }
            case LEVERAGE: {
                return OutputUtil.getRuleDataType(outputField, OutputField.RuleFeature.LEVERAGE);
            }
            case WARNING: {
                throw new TypeAnalysisException((PMMLObject)outputField);
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)outputField, (Enum<?>)resultFeature);
    }

    private static Object getPredictedValue(Object object) {
        return EvaluatorUtil.decode(object);
    }

    private static Object getPredictedDisplayValue(Object object, DataField dataField, Target target) {
        String displayValue;
        TargetValue targetValue;
        if (object instanceof HasDisplayValue) {
            HasDisplayValue hasDisplayValue = TypeUtil.cast(HasDisplayValue.class, object);
            return hasDisplayValue.getDisplayValue();
        }
        object = OutputUtil.getPredictedValue(object);
        if (target != null && (targetValue = TargetUtil.getTargetValue(target, object)) != null && (displayValue = targetValue.getDisplayValue()) != null) {
            return displayValue;
        }
        OpType opType = dataField.getOpType();
        switch (opType) {
            case CONTINUOUS: {
                break;
            }
            case CATEGORICAL: 
            case ORDINAL: {
                String displayValue2;
                Value value = FieldValueUtil.getValidValue((TypeDefinitionField)dataField, object);
                if (value == null || (displayValue2 = value.getDisplayValue()) == null) break;
                return displayValue2;
            }
            default: {
                throw new UnsupportedFeatureException((PMMLObject)dataField, (Enum<?>)opType);
            }
        }
        return object;
    }

    private static Double getProbability(Object object, OutputField outputField) {
        HasProbability hasProbability = TypeUtil.cast(HasProbability.class, object);
        String value = OutputUtil.getCategoryValue(object, outputField);
        return hasProbability.getProbability(value);
    }

    private static String getCategoryValue(Object object, OutputField outputField) {
        String value = outputField.getValue();
        if (value == null) {
            return TypeUtil.format(OutputUtil.getPredictedValue(object));
        }
        return value;
    }

    private static Double getContinuousResidual(Object object, FieldValue expectedObject) {
        Number value = (Number)OutputUtil.getPredictedValue(object);
        Number expectedValue = (Number)FieldValueUtil.getValue(expectedObject);
        return expectedValue.doubleValue() - value.doubleValue();
    }

    public static Double getCategoricalResidual(Object object, FieldValue expectedObject) {
        String expectedValue;
        HasProbability hasProbability = TypeUtil.cast(HasProbability.class, object);
        String value = TypeUtil.format(OutputUtil.getPredictedValue(object));
        boolean equals = TypeUtil.equals(DataType.STRING, value, expectedValue = TypeUtil.format(FieldValueUtil.getValue(expectedObject)));
        return (equals ? 1.0 : 0.0) - hasProbability.getProbability(value);
    }

    private static String getClusterId(Object object) {
        HasEntityId hasEntityId = TypeUtil.cast(HasEntityId.class, object);
        return hasEntityId.getEntityId();
    }

    private static String getEntityId(Object object, OutputField outputField) {
        HasEntityId hasEntityId = TypeUtil.cast(HasEntityId.class, object);
        int rank = outputField.getRank();
        if (rank <= 0) {
            throw new InvalidFeatureException((PMMLObject)outputField);
        }
        if (rank > 1) {
            HasEntityIdRanking hasEntityIdRanking = TypeUtil.cast(HasEntityIdRanking.class, object);
            OutputField.RankOrder rankOrder = outputField.getRankOrder();
            switch (rankOrder) {
                case DESCENDING: {
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException((PMMLObject)outputField, (Enum<?>)rankOrder);
                }
            }
            return OutputUtil.getElement(hasEntityIdRanking.getEntityIdRanking(), rank);
        }
        return hasEntityId.getEntityId();
    }

    public static Double getAffinity(Object object, OutputField outputField) {
        HasAffinity hasAffinity = TypeUtil.cast(HasAffinity.class, object);
        int rank = outputField.getRank();
        if (rank <= 0) {
            throw new InvalidFeatureException((PMMLObject)outputField);
        }
        if (rank > 1) {
            HasAffinityRanking hasAffinityRanking = TypeUtil.cast(HasAffinityRanking.class, object);
            OutputField.RankOrder rankOrder = outputField.getRankOrder();
            switch (rankOrder) {
                case DESCENDING: {
                    break;
                }
                default: {
                    throw new UnsupportedFeatureException((PMMLObject)outputField, (Enum<?>)rankOrder);
                }
            }
            return OutputUtil.getElement(hasAffinityRanking.getAffinityRanking(), rank);
        }
        String value = OutputUtil.getCategoryValue(object, outputField);
        return hasAffinity.getAffinity(value);
    }

    public static Double getEntityAffinity(Object object) {
        HasEntityAffinity hasEntityAffinity = TypeUtil.cast(HasEntityAffinity.class, object);
        return hasEntityAffinity.getEntityAffinity();
    }

    public static String getReasonCode(Object object, OutputField outputField) {
        HasReasonCodeRanking hasReasonCodeRanking = TypeUtil.cast(HasReasonCodeRanking.class, object);
        int rank = outputField.getRank();
        if (rank <= 0) {
            throw new InvalidFeatureException((PMMLObject)outputField);
        }
        return OutputUtil.getElement(hasReasonCodeRanking.getReasonCodeRanking(), rank);
    }

    public static Object getRuleValue(Object object, OutputField outputField, OutputField.RuleFeature ruleFeature) {
        HasRuleValues hasRuleValues = TypeUtil.cast(HasRuleValues.class, object);
        List<AssociationRule> associationRules = OutputUtil.getRuleValues(hasRuleValues, outputField);
        String isMultiValued = outputField.getIsMultiValued();
        if (!"0".equals(isMultiValued)) {
            throw new UnsupportedFeatureException((PMMLObject)outputField);
        }
        int rank = outputField.getRank();
        if (rank <= 0) {
            throw new InvalidFeatureException((PMMLObject)outputField);
        }
        AssociationRule associationRule = OutputUtil.getElement(associationRules, rank);
        if (associationRule != null) {
            return OutputUtil.getRuleFeature(hasRuleValues, associationRule, (PMMLObject)outputField, ruleFeature);
        }
        return null;
    }

    public static Object getRuleValue(Object object, OutputField outputField) {
        HasRuleValues hasRuleValues = TypeUtil.cast(HasRuleValues.class, object);
        List<AssociationRule> associationRules = OutputUtil.getRuleValues(hasRuleValues, outputField);
        String isMultiValued = outputField.getIsMultiValued();
        if ("0".equals(isMultiValued)) {
            int rank = outputField.getRank();
            if (rank <= 0) {
                throw new InvalidFeatureException((PMMLObject)outputField);
            }
            AssociationRule associationRule = OutputUtil.getElement(associationRules, rank);
            if (associationRule != null) {
                return OutputUtil.getRuleFeature(hasRuleValues, associationRule, outputField);
            }
            return null;
        }
        if ("1".equals(isMultiValued)) {
            int rank = outputField.getRank();
            if (rank < 0) {
                throw new InvalidFeatureException((PMMLObject)outputField);
            }
            int size = rank == 0 ? associationRules.size() : Math.min(rank, associationRules.size());
            associationRules = associationRules.subList(0, size);
            ArrayList<Object> result = new ArrayList<Object>(associationRules.size());
            for (AssociationRule associationRule : associationRules) {
                result.add(OutputUtil.getRuleFeature(hasRuleValues, associationRule, outputField));
            }
            return result;
        }
        throw new InvalidFeatureException((PMMLObject)outputField);
    }

    private static List<AssociationRule> getRuleValues(HasRuleValues hasRuleValues, final OutputField outputField) {
        List<AssociationRule> associationRules = hasRuleValues.getRuleValues(outputField.getAlgorithm());
        Comparator<AssociationRule> comparator = new Comparator<AssociationRule>(){
            private OutputField.RankBasis rankBasis;
            private OutputField.RankOrder rankOrder;
            {
                this.rankBasis = outputField.getRankBasis();
                this.rankOrder = outputField.getRankOrder();
            }

            @Override
            public int compare(AssociationRule left, AssociationRule right) {
                int order;
                switch (this.rankBasis) {
                    case CONFIDENCE: {
                        order = this.getConfidence(left).compareTo(this.getConfidence(right));
                        break;
                    }
                    case SUPPORT: {
                        order = this.getSupport(left).compareTo(this.getSupport(right));
                        break;
                    }
                    case LIFT: {
                        order = this.getLift(left).compareTo(this.getLift(right));
                        break;
                    }
                    case LEVERAGE: {
                        order = this.getLeverage(left).compareTo(this.getLeverage(right));
                        break;
                    }
                    case AFFINITY: {
                        order = this.getAffinity(left).compareTo(this.getAffinity(right));
                        break;
                    }
                    default: {
                        throw new UnsupportedFeatureException((PMMLObject)outputField, (Enum<?>)this.rankBasis);
                    }
                }
                switch (this.rankOrder) {
                    case ASCENDING: {
                        return order;
                    }
                    case DESCENDING: {
                        return -order;
                    }
                }
                throw new UnsupportedFeatureException((PMMLObject)outputField, (Enum<?>)this.rankOrder);
            }

            private Double getConfidence(AssociationRule rule) {
                return this.checkRuleFeature(rule, rule.getConfidence());
            }

            private Double getSupport(AssociationRule rule) {
                return this.checkRuleFeature(rule, rule.getSupport());
            }

            private Double getLift(AssociationRule rule) {
                return this.checkRuleFeature(rule, rule.getLift());
            }

            private Double getLeverage(AssociationRule rule) {
                return this.checkRuleFeature(rule, rule.getLeverage());
            }

            private Double getAffinity(AssociationRule rule) {
                return this.checkRuleFeature(rule, rule.getAffinity());
            }

            private <V> V checkRuleFeature(AssociationRule rule, V value) {
                if (value == null) {
                    throw new InvalidFeatureException((PMMLObject)rule);
                }
                return value;
            }
        };
        Ordering ordering = Ordering.from((Comparator)comparator);
        return ordering.sortedCopy(associationRules);
    }

    private static Object getRuleFeature(HasRuleValues hasRuleValues, AssociationRule associationRule, OutputField outputField) {
        return OutputUtil.getRuleFeature(hasRuleValues, associationRule, (PMMLObject)outputField, outputField.getRuleFeature());
    }

    private static Object getRuleFeature(HasRuleValues hasRuleValues, AssociationRule associationRule, PMMLObject element, OutputField.RuleFeature ruleFeature) {
        switch (ruleFeature) {
            case ANTECEDENT: {
                return OutputUtil.getItemValues(hasRuleValues, associationRule.getAntecedent());
            }
            case CONSEQUENT: {
                return OutputUtil.getItemValues(hasRuleValues, associationRule.getConsequent());
            }
            case RULE: {
                Joiner joiner = Joiner.on((char)',');
                StringBuilder sb = new StringBuilder();
                String left = joiner.join(OutputUtil.getItemValues(hasRuleValues, associationRule.getAntecedent()));
                sb.append('{').append(left).append('}');
                sb.append("->");
                String right = joiner.join(OutputUtil.getItemValues(hasRuleValues, associationRule.getConsequent()));
                sb.append('{').append(right).append('}');
                return sb.toString();
            }
            case RULE_ID: {
                HasEntityRegistry hasEntityRegistry = (HasEntityRegistry)((Object)hasRuleValues);
                return EntityUtil.getId(associationRule, hasEntityRegistry);
            }
            case CONFIDENCE: {
                return associationRule.getConfidence();
            }
            case SUPPORT: {
                return associationRule.getSupport();
            }
            case LIFT: {
                return associationRule.getLift();
            }
            case LEVERAGE: {
                return associationRule.getLeverage();
            }
            case AFFINITY: {
                return associationRule.getAffinity();
            }
        }
        throw new UnsupportedFeatureException(element, (Enum<?>)ruleFeature);
    }

    private static DataType getRuleDataType(OutputField outputField) {
        return OutputUtil.getRuleDataType(outputField, outputField.getRuleFeature());
    }

    private static DataType getRuleDataType(OutputField outputField, OutputField.RuleFeature ruleFeature) {
        String isMultiValued = outputField.getIsMultiValued();
        if (!"0".equals(isMultiValued)) {
            throw new TypeAnalysisException((PMMLObject)outputField);
        }
        switch (ruleFeature) {
            case ANTECEDENT: 
            case CONSEQUENT: {
                throw new TypeAnalysisException((PMMLObject)outputField);
            }
            case RULE: 
            case RULE_ID: {
                return DataType.STRING;
            }
            case CONFIDENCE: 
            case SUPPORT: 
            case LIFT: 
            case LEVERAGE: 
            case AFFINITY: {
                return DataType.DOUBLE;
            }
        }
        throw new UnsupportedFeatureException((PMMLObject)outputField, (Enum<?>)ruleFeature);
    }

    private static List<String> getItemValues(HasRuleValues hasRuleValues, String id) {
        Map<String, Item> items = hasRuleValues.getItems();
        Map<String, Itemset> itemsets = hasRuleValues.getItemsets();
        Itemset itemset = itemsets.get(id);
        List itemRefs = itemset.getItemRefs();
        ArrayList<String> result = new ArrayList<String>(itemRefs.size());
        int max = itemRefs.size();
        for (int i = 0; i < max; ++i) {
            ItemRef itemRef = (ItemRef)itemRefs.get(i);
            Item item = items.get(itemRef.getItemRef());
            result.add(item.getValue());
        }
        return result;
    }

    private static <E> E getElement(List<E> elements, int rank) {
        int index = rank - 1;
        if (index < elements.size()) {
            return elements.get(index);
        }
        return null;
    }
}

