/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.jpmml.evaluator.ComplexDoubleVector;
import org.jpmml.evaluator.Report;
import org.jpmml.evaluator.ReportingDoubleValue;

public abstract class ReportingComplexDoubleVector
extends ComplexDoubleVector {
    private String expression = "";

    public ReportingComplexDoubleVector(int capacity) {
        super(capacity);
    }

    public ReportingComplexDoubleVector(int capacity, String expression) {
        super(capacity);
        if (expression != null) {
            this.report(expression);
        }
    }

    protected abstract Report newReport();

    @Override
    public ReportingComplexDoubleVector add(double value) {
        ReportingComplexDoubleVector result = (ReportingComplexDoubleVector)super.add(value);
        this.report(new StringBuilder(256).append(this.getExpression()).append("<cn>").append(value).append("</cn>").toString());
        return result;
    }

    @Override
    public ReportingComplexDoubleVector add(Number value) {
        ReportingComplexDoubleVector result = (ReportingComplexDoubleVector)super.add(value);
        this.report(new StringBuilder(256).append(this.getExpression()).append("<cn>").append(value.doubleValue()).append("</cn>").toString());
        return result;
    }

    @Override
    public ReportingComplexDoubleVector add(double coefficient, Number factor) {
        ReportingComplexDoubleVector result = (ReportingComplexDoubleVector)super.add(coefficient, factor);
        this.report(new StringBuilder(256).append(this.getExpression()).append("<apply><times/>").append("<cn>").append(coefficient).append("</cn>").append("<cn>").append(factor.doubleValue()).append("</cn>").append("</apply>").toString());
        return result;
    }

    public ReportingDoubleValue get(int index) {
        return new ReportingDoubleValue(this.doubleValue(index), this.newReport());
    }

    public ReportingDoubleValue max() {
        return new ReportingDoubleValue(this.doubleMax(), this.newReport(), new StringBuilder(256).append("<apply><max/>").append(this.getExpression()).append("</apply>").toString());
    }

    public ReportingDoubleValue median() {
        return new ReportingDoubleValue(this.doubleMedian(), this.newReport(), new StringBuilder(256).append("<apply><median/>").append(this.getExpression()).append("</apply>").toString());
    }

    public ReportingDoubleValue sum() {
        return new ReportingDoubleValue(this.doubleSum(), this.newReport(), new StringBuilder(256).append("<apply><plus/>").append(this.getExpression()).append("</apply>").toString());
    }

    private void report(String expression) {
        this.setExpression(expression);
    }

    public String getExpression() {
        return this.expression;
    }

    private void setExpression(String expression) {
        this.expression = expression;
    }
}

