/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import org.jpmml.evaluator.FloatValue;
import org.jpmml.evaluator.HasReport;
import org.jpmml.evaluator.Report;
import org.jpmml.evaluator.Value;

public class ReportingFloatValue
extends FloatValue
implements HasReport {
    private Report report = null;

    public ReportingFloatValue(float value, Report report) {
        super(value);
        this.setReport(report);
        this.report(new StringBuilder(256).append("<cn>").append(value).append("</cn>").toString());
    }

    public ReportingFloatValue(float value, Report report, String expression) {
        super(value);
        this.setReport(report);
        if (expression != null) {
            this.report(expression);
        }
    }

    @Override
    public ReportingFloatValue copy() {
        Report report = this.getReport();
        return new ReportingFloatValue(this.value, report.copy(), null);
    }

    @Override
    public ReportingFloatValue add(double value) {
        ReportingFloatValue result = (ReportingFloatValue)super.add(value);
        if (this.hasExpression()) {
            this.report(new StringBuilder(256).append("<apply><plus/>").append(this.getExpression()).append("<cn>").append((float)value).append("</cn>").append("</apply>").toString());
        } else {
            this.report(new StringBuilder(256).append("<cn>").append((float)value).append("</cn>").toString());
        }
        return result;
    }

    @Override
    public ReportingFloatValue add(Value<? extends Number> value) {
        ReportingFloatValue result = (ReportingFloatValue)super.add((Value)value);
        if (this.hasExpression()) {
            this.report(new StringBuilder(256).append("<apply><plus/>").append(this.getExpression()).append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
        } else {
            this.report(new StringBuilder(256).append("<cn>").append(value.floatValue()).append("</cn>").toString());
        }
        return result;
    }

    @Override
    public ReportingFloatValue add(double coefficient, Number factor) {
        ReportingFloatValue result = (ReportingFloatValue)super.add(coefficient, factor);
        if (this.hasExpression()) {
            this.report(new StringBuilder(256).append("<apply><plus/>").append(this.getExpression()).append("<apply><times/>").append("<cn>").append((float)coefficient).append("</cn>").append("<cn>").append(factor.floatValue()).append("</cn>").append("</apply></apply>").toString());
        } else {
            this.report(new StringBuilder(256).append("<apply><times/>").append("<cn>").append((float)coefficient).append("</cn>").append("<cn>").append(factor.floatValue()).append("</cn>").append("</apply>").toString());
        }
        return result;
    }

    @Override
    public ReportingFloatValue add(double coefficient, Number factor, int exponent) {
        ReportingFloatValue result = (ReportingFloatValue)super.add(coefficient, factor, exponent);
        if (this.hasExpression()) {
            this.report(new StringBuilder(256).append("<apply><plus/>").append(this.getExpression()).append("<apply><times/>").append("<cn>").append((float)coefficient).append("</cn>").append("<apply><power/>").append("<cn>").append(factor.floatValue()).append("</cn>").append("<cn>").append((float)exponent).append("</cn>").append("</apply></apply></apply>").toString());
        } else {
            this.report(new StringBuilder(256).append("<apply><times/>").append("<cn>").append((float)coefficient).append("</cn>").append("<apply><power/>").append("<cn>").append(factor.floatValue()).append("</cn>").append("<cn>").append((float)exponent).append("</cn>").append("</apply></apply>").toString());
        }
        return result;
    }

    @Override
    public ReportingFloatValue add(double coefficient, List<? extends Number> factors) {
        ReportingFloatValue result = (ReportingFloatValue)super.add(coefficient, (List)factors);
        if (this.hasExpression()) {
            this.report(new StringBuilder(256).append("<apply><plus/>").append(this.getExpression()).append("<apply><times/>").append("<cn>").append((float)coefficient).append("</cn>").append(ReportingFloatValue.format(factors)).append("</apply></apply>").toString());
        } else {
            this.report(new StringBuilder(256).append("<apply><times/>").append("<cn>").append((float)coefficient).append("</cn>").append(ReportingFloatValue.format(factors)).append("</apply>").toString());
        }
        return result;
    }

    @Override
    public ReportingFloatValue subtract(double value) {
        ReportingFloatValue result = (ReportingFloatValue)super.subtract(value);
        if (this.hasExpression()) {
            this.report(new StringBuilder(256).append("<apply><minus/>").append(this.getExpression()).append("<cn>").append((float)value).append("</cn>").append("</apply>").toString());
        } else {
            this.report(new StringBuilder(256).append("<apply><minus/>").append("<cn>").append((float)value).append("</cn>").append("</apply>").toString());
        }
        return result;
    }

    @Override
    public ReportingFloatValue subtract(Value<? extends Number> value) {
        ReportingFloatValue result = (ReportingFloatValue)super.subtract((Value)value);
        if (this.hasExpression()) {
            this.report(new StringBuilder(256).append("<apply><minus/>").append(this.getExpression()).append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
        } else {
            this.report(new StringBuilder(256).append("<apply><minus/>").append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
        }
        return result;
    }

    @Override
    public ReportingFloatValue multiply(double value) {
        ReportingFloatValue result = (ReportingFloatValue)super.multiply(value);
        this.report(new StringBuilder(256).append("<apply><times/>").append(this.getExpression()).append("<cn>").append((float)value).append("</cn>").append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue multiply(Value<? extends Number> value) {
        ReportingFloatValue result = (ReportingFloatValue)super.multiply((Value)value);
        this.report(new StringBuilder(256).append("<apply><times/>").append(this.getExpression()).append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue multiply(Number factor, double exponent) {
        ReportingFloatValue result = (ReportingFloatValue)super.multiply(factor, exponent);
        this.report(new StringBuilder(256).append("<apply><times/>").append(this.getExpression()).append("<apply><power/>").append("<cn>").append(factor.floatValue()).append("</cn>").append("<cn>").append((float)exponent).append("</cn>").append("</apply></apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue divide(double value) {
        ReportingFloatValue result = (ReportingFloatValue)super.divide(value);
        this.report(new StringBuilder(256).append("<apply><divide/>").append(this.getExpression()).append("<cn>").append((float)value).append("</cn>").append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue divide(Value<? extends Number> value) {
        ReportingFloatValue result = (ReportingFloatValue)super.divide((Value)value);
        this.report(new StringBuilder(256).append("<apply><divide/>").append(this.getExpression()).append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue residual(Value<? extends Number> value) {
        ReportingFloatValue result = (ReportingFloatValue)super.residual((Value)value);
        this.report(new StringBuilder(256).append("<apply><minus/><cn>1</cn>").append("<cn>").append(value.floatValue()).append("</cn>").append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue square() {
        ReportingFloatValue result = (ReportingFloatValue)super.square();
        this.report(new StringBuilder(256).append("<apply><power/>").append(this.getExpression()).append("<cn>2</cn></apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue reciprocal() {
        ReportingFloatValue result = (ReportingFloatValue)super.reciprocal();
        this.report(new StringBuilder(256).append("<apply><divide/><cn>1</cn>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue elliott() {
        ReportingFloatValue result = (ReportingFloatValue)super.elliott();
        this.report(new StringBuilder(256).append("<apply><ci>elliott</ci>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue exp() {
        ReportingFloatValue result = (ReportingFloatValue)super.exp();
        this.report(new StringBuilder(256).append("<apply><exp/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue gauss() {
        ReportingFloatValue result = (ReportingFloatValue)super.gauss();
        this.report(new StringBuilder(256).append("<apply><ci>gauss</ci>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue inverseLogit() {
        ReportingFloatValue result = (ReportingFloatValue)super.inverseLogit();
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>logit</ci></apply>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue inverseCloglog() {
        ReportingFloatValue result = (ReportingFloatValue)super.inverseCloglog();
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>cloglog</ci></apply>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue inverseLoglog() {
        ReportingFloatValue result = (ReportingFloatValue)super.inverseLoglog();
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>loglog</ci></apply>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue inverseLogc() {
        ReportingFloatValue result = (ReportingFloatValue)super.inverseLogc();
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>logc</ci></apply>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue inverseNegbin(double value) {
        ReportingFloatValue result = (ReportingFloatValue)super.inverseNegbin(value);
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>negbin</ci></apply>").append(this.getExpression()).append("<cn>").append((float)value).append("</cn>").append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue inverseOddspower(double value) {
        ReportingFloatValue result = (ReportingFloatValue)super.inverseOddspower(value);
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>oddspower</ci></apply>").append(this.getExpression()).append("<cn>").append((float)value).append("</cn>").append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue inversePower(double value) {
        ReportingFloatValue result = (ReportingFloatValue)super.inversePower(value);
        this.report(new StringBuilder(256).append("<apply><power/>").append(this.getExpression()).append("<apply><divide/><cn>1</cn>").append("<cn>").append((float)value).append("</cn>").append("</apply></apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue inverseCauchit() {
        ReportingFloatValue result = (ReportingFloatValue)super.inverseCauchit();
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>cauchit</ci></apply>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue inverseProbit() {
        ReportingFloatValue result = (ReportingFloatValue)super.inverseProbit();
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>probit</ci></apply>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue sin() {
        ReportingFloatValue result = (ReportingFloatValue)super.sin();
        this.report(new StringBuilder(256).append("<apply><sin/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue cos() {
        ReportingFloatValue result = (ReportingFloatValue)super.cos();
        this.report(new StringBuilder(256).append("<apply><cos/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue atan() {
        ReportingFloatValue result = (ReportingFloatValue)super.atan();
        this.report(new StringBuilder(256).append("<apply><arctan/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue tanh() {
        ReportingFloatValue result = (ReportingFloatValue)super.tanh();
        this.report(new StringBuilder(256).append("<apply><tanh/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue threshold(double value) {
        ReportingFloatValue result = (ReportingFloatValue)super.threshold(value);
        this.report(new StringBuilder(256).append("<apply><ci>threshold</ci>").append(this.getExpression()).append("<cn>").append((float)value).append("</cn>").append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue relu() {
        ReportingFloatValue result = (ReportingFloatValue)super.relu();
        this.report(new StringBuilder(256).append("<apply><max/><cn>0</cn>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue restrict(double lowValue, double highValue) {
        ReportingFloatValue result = (ReportingFloatValue)super.restrict(lowValue, highValue);
        this.report(new StringBuilder(256).append("<apply><max/>").append("<cn>").append((float)lowValue).append("</cn>").append("<apply><min/>").append("<cn>").append((float)highValue).append("</cn>").append(this.getExpression()).append("</apply></apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue round() {
        ReportingFloatValue result = (ReportingFloatValue)super.round();
        this.report(new StringBuilder(256).append("<apply><ci>round</ci>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue ceiling() {
        ReportingFloatValue result = (ReportingFloatValue)super.ceiling();
        this.report(new StringBuilder(256).append("<apply><ceiling/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue floor() {
        ReportingFloatValue result = (ReportingFloatValue)super.floor();
        this.report(new StringBuilder(256).append("<apply><floor/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingFloatValue denormalize(double leftOrig, double leftNorm, double rightOrig, double rightNorm) {
        ReportingFloatValue result = (ReportingFloatValue)super.denormalize(leftOrig, leftNorm, rightOrig, rightNorm);
        this.report(new StringBuilder(256).append("<apply><ci>denormalize</ci>").append(this.getExpression()).append("<cn>").append((float)leftOrig).append("</cn>").append("<cn>").append((float)leftNorm).append("</cn>").append("<cn>").append((float)rightOrig).append("</cn>").append("<cn>").append((float)rightNorm).append("</cn>").append("</apply>").toString());
        return result;
    }

    private void report(String expression) {
        Report report = this.getReport();
        Report.Entry entry = new Report.Entry(expression, this.getValue());
        report.add(entry);
    }

    private boolean hasExpression() {
        Report report = this.getReport();
        return report.hasEntries();
    }

    private String getExpression() {
        Report report = this.getReport();
        Report.Entry entry = report.tailEntry();
        return entry.getExpression();
    }

    @Override
    public Report getReport() {
        return this.report;
    }

    private void setReport(Report report) {
        this.report = report;
    }

    private static String format(List<? extends Number> values) {
        StringBuilder sb = new StringBuilder(values.size() * 32);
        for (Number number : values) {
            sb.append("<cn>").append(number.floatValue()).append("</cn>").toString();
        }
        return sb.toString();
    }
}

