/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.jpmml.evaluator.FloatVector;

public class SimpleFloatVector
extends FloatVector {
    private int size = 0;
    private float sum = 0.0f;
    private float max = -3.4028235E38f;

    @Override
    public int size() {
        return this.size;
    }

    public FloatVector add(double value) {
        return this.addInternal((float)value);
    }

    public FloatVector add(Number value) {
        return this.addInternal(value.floatValue());
    }

    public FloatVector add(double coefficient, Number factor) {
        return this.addInternal((float)coefficient * factor.floatValue());
    }

    private FloatVector addInternal(float value) {
        this.sum += value;
        this.max = Math.max(this.max, value);
        ++this.size;
        return this;
    }

    @Override
    public float floatValue(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float floatSum() {
        return this.sum;
    }

    @Override
    public float floatMax() {
        if (this.size == 0) {
            throw new IllegalStateException();
        }
        return this.max;
    }

    @Override
    public float floatMedian() {
        throw new UnsupportedOperationException();
    }
}

