/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DataType;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.HasProbability;

public class VoteDistribution
extends Classification
implements HasProbability {
    private Double sum = null;

    public VoteDistribution() {
        super(Classification.Type.VOTE);
    }

    public VoteDistribution(Map<String, Double> votes) {
        super(Classification.Type.VOTE, votes);
    }

    @Override
    public void computeResult(DataType dataType) {
        super.computeResult(dataType);
        double sum = 0.0;
        Collection<Double> values = this.values();
        for (Double value : values) {
            sum += value.doubleValue();
        }
        this.sum = sum;
    }

    @Override
    public Set<String> getCategoryValues() {
        return this.keySet();
    }

    @Override
    public Double getProbability(String value) {
        if (this.sum == null) {
            throw new EvaluationException();
        }
        return this.get(value) / this.sum;
    }
}

