/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.neural_network;

import java.util.Collection;
import org.dmg.pmml.neural_network.NeuralNetwork;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueUtil;

public class NeuralNetworkUtil {
    private NeuralNetworkUtil() {
    }

    public static <V extends Number> Value<V> activateNeuronOutput(Value<V> value, Double threshold, NeuralNetwork.ActivationFunction activationFunction) {
        switch (activationFunction) {
            case THRESHOLD: {
                if (threshold == null) {
                    throw new EvaluationException();
                }
                return value.threshold(threshold);
            }
            case LOGISTIC: {
                return value.inverseLogit();
            }
            case TANH: {
                return value.tanh();
            }
            case IDENTITY: {
                return value;
            }
            case EXPONENTIAL: {
                return value.exp();
            }
            case RECIPROCAL: {
                return value.reciprocal();
            }
            case SQUARE: {
                return value.square();
            }
            case GAUSS: {
                return value.gauss();
            }
            case SINE: {
                return value.sin();
            }
            case COSINE: {
                return value.cos();
            }
            case ELLIOTT: {
                return value.elliott();
            }
            case ARCTAN: {
                return value.atan();
            }
            case RECTIFIER: {
                return value.relu();
            }
        }
        throw new EvaluationException();
    }

    public static <V extends Number> Collection<Value<V>> normalizeNeuralLayerOutputs(Collection<Value<V>> values, NeuralNetwork.NormalizationMethod normalizationMethod) {
        switch (normalizationMethod) {
            case NONE: {
                break;
            }
            case SIMPLEMAX: {
                ValueUtil.normalizeSimpleMax(values);
                break;
            }
            case SOFTMAX: {
                ValueUtil.normalizeSoftMax(values);
                break;
            }
            default: {
                throw new EvaluationException();
            }
        }
        return values;
    }
}

