/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.regression;

import java.util.Iterator;
import org.dmg.pmml.regression.RegressionModel;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.ValueUtil;

public class RegressionModelUtil {
    private RegressionModelUtil() {
    }

    public static <K, V extends Number> ValueMap<K, V> computeBinomialProbabilities(ValueMap<K, V> values, RegressionModel.NormalizationMethod normalizationMethod) {
        if (values.size() != 2) {
            throw new EvaluationException();
        }
        Iterator<Value<V>> valueIt = values.iterator();
        Value<V> firstValue = valueIt.next();
        RegressionModelUtil.normalizeBinaryLogisticClassificationResult(firstValue, normalizationMethod);
        Value<V> secondValue = valueIt.next();
        secondValue.residual(firstValue);
        return values;
    }

    public static <K, V extends Number> ValueMap<K, V> computeMultinomialProbabilities(ValueMap<K, V> values, RegressionModel.NormalizationMethod normalizationMethod) {
        if (values.size() < 2) {
            throw new EvaluationException();
        }
        switch (normalizationMethod) {
            case NONE: {
                Value<V> sum = null;
                Iterator<Value<V>> valueIt = values.iterator();
                int max = values.size() - 1;
                for (int i = 0; i < max; ++i) {
                    Value<V> value = valueIt.next();
                    if (sum == null) {
                        sum = value.copy();
                        continue;
                    }
                    sum.add(value);
                }
                Value<V> lastValue = valueIt.next();
                lastValue.residual(sum);
                break;
            }
            case LOGIT: {
                for (Value<V> value : values) {
                    value.inverseLogit();
                }
            }
            case SIMPLEMAX: {
                ValueUtil.normalizeSimpleMax(values);
                break;
            }
            case SOFTMAX: {
                ValueUtil.normalizeSoftMax(values);
                break;
            }
            default: {
                throw new EvaluationException();
            }
        }
        return values;
    }

    public static <K, V extends Number> ValueMap<K, V> computeOrdinalProbabilities(ValueMap<K, V> values, RegressionModel.NormalizationMethod normalizationMethod) {
        if (values.size() < 2) {
            throw new EvaluationException();
        }
        switch (normalizationMethod) {
            case NONE: 
            case LOGIT: 
            case PROBIT: 
            case CLOGLOG: 
            case LOGLOG: 
            case CAUCHIT: {
                Value<V> sum = null;
                Iterator<Value<V>> valueIt = values.iterator();
                int max = values.size() - 1;
                for (int i = 0; i < max; ++i) {
                    Value<V> value = valueIt.next();
                    RegressionModelUtil.normalizeBinaryLogisticClassificationResult(value, normalizationMethod);
                    if (sum == null) {
                        sum = value.copy();
                        continue;
                    }
                    value.subtract(sum);
                    sum.add(value);
                }
                Value<V> lastValue = valueIt.next();
                lastValue.residual(sum);
                break;
            }
            default: {
                throw new EvaluationException();
            }
        }
        return values;
    }

    public static <V extends Number> Value<V> normalizeRegressionResult(Value<V> value, RegressionModel.NormalizationMethod normalizationMethod) {
        switch (normalizationMethod) {
            case NONE: {
                return value;
            }
            case LOGIT: 
            case SOFTMAX: {
                return value.inverseLogit();
            }
            case EXP: {
                return value.exp();
            }
            case PROBIT: {
                return value.inverseProbit();
            }
            case CLOGLOG: {
                return value.inverseCloglog();
            }
            case LOGLOG: {
                return value.inverseLoglog();
            }
            case CAUCHIT: {
                return value.inverseCauchit();
            }
        }
        throw new EvaluationException();
    }

    public static <V extends Number> Value<V> normalizeBinaryLogisticClassificationResult(Value<V> value, RegressionModel.NormalizationMethod normalizationMethod) {
        switch (normalizationMethod) {
            case NONE: {
                return value.restrict(0.0, 1.0);
            }
            case LOGIT: {
                return value.inverseLogit();
            }
            case PROBIT: {
                return value.inverseProbit();
            }
            case CLOGLOG: {
                return value.inverseCloglog();
            }
            case LOGLOG: {
                return value.inverseLoglog();
            }
            case CAUCHIT: {
                return value.inverseCauchit();
            }
        }
        throw new EvaluationException();
    }
}

