/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import org.dmg.pmml.DataType;
import org.dmg.pmml.LinearNorm;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethod;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.DoubleValue;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.InvalidElementListException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.PMMLAttributes;
import org.jpmml.evaluator.PMMLElements;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.Value;

public class NormalizationUtil {
    private NormalizationUtil() {
    }

    public static FieldValue normalize(NormContinuous normContinuous, FieldValue value) {
        double result = NormalizationUtil.normalize(normContinuous, value.asNumber().doubleValue());
        return FieldValueUtil.create(DataType.DOUBLE, OpType.CONTINUOUS, result);
    }

    public static double normalize(NormContinuous normContinuous, double value) {
        List<LinearNorm> linearNorms = NormalizationUtil.ensureLinearNorms(normContinuous);
        LinearNorm rangeStart = linearNorms.get(0);
        LinearNorm rangeEnd = linearNorms.get(linearNorms.size() - 1);
        if (value >= rangeStart.getOrig() && value <= rangeEnd.getOrig()) {
            for (int i = 1; i < linearNorms.size() - 1; ++i) {
                LinearNorm linearNorm = linearNorms.get(i);
                if (value >= linearNorm.getOrig()) {
                    rangeStart = linearNorm;
                    continue;
                }
                if (!(value <= linearNorm.getOrig())) continue;
                rangeEnd = linearNorm;
                break;
            }
        } else {
            OutlierTreatmentMethod outlierTreatmentMethod = normContinuous.getOutliers();
            switch (outlierTreatmentMethod) {
                case AS_IS: {
                    if (value < rangeStart.getOrig()) {
                        rangeEnd = linearNorms.get(1);
                        break;
                    }
                    rangeStart = linearNorms.get(linearNorms.size() - 2);
                    break;
                }
                case AS_MISSING_VALUES: {
                    Double missing = normContinuous.getMapMissingTo();
                    if (missing == null) {
                        throw new MissingAttributeException((PMMLObject)normContinuous, PMMLAttributes.NORMCONTINUOUS_MAPMISSINGTO);
                    }
                    return missing;
                }
                case AS_EXTREME_VALUES: {
                    if (value < rangeStart.getOrig()) {
                        return rangeStart.getNorm();
                    }
                    return rangeEnd.getNorm();
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)normContinuous, (Enum<?>)outlierTreatmentMethod);
                }
            }
        }
        double origRange = rangeEnd.getOrig() - rangeStart.getOrig();
        double normRange = rangeEnd.getNorm() - rangeStart.getNorm();
        return rangeStart.getNorm() + (value - rangeStart.getOrig()) / origRange * normRange;
    }

    public static double denormalize(NormContinuous normContinuous, double value) {
        DoubleValue doubleValue = new DoubleValue(value);
        NormalizationUtil.denormalize(normContinuous, doubleValue);
        return doubleValue.doubleValue();
    }

    public static <V extends Number> Value<V> denormalize(NormContinuous normContinuous, Value<V> value) {
        List<LinearNorm> linearNorms = NormalizationUtil.ensureLinearNorms(normContinuous);
        LinearNorm rangeStart = linearNorms.get(0);
        LinearNorm rangeEnd = linearNorms.get(linearNorms.size() - 1);
        for (int i = 1; i < linearNorms.size() - 1; ++i) {
            LinearNorm linearNorm = linearNorms.get(i);
            if (value.compareTo(linearNorm.getNorm()) >= 0) {
                rangeStart = linearNorm;
                continue;
            }
            if (value.compareTo(linearNorm.getNorm()) > 0) continue;
            rangeEnd = linearNorm;
            break;
        }
        return value.denormalize(rangeStart.getOrig(), rangeStart.getNorm(), rangeEnd.getOrig(), rangeEnd.getNorm());
    }

    private static List<LinearNorm> ensureLinearNorms(NormContinuous normContinuous) {
        if (!normContinuous.hasLinearNorms()) {
            throw new MissingElementException((PMMLObject)normContinuous, PMMLElements.NORMCONTINUOUS_LINEARNORMS);
        }
        List linearNorms = normContinuous.getLinearNorms();
        if (linearNorms.size() < 2) {
            throw new InvalidElementListException(linearNorms);
        }
        return linearNorms;
    }
}

