/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalQuery;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import org.jpmml.evaluator.SimplePeriod;

public class SecondsSinceMidnight
extends SimplePeriod<SecondsSinceMidnight> {
    private long seconds = 0L;
    private static final TemporalField HOURS_OF_EPOCH = new TemporalField(){
        private final ValueRange range = ValueRange.of(0L, Long.MAX_VALUE);

        @Override
        public TemporalUnit getBaseUnit() {
            return ChronoUnit.HOURS;
        }

        @Override
        public TemporalUnit getRangeUnit() {
            return ChronoUnit.FOREVER;
        }

        @Override
        public ValueRange range() {
            return this.range;
        }

        @Override
        public boolean isDateBased() {
            return false;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }

        @Override
        public boolean isSupportedBy(TemporalAccessor temporal) {
            return temporal.isSupported(this);
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporal) {
            return temporal.range(this);
        }

        @Override
        public long getFrom(TemporalAccessor temporal) {
            return temporal.getLong(this);
        }

        @Override
        public <R extends Temporal> R adjustInto(R temporal, long value) {
            return (R)temporal.with(this, value);
        }

        @Override
        public String toString() {
            return "HoursOfEpoch";
        }
    };
    private static final DateTimeFormatter FORMATTER = SecondsSinceMidnight.createFormatter();
    private static final TemporalQuery<SecondsSinceMidnight> QUERY = new TemporalQuery<SecondsSinceMidnight>(){

        @Override
        public SecondsSinceMidnight queryFrom(TemporalAccessor temporal) {
            long hoursOfEpoch = temporal.getLong(HOURS_OF_EPOCH);
            long minutesOfHour = temporal.getLong(ChronoField.MINUTE_OF_HOUR);
            long secondsOfMinute = temporal.getLong(ChronoField.SECOND_OF_MINUTE);
            long seconds = hoursOfEpoch * 60L * 60L + minutesOfHour * 60L + secondsOfMinute;
            return new SecondsSinceMidnight(seconds);
        }
    };

    public SecondsSinceMidnight(long seconds) {
        this.setSeconds(seconds);
    }

    @Override
    public long longValue() {
        return this.getSeconds();
    }

    @Override
    public int compareTo(SecondsSinceMidnight that) {
        return Long.compare(this.getSeconds(), that.getSeconds());
    }

    public int hashCode() {
        return Long.hashCode(this.getSeconds());
    }

    public boolean equals(Object object) {
        if (object instanceof SecondsSinceMidnight) {
            SecondsSinceMidnight that = (SecondsSinceMidnight)object;
            return this.getSeconds() == that.getSeconds();
        }
        return false;
    }

    private SecondsSinceMidnight toNegative() {
        this.setSeconds(-1L * this.getSeconds());
        return this;
    }

    public long getSeconds() {
        return this.seconds;
    }

    private void setSeconds(long seconds) {
        this.seconds = seconds;
    }

    public static SecondsSinceMidnight parse(String string) {
        DateTimeFormatter formatter = FORMATTER;
        if (string.startsWith("-")) {
            SecondsSinceMidnight period = formatter.parse((CharSequence)string.substring(1), QUERY);
            return period.toNegative();
        }
        SecondsSinceMidnight period = formatter.parse((CharSequence)string, QUERY);
        return period;
    }

    private static DateTimeFormatter createFormatter() {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().appendValue(HOURS_OF_EPOCH, 1, 4, SignStyle.NOT_NEGATIVE).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2);
        return builder.toFormatter();
    }
}

