/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.dmg.pmml.Array;
import org.dmg.pmml.DataType;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.HasValueSet;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.HasParsedValue;
import org.jpmml.evaluator.HasParsedValueMapping;
import org.jpmml.evaluator.HasParsedValueSet;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.Numbers;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.XPathUtil;
import org.jpmml.model.ToStringHelper;

public abstract class FieldValue
implements Comparable<FieldValue>,
Serializable {
    private DataType dataType = null;
    private Object value = null;

    FieldValue(DataType dataType, Object value) {
        this.setDataType(Objects.requireNonNull(dataType));
        this.setValue(FieldValue.filterValue(Objects.requireNonNull(value)));
    }

    public abstract OpType getOpType();

    public boolean equals(HasValue<?> hasValue) {
        if (hasValue instanceof HasParsedValue) {
            HasParsedValue hasParsedValue = (HasParsedValue)hasValue;
            return this.equals(hasParsedValue);
        }
        return this.equalsString(FieldValue.ensureValue(hasValue));
    }

    public boolean equals(HasParsedValue<?> hasParsedValue) {
        FieldValue value = hasParsedValue.getValue(this.getDataType(), this.getOpType());
        return this.equals(value);
    }

    public boolean isIn(HasValueSet<?> hasValueSet) {
        if (hasValueSet instanceof HasParsedValueSet) {
            HasParsedValueSet hasParsedValueSet = (HasParsedValueSet)hasValueSet;
            return this.isIn(hasParsedValueSet);
        }
        Array array = hasValueSet.getArray();
        if (array == null) {
            throw new MissingElementException(MissingElementException.formatMessage(XPathUtil.formatElement(hasValueSet.getClass()) + "/" + XPathUtil.formatElement(Array.class)), (PMMLObject)hasValueSet);
        }
        List<?> values = ArrayUtil.getContent(array);
        return values.stream().anyMatch(value -> this.equalsValue(value));
    }

    public boolean isIn(HasParsedValueSet<?> hasParsedValueSet) {
        Set<FieldValue> values = hasParsedValueSet.getValueSet(this.getDataType(), this.getOpType());
        return values.contains(this);
    }

    @Override
    public int compareTo(HasValue<?> hasValue) {
        if (hasValue instanceof HasParsedValue) {
            HasParsedValue hasParsedValue = (HasParsedValue)hasValue;
            return this.compareTo(hasParsedValue);
        }
        return this.compareToString(FieldValue.ensureValue(hasValue));
    }

    @Override
    public int compareTo(HasParsedValue<?> hasParsedValue) {
        FieldValue value = hasParsedValue.getValue(this.getDataType(), this.getOpType());
        return this.compareTo(value);
    }

    public boolean equalsString(String string) {
        Object value = TypeUtil.parse(this.getDataType(), string);
        return this.getValue().equals(value);
    }

    public boolean equalsValue(FieldValue value) {
        if (this.sameScalarType(value)) {
            return this.getValue().equals(value.getValue());
        }
        return this.equalsValue(value.getValue());
    }

    private boolean equalsValue(Object value) {
        value = TypeUtil.parseOrCast(this.getDataType(), value);
        return this.getValue().equals(value);
    }

    public boolean isIn(Collection<FieldValue> values) {
        Predicate<FieldValue> predicate = new Predicate<FieldValue>(){

            @Override
            public boolean test(FieldValue value) {
                if (Objects.equals(FieldValues.MISSING_VALUE, value)) {
                    return false;
                }
                return FieldValue.this.equalsValue(value);
            }
        };
        return values.stream().anyMatch(predicate);
    }

    public int compareToString(String string) {
        Object value = TypeUtil.parse(this.getDataType(), string);
        return ((Comparable)this.getValue()).compareTo(value);
    }

    public int compareToValue(FieldValue value) {
        if (this.sameScalarType(value)) {
            return ((Comparable)this.getValue()).compareTo(value.getValue());
        }
        return this.compareToValue(value.getValue());
    }

    private int compareToValue(Object value) {
        value = TypeUtil.parseOrCast(this.getDataType(), value);
        return ((Comparable)this.getValue()).compareTo(value);
    }

    public <V> V getMapping(HasParsedValueMapping<V> hasParsedValueMapping) {
        Map<FieldValue, V> values = hasParsedValueMapping.getValueMapping(this.getDataType(), this.getOpType());
        return values.get(this);
    }

    private boolean isScalar() {
        return this instanceof Scalar;
    }

    private boolean sameScalarType(FieldValue value) {
        if (this.isScalar()) {
            return this.getClass().equals(value.getClass());
        }
        return false;
    }

    public String asString() {
        return (String)this.getValue(DataType.STRING);
    }

    public Number asNumber() {
        Object value = this.getValue();
        if (value instanceof Number) {
            return (Number)value;
        }
        return (Double)this.getValue(DataType.DOUBLE);
    }

    public Integer asInteger() {
        return (Integer)this.getValue(DataType.INTEGER);
    }

    public Float asFloat() {
        Number number = this.asNumber();
        return Float.valueOf(number.floatValue());
    }

    public Double asDouble() {
        Number number = this.asNumber();
        return number.doubleValue();
    }

    public Boolean asBoolean() {
        return (Boolean)this.getValue(DataType.BOOLEAN);
    }

    public LocalDateTime asLocalDateTime() {
        return (LocalDateTime)this.getValue(DataType.DATE_TIME);
    }

    public LocalDate asLocalDate() {
        return (LocalDate)this.getValue(DataType.DATE);
    }

    public LocalTime asLocalTime() {
        return (LocalTime)this.getValue(DataType.TIME);
    }

    public ZonedDateTime asZonedDateTime(ZoneId zoneId) {
        try {
            LocalDateTime dateTime = this.asLocalDateTime();
            return dateTime.atZone(zoneId);
        }
        catch (TypeCheckException tceDateTime) {
            try {
                LocalDate localDate = this.asLocalDate();
                LocalTime localTime = LocalTime.MIDNIGHT;
                return ZonedDateTime.of(localDate, localTime, zoneId);
            }
            catch (TypeCheckException localDate) {
                try {
                    LocalDate localDate2 = LocalDate.now();
                    LocalTime localTime = this.asLocalTime();
                    return ZonedDateTime.of(localDate2, localTime, zoneId);
                }
                catch (TypeCheckException typeCheckException) {
                    throw tceDateTime;
                }
            }
        }
    }

    private Object getValue(DataType dataType) {
        Object value = this.getValue();
        try {
            return TypeUtil.cast(dataType, value);
        }
        catch (TypeCheckException tce) {
            try {
                if (value instanceof String) {
                    String string = (String)value;
                    return TypeUtil.parse(dataType, string);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            throw tce;
        }
    }

    @Override
    public int compareTo(FieldValue that) {
        if (this.getOpType() != that.getOpType() || this.getDataType() != that.getDataType()) {
            throw new ClassCastException();
        }
        return this.compareToValue(that);
    }

    public int hashCode() {
        return 31 * (this.getOpType().hashCode() ^ this.getDataType().hashCode()) + this.getValue().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof FieldValue) {
            FieldValue that = (FieldValue)object;
            return this.getOpType() == that.getOpType() && this.getDataType() == that.getDataType() && this.getValue().equals(that.getValue());
        }
        return false;
    }

    public String toString() {
        ToStringHelper helper = new ToStringHelper((Object)this).add("opType", (Object)this.getOpType()).add("dataType", (Object)this.getDataType()).add("value", this.getValue());
        return helper.toString();
    }

    public DataType getDataType() {
        return this.dataType;
    }

    private void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public Object getValue() {
        return this.value;
    }

    private void setValue(Object value) {
        this.value = value;
    }

    private static String ensureValue(HasValue<?> hasValue) {
        String value = hasValue.getValue();
        if (value == null) {
            throw new MissingAttributeException(MissingAttributeException.formatMessage(XPathUtil.formatElement(hasValue.getClass()) + "@value"), (PMMLObject)hasValue);
        }
        return value;
    }

    private static Object filterValue(Object value) {
        if (value instanceof Float) {
            return FieldValue.filterValue((Float)value);
        }
        if (value instanceof Double) {
            return FieldValue.filterValue((Double)value);
        }
        return value;
    }

    private static Float filterValue(Float value) {
        if (value.doubleValue() == 0.0) {
            return Numbers.FLOAT_ZERO;
        }
        return value;
    }

    private static Double filterValue(Double value) {
        if (value == 0.0) {
            return Numbers.DOUBLE_ZERO;
        }
        return value;
    }

    static interface Scalar {
    }
}

