/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.java;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.MissingValueException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.java.JavaModelEvaluator;
import org.jpmml.evaluator.mining.MiningModelEvaluationContext;

public class JavaModelEvaluationContext
extends ModelEvaluationContext {
    private List<FieldName> names = null;
    private List<FieldValue> values = null;

    public JavaModelEvaluationContext(JavaModelEvaluator javaModelEvaluator) {
        super(javaModelEvaluator);
    }

    public JavaModelEvaluationContext(MiningModelEvaluationContext parent, JavaModelEvaluator javaModelEvaluator) {
        super(parent, javaModelEvaluator);
    }

    public JavaModelEvaluator getModelEvaluator() {
        return (JavaModelEvaluator)super.getModelEvaluator();
    }

    public void cache(List<FieldName> names) {
        this.names = null;
        this.values = null;
        if (names == null) {
            return;
        }
        ArrayList<FieldValue> values = new ArrayList<FieldValue>(names.size());
        for (FieldName name : names) {
            FieldValue value = this.evaluate(name);
            values.add(value);
        }
        this.names = names;
        this.values = values;
    }

    @Override
    public FieldValue evaluate(FieldName name) {
        return super.evaluate(name);
    }

    public FieldValue evaluateRequired(FieldName name) {
        FieldValue value = this.evaluate(name);
        if (Objects.equals(FieldValues.MISSING_VALUE, value)) {
            throw new MissingValueException(name);
        }
        return value;
    }

    public FieldValue evaluate(int index) {
        List<FieldValue> values = this.values;
        if (values == null) {
            throw new IllegalStateException();
        }
        return values.get(index);
    }

    public FieldValue evaluateRequired(int index) {
        FieldValue value = this.evaluate(index);
        if (Objects.equals(FieldValues.MISSING_VALUE, value)) {
            FieldName name = this.names.get(index);
            throw new MissingValueException(name);
        }
        return value;
    }
}

