/*
 * Copyright (c) 2018 Villu Ruusmann
 *
 * This file is part of JPMML-Evaluator
 *
 * JPMML-Evaluator is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JPMML-Evaluator is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with JPMML-Evaluator.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.jpmml.evaluator;

import java.io.Serializable;
import java.util.function.Predicate;

/**
 * @see ConfigurationBuilder
 */
public class Configuration implements Serializable {

	private ModelEvaluatorFactory modelEvaluatorFactory = null;

	private ValueFactoryFactory valueFactoryFactory = null;

	private Predicate<org.dmg.pmml.OutputField> outputFilter = null;


	Configuration(){
	}

	public ModelEvaluatorFactory getModelEvaluatorFactory(){
		return this.modelEvaluatorFactory;
	}

	void setModelEvaluatorFactory(ModelEvaluatorFactory modelEvaluatorFactory){
		this.modelEvaluatorFactory = modelEvaluatorFactory;
	}

	public ValueFactoryFactory getValueFactoryFactory(){
		return this.valueFactoryFactory;
	}

	void setValueFactoryFactory(ValueFactoryFactory valueFactoryFactory){
		this.valueFactoryFactory = valueFactoryFactory;
	}

	public Predicate<org.dmg.pmml.OutputField> getOutputFilter(){
		return this.outputFilter;
	}

	void setOutputFilter(Predicate<org.dmg.pmml.OutputField> outputFilter){
		this.outputFilter = outputFilter;
	}

	static
	public Configuration getInstance(){
		return Configuration.INSTANCE;
	}

	private static final Configuration INSTANCE;

	static {
		ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();

		INSTANCE = configurationBuilder.build();
	}
}