/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.Serializable;
import java.util.function.Predicate;
import org.dmg.pmml.OutputField;
import org.jpmml.evaluator.Configuration;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.OutputFilter;
import org.jpmml.evaluator.OutputFilters;
import org.jpmml.evaluator.ValueFactoryFactory;

public class ConfigurationBuilder
implements Cloneable,
Serializable {
    private ModelEvaluatorFactory modelEvaluatorFactory = null;
    private ValueFactoryFactory valueFactoryFactory = null;
    private Predicate<OutputField> outputFilter = null;

    public ConfigurationBuilder clone() {
        try {
            return (ConfigurationBuilder)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse);
        }
    }

    public Configuration build() {
        Configuration configuration = new Configuration();
        ModelEvaluatorFactory modelEvaluatorFactory = this.getModelEvaluatorFactory();
        if (modelEvaluatorFactory == null) {
            modelEvaluatorFactory = ModelEvaluatorFactory.newInstance();
        }
        configuration.setModelEvaluatorFactory(modelEvaluatorFactory);
        ValueFactoryFactory valueFactoryFactory = this.getValueFactoryFactory();
        if (valueFactoryFactory == null) {
            valueFactoryFactory = ValueFactoryFactory.newInstance();
        }
        configuration.setValueFactoryFactory(valueFactoryFactory);
        OutputFilter outputFilter = this.getOutputFilter();
        if (outputFilter == null) {
            outputFilter = OutputFilters.KEEP_ALL;
        }
        configuration.setOutputFilter(outputFilter);
        return configuration;
    }

    public ModelEvaluatorFactory getModelEvaluatorFactory() {
        return this.modelEvaluatorFactory;
    }

    public ConfigurationBuilder setModelEvaluatorFactory(ModelEvaluatorFactory modelEvaluatorFactory) {
        this.modelEvaluatorFactory = modelEvaluatorFactory;
        return this;
    }

    public ValueFactoryFactory getValueFactoryFactory() {
        return this.valueFactoryFactory;
    }

    public ConfigurationBuilder setValueFactoryFactory(ValueFactoryFactory valueFactoryFactory) {
        this.valueFactoryFactory = valueFactoryFactory;
        return this;
    }

    public Predicate<OutputField> getOutputFilter() {
        return this.outputFilter;
    }

    public ConfigurationBuilder setOutputFilter(Predicate<OutputField> outputFilter) {
        this.outputFilter = outputFilter;
        return this;
    }
}

