/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ParameterField;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.PMMLAttributes;

public class DefineFunctionEvaluationContext
extends EvaluationContext {
    private DefineFunction defineFunction = null;
    private EvaluationContext parent = null;

    public DefineFunctionEvaluationContext(DefineFunction defineFunction, EvaluationContext parent) {
        this.setDefineFunction(Objects.requireNonNull(defineFunction));
        this.setParent(Objects.requireNonNull(parent));
    }

    @Override
    public FieldValue prepare(FieldName name, Object value) {
        ParameterField parameterField = this.findParameterField(name);
        if (parameterField == null) {
            throw new MissingFieldException(name);
        }
        DataType dataType = parameterField.getDataType();
        if (dataType == null) {
            throw new MissingAttributeException((PMMLObject)parameterField, PMMLAttributes.PARAMETERFIELD_DATATYPE);
        }
        OpType opType = parameterField.getOpType();
        if (opType == null) {
            throw new MissingAttributeException((PMMLObject)parameterField, PMMLAttributes.PARAMETERFIELD_OPTYPE);
        }
        return FieldValueUtil.create(dataType, opType, value);
    }

    @Override
    protected DefineFunction getDefineFunction(String name) {
        EvaluationContext parent = this.getParent();
        return parent.getDefineFunction(name);
    }

    private ParameterField findParameterField(FieldName name) {
        DefineFunction defineFunction = this.getDefineFunction();
        if (defineFunction.hasParameterFields()) {
            List parameterFields = defineFunction.getParameterFields();
            for (ParameterField parameterField : parameterFields) {
                if (!Objects.equals(parameterField.getName(), name)) continue;
                return parameterField;
            }
        }
        return null;
    }

    public DefineFunction getDefineFunction() {
        return this.defineFunction;
    }

    private void setDefineFunction(DefineFunction defineFunction) {
        this.defineFunction = defineFunction;
    }

    public EvaluationContext getParent() {
        return this.parent;
    }

    private void setParent(EvaluationContext parent) {
        this.parent = parent;
    }
}

