/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.DuplicateValueException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.MissingValueException;

public abstract class EvaluationContext {
    private Map<FieldName, FieldValue> values = new HashMap<FieldName, FieldValue>();
    private List<FieldName> cachedNames = null;
    private List<FieldValue> cachedValues = null;
    private List<String> warnings = null;

    EvaluationContext() {
    }

    protected abstract FieldValue prepare(FieldName var1, Object var2);

    protected void reset(boolean clearValues) {
        if (clearValues) {
            if (!this.values.isEmpty()) {
                this.values.clear();
            }
            this.cachedNames = null;
            this.cachedValues = null;
        }
        if (this.warnings != null && !this.warnings.isEmpty()) {
            this.warnings.clear();
        }
    }

    public FieldValue lookup(FieldName name) {
        Map<FieldName, FieldValue> values = this.getValues();
        FieldValue value = values.get(name);
        if (value != null || value == null && values.containsKey(name)) {
            return value;
        }
        throw new MissingValueException(name);
    }

    public FieldValue lookup(int index) {
        List<FieldValue> cachedValues = this.cachedValues;
        if (cachedValues == null) {
            throw new IllegalStateException();
        }
        return cachedValues.get(index);
    }

    public FieldValue evaluate(FieldName name) {
        Map<FieldName, FieldValue> values = this.getValues();
        FieldValue value = values.get(name);
        if (value != null || value == null && values.containsKey(name)) {
            return value;
        }
        return this.resolve(name);
    }

    public List<FieldValue> evaluateAll(List<FieldName> names) {
        return this.evaluateAll(names, true);
    }

    public List<FieldValue> evaluateAll(List<FieldName> names, boolean cache) {
        this.cachedNames = null;
        this.cachedValues = null;
        ArrayList<FieldValue> values = new ArrayList<FieldValue>(names.size());
        for (FieldName name : names) {
            FieldValue value = this.evaluate(name);
            values.add(value);
        }
        if (cache) {
            this.cachedNames = names;
            this.cachedValues = values;
        }
        return values;
    }

    protected FieldValue resolve(FieldName name) {
        throw new MissingFieldException(name);
    }

    public FieldValue declare(FieldName name, Object value) {
        if (value instanceof FieldValue) {
            return this.declare(name, (FieldValue)value);
        }
        value = this.prepare(name, value);
        return this.declare(name, (FieldValue)value);
    }

    public FieldValue declare(FieldName name, FieldValue value) {
        Map<FieldName, FieldValue> values = this.getValues();
        boolean declared = values.containsKey(name);
        if (declared) {
            throw new DuplicateValueException(name);
        }
        values.put(name, value);
        return value;
    }

    public void declareAll(Map<FieldName, ?> values) {
        Set<Map.Entry<FieldName, ?>> entries = values.entrySet();
        for (Map.Entry entry : entries) {
            this.declare((FieldName)entry.getKey(), entry.getValue());
        }
    }

    protected DefineFunction getDefineFunction(String name) {
        throw new UnsupportedOperationException();
    }

    public void addWarning(String warning) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        this.warnings.add(warning);
    }

    public Map<FieldName, FieldValue> getValues() {
        return this.values;
    }

    public List<String> getWarnings() {
        if (this.warnings == null) {
            return Collections.emptyList();
        }
        return this.warnings;
    }
}

