/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.RangeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasDiscreteDomain;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MissingValueTreatmentMethod;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethod;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.FieldUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.HasParsedValueMapping;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.InvalidResultException;
import org.jpmml.evaluator.MisplacedAttributeException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.PMMLAttributes;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeInfo;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.XPathUtil;

public class InputFieldUtil {
    private InputFieldUtil() {
    }

    public static boolean isDefault(Field<?> field, MiningField miningField) {
        if (field instanceof DataField ? !Objects.equals(field.getOpType(), FieldUtil.getOpType(field, miningField)) : !Objects.equals(miningField.getOpType(), null)) {
            return false;
        }
        String invalidValueReplacement = miningField.getInvalidValueReplacement();
        if (invalidValueReplacement != null) {
            return false;
        }
        InvalidValueTreatmentMethod invalidValueTreatmentMethod = miningField.getInvalidValueTreatment();
        switch (invalidValueTreatmentMethod) {
            case RETURN_INVALID: 
            case AS_IS: {
                break;
            }
            default: {
                return false;
            }
        }
        String missingValueReplacement = miningField.getMissingValueReplacement();
        if (missingValueReplacement != null) {
            return false;
        }
        OutlierTreatmentMethod outlierTreatmentMethod = miningField.getOutlierTreatment();
        switch (outlierTreatmentMethod) {
            case AS_IS: {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static FieldValue prepareInputValue(Field<?> field, MiningField miningField, Object value) {
        if (Objects.equals(FieldValues.MISSING_VALUE, value) || value == null) {
            return InputFieldUtil.performMissingValueTreatment(field, miningField);
        }
        if (value instanceof Collection) {
            Collection rawValues = (Collection)value;
            ArrayList<Object> pmmlValues = new ArrayList<Object>(rawValues.size());
            for (Object rawValue : rawValues) {
                FieldValue fieldValue = InputFieldUtil.prepareScalarInputValue(field, miningField, rawValue);
                pmmlValues.add(FieldValueUtil.getValue(fieldValue));
            }
            return InputFieldUtil.createInputValue(field, miningField, pmmlValues);
        }
        return InputFieldUtil.prepareScalarInputValue(field, miningField, value);
    }

    public static FieldValue prepareResidualInputValue(DataField dataField, MiningField miningField, Object value) {
        return InputFieldUtil.prepareInputValue(dataField, miningField, value);
    }

    private static FieldValue prepareScalarInputValue(Field<?> field, MiningField miningField, Object value) {
        boolean compatible;
        try {
            value = InputFieldUtil.createInputValue(field, miningField, value);
            compatible = true;
        }
        catch (IllegalArgumentException | TypeCheckException e) {
            compatible = false;
        }
        Value.Property status = InputFieldUtil.getStatus(field, miningField, value, compatible);
        switch (status) {
            case VALID: {
                return InputFieldUtil.performValidValueTreatment(field, miningField, (FieldValue)value);
            }
            case INVALID: {
                return InputFieldUtil.performInvalidValueTreatment(field, miningField, value);
            }
            case MISSING: {
                return InputFieldUtil.performMissingValueTreatment(field, miningField);
            }
        }
        throw new IllegalArgumentException();
    }

    public static FieldValue performValidValueTreatment(Field<?> field, MiningField miningField, FieldValue value) {
        OutlierTreatmentMethod outlierTreatmentMethod = miningField.getOutlierTreatment();
        switch (outlierTreatmentMethod) {
            case AS_IS: {
                return InputFieldUtil.createInputValue(field, miningField, value);
            }
            case AS_MISSING_VALUES: 
            case AS_EXTREME_VALUES: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)miningField, (Enum<?>)outlierTreatmentMethod);
            }
        }
        Double lowValue = miningField.getLowValue();
        Double highValue = miningField.getHighValue();
        if (lowValue == null && highValue == null) {
            throw new MissingAttributeException((PMMLObject)miningField, PMMLAttributes.MININGFIELD_LOWVALUE);
        }
        if (lowValue != null && highValue != null && lowValue.compareTo(highValue) > 0) {
            throw new InvalidElementException((PMMLObject)miningField);
        }
        if (Objects.equals(FieldValues.MISSING_VALUE, value)) {
            throw new TypeCheckException(Number.class, null);
        }
        Number numberValue = value.asNumber();
        switch (outlierTreatmentMethod) {
            case AS_MISSING_VALUES: {
                if (lowValue != null && numberValue.doubleValue() < lowValue) {
                    return InputFieldUtil.createMissingInputValue(field, miningField);
                }
                if (highValue == null || !(numberValue.doubleValue() > highValue)) break;
                return InputFieldUtil.createMissingInputValue(field, miningField);
            }
            case AS_EXTREME_VALUES: {
                if (lowValue != null && numberValue.doubleValue() < lowValue) {
                    return InputFieldUtil.createInputValue(field, miningField, lowValue);
                }
                if (highValue == null || !(numberValue.doubleValue() > highValue)) break;
                return InputFieldUtil.createInputValue(field, miningField, highValue);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)miningField, (Enum<?>)outlierTreatmentMethod);
            }
        }
        return InputFieldUtil.createInputValue(field, miningField, value);
    }

    public static FieldValue performInvalidValueTreatment(Field<?> field, MiningField miningField, Object value) {
        InvalidValueTreatmentMethod invalidValueTreatmentMethod = miningField.getInvalidValueTreatment();
        String invalidValueReplacement = miningField.getInvalidValueReplacement();
        switch (invalidValueTreatmentMethod) {
            case AS_IS: {
                break;
            }
            case RETURN_INVALID: 
            case AS_MISSING: {
                if (invalidValueReplacement == null) break;
                throw new MisplacedAttributeException((PMMLObject)miningField, PMMLAttributes.MININGFIELD_INVALIDVALUEREPLACEMENT, invalidValueReplacement);
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)miningField, (Enum<?>)invalidValueTreatmentMethod);
            }
        }
        switch (invalidValueTreatmentMethod) {
            case RETURN_INVALID: {
                throw new InvalidResultException("Field " + PMMLException.formatKey(field.getName()) + " cannot accept user input value " + PMMLException.formatValue(value), (PMMLObject)miningField);
            }
            case AS_IS: {
                if (invalidValueReplacement != null) {
                    return InputFieldUtil.createInputValue(field, miningField, invalidValueReplacement);
                }
                return InputFieldUtil.createInputValue(field, miningField, value);
            }
            case AS_MISSING: {
                return InputFieldUtil.createMissingInputValue(field, miningField);
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)miningField, (Enum<?>)invalidValueTreatmentMethod);
    }

    public static FieldValue performMissingValueTreatment(Field<?> field, MiningField miningField) {
        MissingValueTreatmentMethod missingValueTreatmentMethod = miningField.getMissingValueTreatment();
        String missingValueReplacement = miningField.getMissingValueReplacement();
        if (missingValueTreatmentMethod == null) {
            missingValueTreatmentMethod = MissingValueTreatmentMethod.AS_IS;
        }
        switch (missingValueTreatmentMethod) {
            case AS_IS: 
            case AS_MEAN: 
            case AS_MODE: 
            case AS_MEDIAN: 
            case AS_VALUE: {
                return InputFieldUtil.createMissingInputValue(field, miningField);
            }
            case RETURN_INVALID: {
                if (missingValueReplacement != null) {
                    throw new MisplacedAttributeException((PMMLObject)miningField, PMMLAttributes.MININGFIELD_MISSINGVALUEREPLACEMENT, missingValueReplacement);
                }
                throw new InvalidResultException("Field " + PMMLException.formatKey(field.getName()) + " requires user input value", (PMMLObject)miningField);
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)miningField, (Enum<?>)missingValueTreatmentMethod);
    }

    private static Value.Property getStatus(Field<?> field, MiningField miningField, Object value, boolean compatible) {
        if (field instanceof DataField) {
            DataField dataField = (DataField)field;
            return InputFieldUtil.getStatus(dataField, miningField, value, compatible);
        }
        return compatible ? Value.Property.VALID : Value.Property.INVALID;
    }

    private static Value.Property getStatus(DataField dataField, MiningField miningField, Object value, boolean compatible) {
        boolean hasValidSpace = false;
        if (dataField.hasValues()) {
            Value pmmlValue;
            DataType dataType = dataField.getDataType();
            if (dataType == null) {
                throw new MissingAttributeException((PMMLObject)dataField, PMMLAttributes.DATAFIELD_DATATYPE);
            }
            if (dataField instanceof HasParsedValueMapping) {
                HasParsedValueMapping hasParsedValueMapping = (HasParsedValueMapping)dataField;
                OpType opType = dataField.getOpType();
                if (opType == null) {
                    throw new MissingAttributeException((PMMLObject)dataField, PMMLAttributes.DATAFIELD_OPTYPE);
                }
                try {
                    FieldValue fieldValue = FieldValueUtil.createOrCast(dataType, opType, value);
                    pmmlValue = (Value)fieldValue.getMapping(hasParsedValueMapping);
                    if (pmmlValue != null) {
                        return pmmlValue.getProperty();
                    }
                }
                catch (IllegalArgumentException | TypeCheckException fieldValue) {
                    // empty catch block
                }
            }
            List pmmlValues = dataField.getValues();
            int max = pmmlValues.size();
            block10: for (int i = 0; i < max; ++i) {
                boolean equals;
                pmmlValue = (Value)pmmlValues.get(i);
                String stringValue = pmmlValue.getValue();
                if (stringValue == null) {
                    throw new MissingAttributeException((PMMLObject)pmmlValue, PMMLAttributes.VALUE_VALUE);
                }
                Value.Property property = pmmlValue.getProperty();
                switch (property) {
                    case VALID: {
                        FieldValue fieldValue;
                        hasValidSpace = true;
                        if (!compatible) continue block10;
                        if (value instanceof FieldValue) {
                            fieldValue = (FieldValue)value;
                            equals = fieldValue.equalsString(stringValue);
                            break;
                        }
                        equals = TypeUtil.equals(dataType, value, stringValue);
                        break;
                    }
                    case INVALID: 
                    case MISSING: {
                        FieldValue fieldValue;
                        if (value instanceof FieldValue) {
                            fieldValue = (FieldValue)value;
                            equals = TypeUtil.equals(dataType, FieldValueUtil.getValue(fieldValue), stringValue);
                            break;
                        }
                        equals = TypeUtil.equals(dataType, value, stringValue);
                        break;
                    }
                    default: {
                        throw new UnsupportedAttributeException((PMMLObject)pmmlValue, (Enum<?>)property);
                    }
                }
                if (!equals) continue;
                return property;
            }
        }
        if (!compatible) {
            return Value.Property.INVALID;
        }
        if (dataField.hasIntervals()) {
            MiningField locatable = miningField;
            OpType opType = miningField.getOpType();
            if (opType == null) {
                locatable = dataField;
                opType = dataField.getOpType();
            }
            switch (opType) {
                case CONTINUOUS: {
                    RangeSet<Double> validRanges = FieldUtil.getValidRanges(dataField);
                    if (!(value instanceof FieldValue)) {
                        throw new IllegalArgumentException();
                    }
                    FieldValue fieldValue = (FieldValue)value;
                    Double doubleValue = fieldValue.asDouble();
                    return validRanges.contains((Comparable)doubleValue) ? Value.Property.VALID : Value.Property.INVALID;
                }
                case CATEGORICAL: 
                case ORDINAL: {
                    throw new InvalidElementException((PMMLObject)dataField);
                }
            }
            throw new UnsupportedAttributeException((PMMLObject)locatable, (Enum<?>)opType);
        }
        if (hasValidSpace) {
            return Value.Property.INVALID;
        }
        return Value.Property.VALID;
    }

    private static FieldValue createInputValue(final Field<?> field, final MiningField miningField, Object value) {
        if (Objects.equals(FieldValues.MISSING_VALUE, value) || value == null) {
            return FieldValues.MISSING_VALUE;
        }
        TypeInfo typeInfo = new TypeInfo(){

            @Override
            public DataType getDataType() {
                DataType dataType = FieldUtil.getDataType(field);
                if (dataType == null) {
                    throw new MissingAttributeException(MissingAttributeException.formatMessage(XPathUtil.formatElement(field.getClass()) + "@dataType"), (PMMLObject)field);
                }
                return dataType;
            }

            @Override
            public OpType getOpType() {
                OpType opType = FieldUtil.getOpType(field, miningField);
                if (opType == null) {
                    throw new MissingAttributeException(MissingAttributeException.formatMessage(XPathUtil.formatElement(field.getClass()) + "@optype"), (PMMLObject)field);
                }
                return opType;
            }

            @Override
            public List<?> getOrdering() {
                List<?> ordering = null;
                if (field instanceof HasDiscreteDomain) {
                    ordering = FieldUtil.getValidValues((Field)((HasDiscreteDomain)field));
                }
                return ordering;
            }
        };
        return FieldValueUtil.createOrCast(typeInfo, value);
    }

    private static FieldValue createMissingInputValue(Field<?> field, MiningField miningField) {
        String missingValueReplacement = miningField.getMissingValueReplacement();
        return InputFieldUtil.createInputValue(field, miningField, missingValueReplacement);
    }
}

