/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.OpType;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.VerificationField;
import org.dmg.pmml.VerificationFields;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.ConfidenceDistribution;
import org.jpmml.evaluator.Configuration;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.HasGroupFields;
import org.jpmml.evaluator.HasModel;
import org.jpmml.evaluator.HasPMML;
import org.jpmml.evaluator.IndexableUtil;
import org.jpmml.evaluator.InlineTableUtil;
import org.jpmml.evaluator.InputField;
import org.jpmml.evaluator.InputFieldUtil;
import org.jpmml.evaluator.InvalidAttributeException;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.InvisibleFieldException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.ModelField;
import org.jpmml.evaluator.OutputField;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PMMLElements;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.jpmml.evaluator.ResidualInputField;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.UnsupportedElementException;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueFactoryFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.VariableField;
import org.jpmml.evaluator.VerificationUtil;
import org.jpmml.evaluator.XPathUtil;

public abstract class ModelEvaluator<M extends Model>
implements Evaluator,
HasPMML,
HasModel<M>,
Serializable {
    private PMML pmml = null;
    private M model = null;
    private Configuration configuration = Configuration.getInstance();
    private ValueFactory<?> valueFactory = null;
    private Map<FieldName, DataField> dataFields = Collections.emptyMap();
    private Map<FieldName, DerivedField> derivedFields = Collections.emptyMap();
    private Map<String, DefineFunction> defineFunctions = Collections.emptyMap();
    private Map<FieldName, MiningField> miningFields = Collections.emptyMap();
    private Map<FieldName, DerivedField> localDerivedFields = Collections.emptyMap();
    private Map<FieldName, Target> targets = Collections.emptyMap();
    private Map<FieldName, org.dmg.pmml.OutputField> outputFields = Collections.emptyMap();
    private transient Boolean parentCompatible = null;
    private transient Boolean pure = null;
    private transient List<InputField> inputFields = null;
    private transient List<InputField> activeInputFields = null;
    private transient List<TargetField> targetResultFields = null;
    private transient List<OutputField> outputResultFields = null;
    private transient Set<ResultFeature> resultFeatures = null;
    private static final DataField DEFAULT_TARGET_CONTINUOUS_FLOAT = new DataField(Evaluator.DEFAULT_TARGET_NAME, OpType.CONTINUOUS, DataType.FLOAT);
    private static final DataField DEFAULT_TARGET_CONTINUOUS_DOUBLE = new DataField(Evaluator.DEFAULT_TARGET_NAME, OpType.CONTINUOUS, DataType.DOUBLE);
    private static final DataField DEFAULT_TARGET_CATEGORICAL_STRING = new DataField(Evaluator.DEFAULT_TARGET_NAME, OpType.CATEGORICAL, DataType.STRING);
    private static final LoadingCache<DataDictionary, Map<FieldName, DataField>> dataFieldCache = CacheUtil.buildLoadingCache(new CacheLoader<DataDictionary, Map<FieldName, DataField>>(){

        public Map<FieldName, DataField> load(DataDictionary dataDictionary) {
            return IndexableUtil.buildMap(dataDictionary.getDataFields());
        }
    });
    private static final LoadingCache<TransformationDictionary, Map<FieldName, DerivedField>> derivedFieldCache = CacheUtil.buildLoadingCache(new CacheLoader<TransformationDictionary, Map<FieldName, DerivedField>>(){

        public Map<FieldName, DerivedField> load(TransformationDictionary transformationDictionary) {
            return IndexableUtil.buildMap(transformationDictionary.getDerivedFields());
        }
    });
    private static final LoadingCache<TransformationDictionary, Map<String, DefineFunction>> defineFunctionCache = CacheUtil.buildLoadingCache(new CacheLoader<TransformationDictionary, Map<String, DefineFunction>>(){

        public Map<String, DefineFunction> load(TransformationDictionary transformationDictionary) {
            return IndexableUtil.buildMap(transformationDictionary.getDefineFunctions());
        }
    });
    private static final LoadingCache<MiningSchema, Map<FieldName, MiningField>> miningFieldCache = CacheUtil.buildLoadingCache(new CacheLoader<MiningSchema, Map<FieldName, MiningField>>(){

        public Map<FieldName, MiningField> load(MiningSchema miningSchema) {
            return IndexableUtil.buildMap(miningSchema.getMiningFields());
        }
    });
    private static final LoadingCache<LocalTransformations, Map<FieldName, DerivedField>> localDerivedFieldCache = CacheUtil.buildLoadingCache(new CacheLoader<LocalTransformations, Map<FieldName, DerivedField>>(){

        public Map<FieldName, DerivedField> load(LocalTransformations localTransformations) {
            return IndexableUtil.buildMap(localTransformations.getDerivedFields());
        }
    });
    private static final LoadingCache<Targets, Map<FieldName, Target>> targetCache = CacheUtil.buildLoadingCache(new CacheLoader<Targets, Map<FieldName, Target>>(){

        public Map<FieldName, Target> load(Targets targets) {
            return IndexableUtil.buildMap(targets.getTargets(), true);
        }
    });
    private static final LoadingCache<Output, Map<FieldName, org.dmg.pmml.OutputField>> outputFieldCache = CacheUtil.buildLoadingCache(new CacheLoader<Output, Map<FieldName, org.dmg.pmml.OutputField>>(){

        public Map<FieldName, org.dmg.pmml.OutputField> load(Output output) {
            return IndexableUtil.buildMap(output.getOutputFields());
        }
    });
    private static final LoadingCache<ModelVerification, VerificationBatch> batchCache = CacheUtil.buildLoadingCache(new CacheLoader<ModelVerification, VerificationBatch>(){

        public VerificationBatch load(ModelVerification modelVerification) {
            return ModelEvaluator.parseModelVerification(modelVerification);
        }
    });

    protected ModelEvaluator(PMML pmml, M model) {
        Output output;
        Targets targets;
        LocalTransformations localTransformations;
        MiningFunction miningFunction;
        TransformationDictionary transformationDictionary;
        this.setPMML(Objects.requireNonNull(pmml));
        this.setModel((Model)Objects.requireNonNull(model));
        DataDictionary dataDictionary = pmml.getDataDictionary();
        if (dataDictionary == null) {
            throw new MissingElementException((PMMLObject)pmml, PMMLElements.PMML_DATADICTIONARY);
        }
        if (dataDictionary.hasDataFields()) {
            this.dataFields = CacheUtil.getValue(dataDictionary, dataFieldCache);
        }
        if ((transformationDictionary = pmml.getTransformationDictionary()) != null && transformationDictionary.hasDerivedFields()) {
            this.derivedFields = CacheUtil.getValue(transformationDictionary, derivedFieldCache);
        }
        if (transformationDictionary != null && transformationDictionary.hasDefineFunctions()) {
            this.defineFunctions = CacheUtil.getValue(transformationDictionary, defineFunctionCache);
        }
        if ((miningFunction = model.getMiningFunction()) == null) {
            throw new MissingAttributeException(MissingAttributeException.formatMessage(XPathUtil.formatElement(model.getClass()) + "@functionName"), (PMMLObject)model);
        }
        MiningSchema miningSchema = model.getMiningSchema();
        if (miningSchema == null) {
            throw new MissingElementException(MissingElementException.formatMessage(XPathUtil.formatElement(model.getClass()) + "/" + XPathUtil.formatElement(MiningSchema.class)), (PMMLObject)model);
        }
        if (miningSchema.hasMiningFields()) {
            this.miningFields = CacheUtil.getValue(miningSchema, miningFieldCache);
        }
        if ((localTransformations = model.getLocalTransformations()) != null && localTransformations.hasDerivedFields()) {
            this.localDerivedFields = CacheUtil.getValue(localTransformations, localDerivedFieldCache);
        }
        if ((targets = model.getTargets()) != null && targets.hasTargets()) {
            this.targets = CacheUtil.getValue(targets, targetCache);
        }
        if ((output = model.getOutput()) != null && output.hasOutputFields()) {
            this.outputFields = CacheUtil.getValue(output, outputFieldCache);
        }
    }

    public void configure(Configuration configuration) {
        this.setConfiguration(Objects.requireNonNull(configuration));
        this.setValueFactory(null);
        this.outputResultFields = null;
    }

    @Override
    public MiningFunction getMiningFunction() {
        M model = this.getModel();
        return model.getMiningFunction();
    }

    public MathContext getMathContext() {
        M model = this.getModel();
        return model.getMathContext();
    }

    public DataField getDataField(FieldName name) {
        if (Objects.equals(Evaluator.DEFAULT_TARGET_NAME, name)) {
            return this.getDataField();
        }
        return this.dataFields.get(name);
    }

    protected DataField getDataField() {
        MiningFunction miningFunction = this.getMiningFunction();
        switch (miningFunction) {
            case REGRESSION: {
                MathContext mathContext = this.getMathContext();
                switch (mathContext) {
                    case FLOAT: {
                        return DEFAULT_TARGET_CONTINUOUS_FLOAT;
                    }
                }
                return DEFAULT_TARGET_CONTINUOUS_DOUBLE;
            }
            case CLASSIFICATION: 
            case CLUSTERING: {
                return DEFAULT_TARGET_CATEGORICAL_STRING;
            }
        }
        return null;
    }

    public DerivedField getDerivedField(FieldName name) {
        return this.derivedFields.get(name);
    }

    public DefineFunction getDefineFunction(String name) {
        return this.defineFunctions.get(name);
    }

    public MiningField getMiningField(FieldName name) {
        if (Objects.equals(Evaluator.DEFAULT_TARGET_NAME, name)) {
            return null;
        }
        return this.miningFields.get(name);
    }

    public DerivedField getLocalDerivedField(FieldName name) {
        return this.localDerivedFields.get(name);
    }

    public Target getTarget(FieldName name) {
        return this.targets.get(name);
    }

    public org.dmg.pmml.OutputField getOutputField(FieldName name) {
        return this.outputFields.get(name);
    }

    public boolean isParentCompatible() {
        if (this.parentCompatible == null) {
            this.parentCompatible = this.assessParentCompatibility();
        }
        return this.parentCompatible;
    }

    public boolean isPure() {
        if (this.pure == null) {
            this.pure = this.assessPurity();
        }
        return this.pure;
    }

    @Override
    public List<InputField> getInputFields() {
        if (this.inputFields == null) {
            this.inputFields = this.createInputFields();
        }
        return this.inputFields;
    }

    InputField findInputField(FieldName name) {
        return ModelEvaluator.findModelField(this.getInputFields(), name);
    }

    @Override
    public List<InputField> getActiveFields() {
        if (this.activeInputFields == null) {
            this.activeInputFields = this.createInputFields(MiningField.UsageType.ACTIVE);
        }
        return this.activeInputFields;
    }

    @Override
    public List<TargetField> getTargetFields() {
        if (this.targetResultFields == null) {
            this.targetResultFields = this.createTargetFields();
        }
        return this.targetResultFields;
    }

    public TargetField getTargetField() {
        List<TargetField> targetFields = this.getTargetFields();
        if (targetFields.size() != 1) {
            throw this.createMiningSchemaException("Expected 1 target field, got " + targetFields.size() + " target fields");
        }
        TargetField targetField = targetFields.get(0);
        return targetField;
    }

    public FieldName getTargetName() {
        TargetField targetField = this.getTargetField();
        return targetField.getName();
    }

    TargetField findTargetField(FieldName name) {
        return ModelEvaluator.findModelField(this.getTargetFields(), name);
    }

    @Override
    public List<OutputField> getOutputFields() {
        if (this.outputResultFields == null) {
            this.outputResultFields = this.createOutputFields();
        }
        return this.outputResultFields;
    }

    OutputField findOutputField(FieldName name) {
        return ModelEvaluator.findModelField(this.getOutputFields(), name);
    }

    public boolean hasResultFeature(ResultFeature resultFeature) {
        Set<ResultFeature> resultFeatures = this.getResultFeatures();
        return resultFeatures.contains(resultFeature);
    }

    public Set<ResultFeature> getResultFeatures() {
        if (this.resultFeatures == null) {
            this.resultFeatures = this.collectResultFeatures();
        }
        return this.resultFeatures;
    }

    protected EvaluationException createMiningSchemaException(String message) {
        M model = this.getModel();
        MiningSchema miningSchema = model.getMiningSchema();
        return new EvaluationException(message, (PMMLObject)miningSchema);
    }

    @Override
    public void verify() {
        M model = this.getModel();
        ModelVerification modelVerification = model.getModelVerification();
        if (modelVerification == null) {
            return;
        }
        VerificationBatch batch = CacheUtil.getValue(modelVerification, batchCache);
        List<Map<FieldName, Object>> records = batch.getRecords();
        List<InputField> inputFields = this.getInputFields();
        if (this instanceof HasGroupFields) {
            HasGroupFields hasGroupFields = (HasGroupFields)((Object)this);
            records = EvaluatorUtil.groupRows(hasGroupFields, records);
        }
        List<TargetField> targetFields = this.getTargetFields();
        List<OutputField> outputFields = this.getOutputFields();
        Sets.SetView intersection = Sets.intersection(batch.keySet(), new LinkedHashSet<FieldName>(EvaluatorUtil.getNames(outputFields)));
        for (Map<FieldName, Object> record : records) {
            VerificationField verificationField;
            FieldName name;
            LinkedHashMap<FieldName, FieldValue> arguments = new LinkedHashMap<FieldName, FieldValue>();
            for (InputField inputField : inputFields) {
                FieldName name2 = inputField.getName();
                FieldValue value = inputField.prepare(record.get(name2));
                arguments.put(name2, value);
            }
            Map results = this.evaluate(arguments);
            if (intersection.size() > 0) {
                for (OutputField outputField : outputFields) {
                    name = outputField.getName();
                    verificationField = (VerificationField)batch.get(name);
                    if (verificationField == null) continue;
                    this.verify(record.get(name), results.get(name), verificationField.getPrecision(), verificationField.getZeroThreshold());
                }
                continue;
            }
            for (TargetField targetField : targetFields) {
                name = targetField.getName();
                verificationField = (VerificationField)batch.get(name);
                if (verificationField == null) continue;
                this.verify(record.get(name), EvaluatorUtil.decode(results.get(name)), verificationField.getPrecision(), verificationField.getZeroThreshold());
            }
        }
    }

    private void verify(Object expected, Object actual, double precision, double zeroThreshold) {
        boolean acceptable;
        if (expected == null) {
            return;
        }
        if (!(actual instanceof Collection)) {
            DataType dataType = TypeUtil.getDataType(actual);
            expected = TypeUtil.parseOrCast(dataType, expected);
        }
        if (!(acceptable = VerificationUtil.acceptable(expected, actual, precision, zeroThreshold))) {
            throw new EvaluationException("Values " + PMMLException.formatValue(expected) + " and " + PMMLException.formatValue(actual) + " do not match");
        }
    }

    @Override
    public Map<FieldName, ?> evaluate(Map<FieldName, ?> arguments) {
        ModelEvaluationContext context = new ModelEvaluationContext(this);
        context.setArguments(arguments);
        Map<FieldName, ?> results = this.evaluate(context);
        return OutputUtil.clear(results);
    }

    public Map<FieldName, ?> evaluate(ModelEvaluationContext context) {
        Map<FieldName, ?> predictions;
        ValueFactory<?> valueFactory;
        M model = this.getModel();
        if (!model.isScorable()) {
            throw new EvaluationException("Model is not scorable", (PMMLObject)model);
        }
        MathContext mathContext = model.getMathContext();
        switch (mathContext) {
            case FLOAT: 
            case DOUBLE: {
                valueFactory = this.ensureValueFactory();
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)model, (Enum<?>)mathContext);
            }
        }
        MiningFunction miningFunction = model.getMiningFunction();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(valueFactory, context);
                break;
            }
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(valueFactory, context);
                break;
            }
            case CLUSTERING: {
                predictions = this.evaluateClustering(valueFactory, context);
                break;
            }
            case ASSOCIATION_RULES: {
                predictions = this.evaluateAssociationRules(valueFactory, context);
                break;
            }
            case SEQUENCES: {
                predictions = this.evaluateSequences(valueFactory, context);
                break;
            }
            case TIME_SERIES: {
                predictions = this.evaluateTimeSeries(valueFactory, context);
                break;
            }
            case MIXED: {
                predictions = this.evaluateMixed(valueFactory, context);
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)model, (Enum<?>)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    protected <V extends Number> Map<FieldName, ?> evaluateRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateDefault();
    }

    protected <V extends Number> Map<FieldName, ?> evaluateClassification(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateDefault();
    }

    protected <V extends Number> Map<FieldName, ?> evaluateClustering(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateDefault();
    }

    protected <V extends Number> Map<FieldName, ?> evaluateAssociationRules(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateDefault();
    }

    protected <V extends Number> Map<FieldName, ?> evaluateSequences(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateDefault();
    }

    protected <V extends Number> Map<FieldName, ?> evaluateTimeSeries(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateDefault();
    }

    protected <V extends Number> Map<FieldName, ?> evaluateMixed(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateDefault();
    }

    private <V extends Number> Map<FieldName, ?> evaluateDefault() {
        M model = this.getModel();
        MiningFunction miningFunction = model.getMiningFunction();
        throw new InvalidAttributeException((PMMLObject)model, (Enum<?>)miningFunction);
    }

    protected <V extends Number> Classification<V> createClassification(ValueMap<String, V> values) {
        if (this.hasResultFeature(ResultFeature.PROBABILITY) || this.hasResultFeature(ResultFeature.RESIDUAL)) {
            return new ProbabilityDistribution<V>(values);
        }
        if (this.hasResultFeature(ResultFeature.CONFIDENCE)) {
            return new ConfidenceDistribution<V>(values);
        }
        return new Classification<V>(Classification.Type.VOTE, values);
    }

    protected Field<?> resolveField(FieldName name) {
        DataField result = this.getDataField(name);
        if (result == null) {
            result = this.resolveDerivedField(name);
        }
        return result;
    }

    protected DerivedField resolveDerivedField(FieldName name) {
        DerivedField result = this.getDerivedField(name);
        if (result == null) {
            result = this.getLocalDerivedField(name);
        }
        return result;
    }

    protected boolean assessParentCompatibility() {
        List<InputField> inputFields = this.getInputFields();
        for (InputField inputField : inputFields) {
            Field<?> field = inputField.getField();
            MiningField miningField = inputField.getMiningField();
            if (!(field instanceof DataField) || InputFieldUtil.isDefault(field, miningField)) continue;
            return false;
        }
        return true;
    }

    protected boolean assessPurity() {
        List<InputField> inputFields = this.getInputFields();
        for (InputField inputField : inputFields) {
            MiningField miningField;
            Field<?> field = inputField.getField();
            if (InputFieldUtil.isDefault(field, miningField = inputField.getMiningField())) continue;
            return false;
        }
        return this.localDerivedFields.isEmpty() && this.outputFields.isEmpty();
    }

    protected List<InputField> createInputFields() {
        ImmutableList inputFields = this.getActiveFields();
        List<OutputField> outputFields = this.getOutputFields();
        if (outputFields.size() > 0) {
            ArrayList<ResidualInputField> residualInputFields = null;
            for (OutputField outputField : outputFields) {
                DataField dataField;
                org.dmg.pmml.OutputField pmmlOutputField = outputField.getField();
                if (!ResultFeature.RESIDUAL.equals((Object)pmmlOutputField.getResultFeature())) continue;
                int depth = outputField.getDepth();
                if (depth > 0) {
                    throw new UnsupportedElementException((PMMLObject)pmmlOutputField);
                }
                FieldName targetName = pmmlOutputField.getTargetField();
                if (targetName == null) {
                    targetName = this.getTargetName();
                }
                if ((dataField = this.getDataField(targetName)) == null) {
                    throw new MissingFieldException(targetName, (PMMLObject)pmmlOutputField);
                }
                MiningField miningField = this.getMiningField(targetName);
                if (miningField == null) {
                    throw new InvisibleFieldException(targetName, (PMMLObject)pmmlOutputField);
                }
                ResidualInputField residualInputField = new ResidualInputField(dataField, miningField);
                if (residualInputFields == null) {
                    residualInputFields = new ArrayList<ResidualInputField>();
                }
                residualInputFields.add(residualInputField);
            }
            if (residualInputFields != null && residualInputFields.size() > 0) {
                inputFields = ImmutableList.copyOf((Iterable)Iterables.concat(inputFields, (Iterable)residualInputFields));
            }
        }
        return inputFields;
    }

    protected List<InputField> createInputFields(MiningField.UsageType usageType) {
        M model = this.getModel();
        MiningSchema miningSchema = model.getMiningSchema();
        ArrayList<InputField> inputFields = new ArrayList<InputField>();
        if (miningSchema.hasMiningFields()) {
            List miningFields = miningSchema.getMiningFields();
            for (MiningField miningField : miningFields) {
                FieldName name = miningField.getName();
                if (!miningField.getUsageType().equals((Object)usageType)) continue;
                Object field = this.getDataField(name);
                if (field == null) {
                    field = new VariableField(name);
                }
                InputField inputField = new InputField((Field<?>)field, miningField);
                inputFields.add(inputField);
            }
        }
        return ImmutableList.copyOf(inputFields);
    }

    protected List<TargetField> createTargetFields() {
        DataField dataField;
        M model = this.getModel();
        MiningSchema miningSchema = model.getMiningSchema();
        ArrayList<TargetField> targetFields = new ArrayList<TargetField>();
        if (miningSchema.hasMiningFields()) {
            List miningFields = miningSchema.getMiningFields();
            block3: for (MiningField miningField : miningFields) {
                FieldName name = miningField.getName();
                MiningField.UsageType usageType = miningField.getUsageType();
                switch (usageType) {
                    case TARGET: 
                    case PREDICTED: {
                        break;
                    }
                    default: {
                        continue block3;
                    }
                }
                DataField dataField2 = this.getDataField(name);
                if (dataField2 == null) {
                    throw new MissingFieldException(name, (PMMLObject)miningField);
                }
                Target target = this.getTarget(name);
                TargetField targetField = new TargetField(dataField2, miningField, target);
                targetFields.add(targetField);
            }
        }
        if (targetFields.isEmpty() && (dataField = this.getDataField()) != null) {
            Target target = this.getTarget(dataField.getName());
            TargetField targetField = new TargetField(dataField, null, target);
            targetFields.add(targetField);
        }
        return ImmutableList.copyOf(targetFields);
    }

    protected List<OutputField> createOutputFields() {
        M model = this.getModel();
        Output output = model.getOutput();
        ArrayList<OutputField> resultFields = new ArrayList<OutputField>();
        if (output != null && output.hasOutputFields()) {
            List outputFields = output.getOutputFields();
            Predicate<org.dmg.pmml.OutputField> outputFilter = this.ensureOutputFilter();
            for (org.dmg.pmml.OutputField outputField : outputFields) {
                if (!outputFilter.test(outputField)) continue;
                OutputField resultField = new OutputField(outputField);
                resultFields.add(resultField);
            }
        }
        return ImmutableList.copyOf(resultFields);
    }

    protected Set<ResultFeature> collectResultFeatures() {
        M model = this.getModel();
        Output output = model.getOutput();
        EnumSet<ResultFeature> resultFeatures = EnumSet.noneOf(ResultFeature.class);
        if (output != null && output.hasOutputFields()) {
            List outputFields = output.getOutputFields();
            for (org.dmg.pmml.OutputField outputField : outputFields) {
                resultFeatures.add(outputField.getResultFeature());
            }
        }
        return Sets.immutableEnumSet(resultFeatures);
    }

    public <V> V getValue(LoadingCache<M, V> cache) {
        M model = this.getModel();
        return CacheUtil.getValue(model, cache);
    }

    public <V> V getValue(Cache<M, V> cache, Callable<? extends V> loader) {
        M model = this.getModel();
        return CacheUtil.getValue(model, cache, loader);
    }

    protected Configuration ensureConfiguration() {
        Configuration configuration = this.getConfiguration();
        if (this.configuration == null) {
            throw new IllegalStateException();
        }
        return this.configuration;
    }

    protected ModelEvaluatorFactory ensureModelEvaluatorFactory() {
        Configuration configuration = this.ensureConfiguration();
        return configuration.getModelEvaluatorFactory();
    }

    protected ValueFactoryFactory ensureValueFactoryFactory() {
        Configuration configuration = this.ensureConfiguration();
        return configuration.getValueFactoryFactory();
    }

    protected Predicate<org.dmg.pmml.OutputField> ensureOutputFilter() {
        Configuration configuration = this.ensureConfiguration();
        return configuration.getOutputFilter();
    }

    protected ValueFactory<?> ensureValueFactory() {
        ValueFactory<?> valueFactory = this.getValueFactory();
        if (valueFactory == null) {
            ValueFactoryFactory valueFactoryFactory = this.ensureValueFactoryFactory();
            MathContext mathContext = this.getMathContext();
            valueFactory = valueFactoryFactory.newValueFactory(mathContext);
            this.setValueFactory(valueFactory);
        }
        return valueFactory;
    }

    @Override
    public PMML getPMML() {
        return this.pmml;
    }

    private void setPMML(PMML pmml) {
        this.pmml = pmml;
    }

    @Override
    public M getModel() {
        return this.model;
    }

    private void setModel(M model) {
        this.model = model;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    private void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    private ValueFactory<?> getValueFactory() {
        return this.valueFactory;
    }

    private void setValueFactory(ValueFactory<?> valueFactory) {
        this.valueFactory = valueFactory;
    }

    private static <F extends ModelField> F findModelField(Collection<? extends F> fields, FieldName name) {
        for (ModelField field : fields) {
            if (!Objects.equals(field.getName(), name)) continue;
            return (F)field;
        }
        return null;
    }

    private static VerificationBatch parseModelVerification(ModelVerification modelVerification) {
        VerificationBatch result = new VerificationBatch();
        VerificationFields verificationFields = modelVerification.getVerificationFields();
        if (verificationFields == null) {
            throw new MissingElementException((PMMLObject)modelVerification, PMMLElements.MODELVERIFICATION_VERIFICATIONFIELDS);
        }
        for (VerificationField verificationField : verificationFields) {
            result.put(verificationField.getField(), verificationField);
        }
        InlineTable inlineTable = modelVerification.getInlineTable();
        if (inlineTable == null) {
            throw new MissingElementException((PMMLObject)modelVerification, PMMLElements.MODELVERIFICATION_INLINETABLE);
        }
        Table<Integer, String, String> table = InlineTableUtil.getContent(inlineTable);
        ArrayList records = new ArrayList();
        Set rowKeys = table.rowKeySet();
        for (Integer rowKey : rowKeys) {
            Map row = table.row((Object)rowKey);
            LinkedHashMap record = new LinkedHashMap();
            for (VerificationField verificationField : verificationFields) {
                FieldName name = verificationField.getField();
                String column = verificationField.getColumn();
                if (column == null) {
                    column = name.getValue();
                }
                if (!row.containsKey(column)) continue;
                record.put(name, row.get(column));
            }
            records.add(record);
        }
        Integer recordCount = modelVerification.getRecordCount();
        if (recordCount != null && recordCount.intValue() != records.size()) {
            throw new InvalidElementException((PMMLObject)modelVerification);
        }
        result.setRecords(records);
        return result;
    }

    private static class VerificationBatch
    extends LinkedHashMap<FieldName, VerificationField> {
        private List<Map<FieldName, Object>> records = null;

        private VerificationBatch() {
        }

        public List<Map<FieldName, Object>> getRecords() {
            return this.records;
        }

        private void setRecords(List<Map<FieldName, Object>> records) {
            this.records = records;
        }
    }
}

