/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.Configuration;
import org.jpmml.evaluator.ConfigurationBuilder;
import org.jpmml.evaluator.EvaluatorBuilder;
import org.jpmml.evaluator.HasGroupFields;
import org.jpmml.evaluator.InputField;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.OutputField;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.ResultField;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.ValueFactoryFactory;

public class ModelEvaluatorBuilder
implements EvaluatorBuilder,
Serializable {
    private PMML pmml = null;
    private Model model = null;
    private ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
    private Function<FieldName, FieldName> inputMapper = null;
    private Function<FieldName, FieldName> resultMapper = null;

    protected ModelEvaluatorBuilder() {
    }

    public ModelEvaluatorBuilder(PMML pmml) {
        this(pmml, (String)null);
    }

    public ModelEvaluatorBuilder(PMML pmml, String modelName) {
        this.setPMML(Objects.requireNonNull(pmml));
        this.setModel(PMMLUtil.findModel(pmml, modelName));
    }

    public ModelEvaluatorBuilder(PMML pmml, Model model) {
        this.setPMML(Objects.requireNonNull(pmml));
        this.setModel(Objects.requireNonNull(model));
    }

    @Override
    public ModelEvaluatorBuilder clone() {
        ModelEvaluatorBuilder modelEvaluatorBuilder;
        try {
            modelEvaluatorBuilder = (ModelEvaluatorBuilder)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse);
        }
        modelEvaluatorBuilder.configurationBuilder = modelEvaluatorBuilder.configurationBuilder.clone();
        return modelEvaluatorBuilder;
    }

    @Override
    public ModelEvaluator<?> build() {
        PMML pmml = this.getPMML();
        Model model = this.getModel();
        if (pmml == null || model == null) {
            throw new IllegalStateException();
        }
        ConfigurationBuilder configurationBuilder = this.getConfigurationBuilder();
        Configuration configuration = configurationBuilder.build();
        ModelEvaluatorFactory modelEvaluatorFactory = configuration.getModelEvaluatorFactory();
        ModelEvaluator<?> modelEvaluator = modelEvaluatorFactory.newModelEvaluator(pmml, model);
        modelEvaluator.configure(configuration);
        this.checkSchema(modelEvaluator);
        Function<FieldName, FieldName> inputMapper = this.getInputMapper();
        Function<FieldName, FieldName> resultMapper = this.getResultMapper();
        if (inputMapper != null) {
            Iterable<InputField> inputFields = modelEvaluator.getInputFields();
            if (modelEvaluator instanceof HasGroupFields) {
                HasGroupFields hasGroupFields = (HasGroupFields)((Object)modelEvaluator);
                inputFields = Iterables.concat(inputFields, hasGroupFields.getGroupFields());
            }
            for (InputField inputField : inputFields) {
                inputField.setName(inputMapper.apply(inputField.getName()));
            }
        }
        if (resultMapper != null) {
            Iterable resultFields = Iterables.concat(modelEvaluator.getTargetFields(), modelEvaluator.getOutputFields());
            for (ResultField resultField : resultFields) {
                resultField.setName(resultMapper.apply(resultField.getName()));
            }
        }
        return modelEvaluator;
    }

    protected void checkSchema(ModelEvaluator<?> modelEvaluator) {
        Object model = modelEvaluator.getModel();
        MiningSchema miningSchema = model.getMiningSchema();
        List<InputField> inputFields = modelEvaluator.getInputFields();
        List<Object> groupFields = Collections.emptyList();
        if (modelEvaluator instanceof HasGroupFields) {
            HasGroupFields hasGroupFields = (HasGroupFields)((Object)modelEvaluator);
            groupFields = hasGroupFields.getGroupFields();
        }
        if (inputFields.size() + groupFields.size() > 1000) {
            throw new InvalidElementException("Model has too many input fields", (PMMLObject)miningSchema);
        }
        List<TargetField> targetFields = modelEvaluator.getTargetFields();
        List<OutputField> outputFields = modelEvaluator.getOutputFields();
        if (targetFields.size() + outputFields.size() < 1) {
            throw new InvalidElementException("Model does not have any target or output fields", (PMMLObject)miningSchema);
        }
    }

    public PMML getPMML() {
        return this.pmml;
    }

    protected ModelEvaluatorBuilder setPMML(PMML pmml) {
        this.pmml = pmml;
        return this;
    }

    public Model getModel() {
        return this.model;
    }

    protected ModelEvaluatorBuilder setModel(Model model) {
        this.model = model;
        return this;
    }

    public ConfigurationBuilder getConfigurationBuilder() {
        return this.configurationBuilder;
    }

    public ModelEvaluatorFactory getModelEvaluatorFactory() {
        ConfigurationBuilder configurationBuilder = this.getConfigurationBuilder();
        return configurationBuilder.getModelEvaluatorFactory();
    }

    public ModelEvaluatorBuilder setModelEvaluatorFactory(ModelEvaluatorFactory modelEvaluatorFactory) {
        ConfigurationBuilder configurationBuilder = this.getConfigurationBuilder();
        configurationBuilder.setModelEvaluatorFactory(modelEvaluatorFactory);
        return this;
    }

    public ValueFactoryFactory getValueFactoryFactory() {
        ConfigurationBuilder configurationBuilder = this.getConfigurationBuilder();
        return configurationBuilder.getValueFactoryFactory();
    }

    public ModelEvaluatorBuilder setValueFactoryFactory(ValueFactoryFactory valueFactoryFactory) {
        ConfigurationBuilder configurationBuilder = this.getConfigurationBuilder();
        configurationBuilder.setValueFactoryFactory(valueFactoryFactory);
        return this;
    }

    public Predicate<org.dmg.pmml.OutputField> getOutputFilter() {
        ConfigurationBuilder configurationBuilder = this.getConfigurationBuilder();
        return configurationBuilder.getOutputFilter();
    }

    public ModelEvaluatorBuilder setOutputFilter(Predicate<org.dmg.pmml.OutputField> outputFilter) {
        ConfigurationBuilder configurationBuilder = this.getConfigurationBuilder();
        configurationBuilder.setOutputFilter(outputFilter);
        return this;
    }

    public Function<FieldName, FieldName> getInputMapper() {
        return this.inputMapper;
    }

    public ModelEvaluatorBuilder setInputMapper(Function<FieldName, FieldName> inputMapper) {
        this.inputMapper = inputMapper;
        return this;
    }

    public Function<FieldName, FieldName> getResultMapper() {
        return this.resultMapper;
    }

    public ModelEvaluatorBuilder setResultMapper(Function<FieldName, FieldName> resultMapper) {
        this.resultMapper = resultMapper;
        return this;
    }
}

