/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.jpmml.evaluator.DoubleValue;
import org.jpmml.evaluator.HasReport;
import org.jpmml.evaluator.Report;
import org.jpmml.evaluator.Value;

public class ReportingDoubleValue
extends DoubleValue
implements HasReport {
    private Report report = null;

    public ReportingDoubleValue(double value, Report report) {
        super(value);
        this.setReport(report);
        this.report(new StringBuilder(256).append("<cn>").append(value).append("</cn>").toString());
    }

    public ReportingDoubleValue(double value, Report report, String expression) {
        super(value);
        this.setReport(report);
        if (expression != null) {
            this.report(expression);
        }
    }

    @Override
    public ReportingDoubleValue copy() {
        Report report = this.getReport();
        return new ReportingDoubleValue(this.value, report.copy(), null);
    }

    @Override
    public ReportingDoubleValue add(double value) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.add(value);
        if (this.hasExpression()) {
            this.report(new StringBuilder(256).append("<apply><plus/>").append(this.getExpression()).append("<cn>").append(value).append("</cn>").append("</apply>").toString());
        } else {
            this.report(new StringBuilder(256).append("<cn>").append(value).append("</cn>").toString());
        }
        return result;
    }

    @Override
    public ReportingDoubleValue add(Value<? extends Number> value) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.add((Value)value);
        if (this.hasExpression()) {
            this.report(new StringBuilder(256).append("<apply><plus/>").append(this.getExpression()).append("<cn>").append(value.doubleValue()).append("</cn>").append("</apply>").toString());
        } else {
            this.report(new StringBuilder(256).append("<cn>").append(value.doubleValue()).append("</cn>").toString());
        }
        return result;
    }

    @Override
    public ReportingDoubleValue add(double coefficient, Number factor) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.add(coefficient, factor);
        if (this.hasExpression()) {
            this.report(new StringBuilder(256).append("<apply><plus/>").append(this.getExpression()).append("<apply><times/>").append("<cn>").append(coefficient).append("</cn>").append("<cn>").append(factor.doubleValue()).append("</cn>").append("</apply></apply>").toString());
        } else {
            this.report(new StringBuilder(256).append("<apply><times/>").append("<cn>").append(coefficient).append("</cn>").append("<cn>").append(factor.doubleValue()).append("</cn>").append("</apply>").toString());
        }
        return result;
    }

    @Override
    public ReportingDoubleValue add(double coefficient, Number firstFactor, Number secondFactor) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.add(coefficient, firstFactor, secondFactor);
        if (this.hasExpression()) {
            this.report(new StringBuilder(256).append("<apply><plus/>").append(this.getExpression()).append("<apply><times/>").append("<cn>").append(coefficient).append("</cn>").append("<cn>").append(firstFactor.doubleValue()).append("</cn>").append("<cn>").append(secondFactor.doubleValue()).append("</cn>").append("</apply></apply>").toString());
        } else {
            this.report(new StringBuilder(256).append("<apply><times/>").append("<cn>").append(coefficient).append("</cn>").append("<cn>").append(firstFactor.doubleValue()).append("</cn>").append("<cn>").append(secondFactor.doubleValue()).append("</cn>").append("</apply>").toString());
        }
        return result;
    }

    @Override
    public ReportingDoubleValue add(double coefficient, Number ... factors) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.add(coefficient);
        if (this.hasExpression()) {
            this.report(new StringBuilder(256).append("<apply><plus/>").append(this.getExpression()).append("<apply><times/>").append("<cn>").append(coefficient).append("</cn>").append(ReportingDoubleValue.format(factors)).append("</apply></apply>").toString());
        } else {
            this.report(new StringBuilder(256).append("<apply><times/>").append("<cn>").append(coefficient).append("</cn>").append(ReportingDoubleValue.format(factors)).append("</apply>").toString());
        }
        return result;
    }

    @Override
    public ReportingDoubleValue add(double coefficient, Number factor, int exponent) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.add(coefficient, factor, exponent);
        if (this.hasExpression()) {
            this.report(new StringBuilder(256).append("<apply><plus/>").append(this.getExpression()).append("<apply><times/>").append("<cn>").append(coefficient).append("</cn>").append("<apply><power/>").append("<cn>").append(factor.doubleValue()).append("</cn>").append("<cn>").append((double)exponent).append("</cn>").append("</apply></apply></apply>").toString());
        } else {
            this.report(new StringBuilder(256).append("<apply><times/>").append("<cn>").append(coefficient).append("</cn>").append("<apply><power/>").append("<cn>").append(factor.doubleValue()).append("</cn>").append("<cn>").append((double)exponent).append("</cn>").append("</apply></apply>").toString());
        }
        return result;
    }

    @Override
    public ReportingDoubleValue subtract(double value) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.subtract(value);
        if (this.hasExpression()) {
            this.report(new StringBuilder(256).append("<apply><minus/>").append(this.getExpression()).append("<cn>").append(value).append("</cn>").append("</apply>").toString());
        } else {
            this.report(new StringBuilder(256).append("<apply><minus/>").append("<cn>").append(value).append("</cn>").append("</apply>").toString());
        }
        return result;
    }

    @Override
    public ReportingDoubleValue subtract(Value<? extends Number> value) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.subtract((Value)value);
        if (this.hasExpression()) {
            this.report(new StringBuilder(256).append("<apply><minus/>").append(this.getExpression()).append("<cn>").append(value.doubleValue()).append("</cn>").append("</apply>").toString());
        } else {
            this.report(new StringBuilder(256).append("<apply><minus/>").append("<cn>").append(value.doubleValue()).append("</cn>").append("</apply>").toString());
        }
        return result;
    }

    @Override
    public ReportingDoubleValue multiply(double value) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.multiply(value);
        this.report(new StringBuilder(256).append("<apply><times/>").append(this.getExpression()).append("<cn>").append(value).append("</cn>").append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue multiply(Value<? extends Number> value) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.multiply((Value)value);
        this.report(new StringBuilder(256).append("<apply><times/>").append(this.getExpression()).append("<cn>").append(value.doubleValue()).append("</cn>").append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue multiply(Number factor, double exponent) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.multiply(factor, exponent);
        this.report(new StringBuilder(256).append("<apply><times/>").append(this.getExpression()).append("<apply><power/>").append("<cn>").append(factor.doubleValue()).append("</cn>").append("<cn>").append(exponent).append("</cn>").append("</apply></apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue divide(double value) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.divide(value);
        this.report(new StringBuilder(256).append("<apply><divide/>").append(this.getExpression()).append("<cn>").append(value).append("</cn>").append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue divide(Value<? extends Number> value) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.divide((Value)value);
        this.report(new StringBuilder(256).append("<apply><divide/>").append(this.getExpression()).append("<cn>").append(value.doubleValue()).append("</cn>").append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue residual(Value<? extends Number> value) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.residual((Value)value);
        this.report(new StringBuilder(256).append("<apply><minus/><cn>1</cn>").append("<cn>").append(value.doubleValue()).append("</cn>").append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue square() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.square();
        this.report(new StringBuilder(256).append("<apply><power/>").append(this.getExpression()).append("<cn>2</cn></apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue power(double value) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.power(value);
        this.report(new StringBuilder(256).append("<apply><power/>").append(this.getExpression()).append("{0}</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue reciprocal() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.reciprocal();
        this.report(new StringBuilder(256).append("<apply><divide/><cn>1</cn>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue elliott() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.elliott();
        this.report(new StringBuilder(256).append("<apply><ci>elliott</ci>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue exp() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.exp();
        this.report(new StringBuilder(256).append("<apply><exp/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue ln() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.ln();
        this.report(new StringBuilder(256).append("<apply><ln/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue gauss() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.gauss();
        this.report(new StringBuilder(256).append("<apply><ci>gauss</ci>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue inverseLogit() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.inverseLogit();
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>logit</ci></apply>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue inverseCloglog() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.inverseCloglog();
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>cloglog</ci></apply>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue inverseLoglog() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.inverseLoglog();
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>loglog</ci></apply>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue inverseLogc() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.inverseLogc();
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>logc</ci></apply>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue inverseNegbin(double value) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.inverseNegbin(value);
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>negbin</ci></apply>").append(this.getExpression()).append("<cn>").append(value).append("</cn>").append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue inverseOddspower(double value) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.inverseOddspower(value);
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>oddspower</ci></apply>").append(this.getExpression()).append("<cn>").append(value).append("</cn>").append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue inversePower(double value) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.inversePower(value);
        this.report(new StringBuilder(256).append("<apply><power/>").append(this.getExpression()).append("<apply><divide/><cn>1</cn>").append("<cn>").append(value).append("</cn>").append("</apply></apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue inverseCauchit() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.inverseCauchit();
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>cauchit</ci></apply>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue inverseProbit() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.inverseProbit();
        this.report(new StringBuilder(256).append("<apply><apply><inverse/><ci>probit</ci></apply>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue sin() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.sin();
        this.report(new StringBuilder(256).append("<apply><sin/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue cos() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.cos();
        this.report(new StringBuilder(256).append("<apply><cos/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue arctan() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.arctan();
        this.report(new StringBuilder(256).append("<apply><divide/><apply><times/><cn>2</cn><apply><arctan/>").append(this.getExpression()).append("</apply></apply><pi/></apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue tanh() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.tanh();
        this.report(new StringBuilder(256).append("<apply><tanh/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue threshold(double value) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.threshold(value);
        this.report(new StringBuilder(256).append("<apply><ci>threshold</ci>").append(this.getExpression()).append("<cn>").append(value).append("</cn>").append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue relu() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.relu();
        this.report(new StringBuilder(256).append("<apply><max/><cn>0</cn>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue abs() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.abs();
        this.report(new StringBuilder(256).append("<apply><abs/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue gaussSim(double value) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.gaussSim(value);
        this.report(new StringBuilder(256).append("<apply><ci>gaussSim</ci>").append(this.getExpression()).append("<cn>").append(value).append("</cn>").append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue restrict(double lowValue, double highValue) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.restrict(lowValue, highValue);
        this.report(new StringBuilder(256).append("<apply><max/>").append("<cn>").append(lowValue).append("</cn>").append("<apply><min/>").append("<cn>").append(highValue).append("</cn>").append(this.getExpression()).append("</apply></apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue round() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.round();
        this.report(new StringBuilder(256).append("<apply><ci>round</ci>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue ceiling() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.ceiling();
        this.report(new StringBuilder(256).append("<apply><ceiling/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue floor() {
        ReportingDoubleValue result = (ReportingDoubleValue)super.floor();
        this.report(new StringBuilder(256).append("<apply><floor/>").append(this.getExpression()).append("</apply>").toString());
        return result;
    }

    @Override
    public ReportingDoubleValue denormalize(double leftOrig, double leftNorm, double rightOrig, double rightNorm) {
        ReportingDoubleValue result = (ReportingDoubleValue)super.denormalize(leftOrig, leftNorm, rightOrig, rightNorm);
        this.report(new StringBuilder(256).append("<apply><ci>denormalize</ci>").append(this.getExpression()).append("<cn>").append(leftOrig).append("</cn>").append("<cn>").append(leftNorm).append("</cn>").append("<cn>").append(rightOrig).append("</cn>").append("<cn>").append(rightNorm).append("</cn>").append("</apply>").toString());
        return result;
    }

    private void report(String expression) {
        Report report = this.getReport();
        Report.Entry entry = new Report.Entry(expression, this.getValue());
        report.add(entry);
    }

    private boolean hasExpression() {
        Report report = this.getReport();
        return report.hasEntries();
    }

    private String getExpression() {
        Report report = this.getReport();
        Report.Entry entry = report.tailEntry();
        return entry.getExpression();
    }

    @Override
    public Report getReport() {
        return this.report;
    }

    private void setReport(Report report) {
        this.report = report;
    }

    private static String format(Number ... values) {
        StringBuilder sb = new StringBuilder(values.length * 32);
        for (Number value : values) {
            sb.append("<cn>").append(value.doubleValue()).append("</cn>").toString();
        }
        return sb.toString();
    }
}

