/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.rule_set;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.rule_set.CompoundRule;
import org.dmg.pmml.rule_set.Rule;
import org.dmg.pmml.rule_set.RuleSelectionMethod;
import org.dmg.pmml.rule_set.RuleSet;
import org.dmg.pmml.rule_set.RuleSetModel;
import org.dmg.pmml.rule_set.SimpleRule;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.EntityUtil;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.PMMLAttributes;
import org.jpmml.evaluator.PMMLElements;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.PredicateUtil;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TargetUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.UnsupportedElementException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.rule_set.SimpleRuleScoreDistribution;

public class RuleSetModelEvaluator
extends ModelEvaluator<RuleSetModel>
implements HasEntityRegistry<SimpleRule> {
    private transient BiMap<String, SimpleRule> entityRegistry = null;
    private static final LoadingCache<RuleSetModel, BiMap<String, SimpleRule>> entityCache = CacheUtil.buildLoadingCache(new CacheLoader<RuleSetModel, BiMap<String, SimpleRule>>(){

        public BiMap<String, SimpleRule> load(RuleSetModel ruleSetModel) {
            ImmutableBiMap.Builder<String, SimpleRule> builder = new ImmutableBiMap.Builder<String, SimpleRule>();
            RuleSet ruleSet = ruleSetModel.getRuleSet();
            builder = this.collectRules(ruleSet.getRules(), new AtomicInteger(1), builder);
            return builder.build();
        }

        private ImmutableBiMap.Builder<String, SimpleRule> collectRule(Rule rule, AtomicInteger index, ImmutableBiMap.Builder<String, SimpleRule> builder) {
            if (rule instanceof SimpleRule) {
                SimpleRule simpleRule = (SimpleRule)rule;
                builder = EntityUtil.put(simpleRule, index, builder);
            } else if (rule instanceof CompoundRule) {
                CompoundRule compoundRule = (CompoundRule)rule;
                builder = this.collectRules(compoundRule.getRules(), index, builder);
            } else {
                throw new UnsupportedElementException((PMMLObject)rule);
            }
            return builder;
        }

        private ImmutableBiMap.Builder<String, SimpleRule> collectRules(List<Rule> rules, AtomicInteger index, ImmutableBiMap.Builder<String, SimpleRule> builder) {
            for (Rule rule : rules) {
                builder = this.collectRule(rule, index, builder);
            }
            return builder;
        }
    });

    public RuleSetModelEvaluator(PMML pmml) {
        this(pmml, PMMLUtil.findModel(pmml, RuleSetModel.class));
    }

    public RuleSetModelEvaluator(PMML pmml, RuleSetModel ruleSetModel) {
        super(pmml, ruleSetModel);
        RuleSet ruleSet = ruleSetModel.getRuleSet();
        if (ruleSet == null) {
            throw new MissingElementException((PMMLObject)ruleSetModel, PMMLElements.RULESETMODEL_RULESET);
        }
        if (!ruleSet.hasRuleSelectionMethods()) {
            throw new MissingElementException((PMMLObject)ruleSet, PMMLElements.RULESET_RULESELECTIONMETHODS);
        }
    }

    @Override
    public String getSummary() {
        return "Ruleset model";
    }

    @Override
    public BiMap<String, SimpleRule> getEntityRegistry() {
        if (this.entityRegistry == null) {
            this.entityRegistry = this.getValue(entityCache);
        }
        return this.entityRegistry;
    }

    @Override
    protected <V extends Number> Map<FieldName, ? extends Classification<V>> evaluateClassification(ValueFactory<V> valueFactory, EvaluationContext context) {
        RuleSetModel ruleSetModel = (RuleSetModel)this.getModel();
        RuleSet ruleSet = ruleSetModel.getRuleSet();
        TargetField targetField = this.getTargetField();
        List ruleSelectionMethods = ruleSet.getRuleSelectionMethods();
        RuleSelectionMethod ruleSelectionMethod = (RuleSelectionMethod)ruleSelectionMethods.get(0);
        LinkedListMultimap firedRules = LinkedListMultimap.create();
        RuleSetModelEvaluator.evaluateRules(ruleSet.getRules(), (ListMultimap<String, SimpleRule>)firedRules, context);
        SimpleRuleScoreDistribution result = new SimpleRuleScoreDistribution<V>(new ValueMap(2 * firedRules.size())){

            @Override
            public BiMap<String, SimpleRule> getEntityRegistry() {
                return RuleSetModelEvaluator.this.getEntityRegistry();
            }
        };
        if (firedRules.size() == 0) {
            String defaultScore = ruleSet.getDefaultScore();
            if (defaultScore == null) {
                throw new MissingAttributeException((PMMLObject)ruleSet, PMMLAttributes.RULESET_DEFAULTSCORE);
            }
            Double defaultConfidence = ruleSet.getDefaultConfidence();
            if (defaultConfidence == null) {
                throw new MissingAttributeException((PMMLObject)ruleSet, PMMLAttributes.RULESET_DEFAULTCONFIDENCE);
            }
            Value<V> value = valueFactory.newValue(defaultConfidence);
            result.put(new SimpleRule(defaultScore), defaultScore, value);
            return TargetUtil.evaluateClassification(targetField, result);
        }
        RuleSelectionMethod.Criterion criterion = ruleSelectionMethod.getCriterion();
        if (criterion == null) {
            throw new MissingAttributeException((PMMLObject)ruleSelectionMethod, PMMLAttributes.RULESELECTIONMETHOD_CRITERION);
        }
        Set keys = firedRules.keySet();
        block5: for (String key : keys) {
            List keyRules = firedRules.get((Object)key);
            switch (criterion) {
                case FIRST_HIT: {
                    SimpleRule winner = (SimpleRule)keyRules.get(0);
                    if (result.getEntity() == null) {
                        result.setEntity(winner);
                    }
                    Value<V> value = valueFactory.newValue(winner.getConfidence());
                    result.put(key, value);
                    continue block5;
                }
                case WEIGHTED_SUM: {
                    SimpleRule winner = null;
                    Value<V> totalWeight = valueFactory.newValue();
                    for (SimpleRule keyRule : keyRules) {
                        Double weight = keyRule.getWeight();
                        if (winner == null || winner.getWeight() < weight) {
                            winner = keyRule;
                        }
                        totalWeight.add(weight);
                    }
                    Value value = totalWeight.divide(firedRules.size());
                    result.put(winner, key, value);
                    continue block5;
                }
                case WEIGHTED_MAX: {
                    SimpleRule winner = null;
                    for (SimpleRule keyRule : keyRules) {
                        if (winner != null && !(winner.getWeight() < keyRule.getWeight())) continue;
                        winner = keyRule;
                    }
                    Value<V> value = valueFactory.newValue(winner.getConfidence());
                    result.put(winner, key, value);
                    continue block5;
                }
            }
            throw new UnsupportedAttributeException((PMMLObject)ruleSelectionMethod, (Enum<?>)criterion);
        }
        return TargetUtil.evaluateClassification(targetField, result);
    }

    private static void evaluateRules(List<Rule> rules, ListMultimap<String, SimpleRule> firedRules, EvaluationContext context) {
        for (Rule rule : rules) {
            RuleSetModelEvaluator.evaluateRule(rule, firedRules, context);
        }
    }

    private static void evaluateRule(Rule rule, ListMultimap<String, SimpleRule> firedRules, EvaluationContext context) {
        Boolean status = PredicateUtil.evaluatePredicateContainer(rule, context);
        if (status == null || !status.booleanValue()) {
            return;
        }
        if (rule instanceof SimpleRule) {
            SimpleRule simpleRule = (SimpleRule)rule;
            firedRules.put((Object)simpleRule.getScore(), (Object)simpleRule);
        } else if (rule instanceof CompoundRule) {
            CompoundRule compoundRule = (CompoundRule)rule;
            RuleSetModelEvaluator.evaluateRules(compoundRule.getRules(), firedRules, context);
        } else {
            throw new UnsupportedElementException((PMMLObject)rule);
        }
    }
}

