/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.Serializable;
import org.dmg.pmml.FieldName;
import org.jpmml.evaluator.Configuration;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.OutputFilter;
import org.jpmml.evaluator.OutputFilters;
import org.jpmml.evaluator.SymbolTable;
import org.jpmml.evaluator.ValueFactoryFactory;

public class ConfigurationBuilder
implements Cloneable,
Serializable {
    private ModelEvaluatorFactory modelEvaluatorFactory = null;
    private ValueFactoryFactory valueFactoryFactory = null;
    private OutputFilter outputFilter = null;
    private SymbolTable<FieldName> derivedFieldGuard = null;
    private SymbolTable<String> functionGuard = null;

    public ConfigurationBuilder clone() {
        try {
            return (ConfigurationBuilder)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse);
        }
    }

    public Configuration build() {
        Configuration configuration = new Configuration();
        ModelEvaluatorFactory modelEvaluatorFactory = this.getModelEvaluatorFactory();
        if (modelEvaluatorFactory == null) {
            modelEvaluatorFactory = ModelEvaluatorFactory.newInstance();
        }
        configuration.setModelEvaluatorFactory(modelEvaluatorFactory);
        ValueFactoryFactory valueFactoryFactory = this.getValueFactoryFactory();
        if (valueFactoryFactory == null) {
            valueFactoryFactory = ValueFactoryFactory.newInstance();
        }
        configuration.setValueFactoryFactory(valueFactoryFactory);
        OutputFilter outputFilter = this.getOutputFilter();
        if (outputFilter == null) {
            outputFilter = OutputFilters.KEEP_ALL;
        }
        configuration.setOutputFilter(outputFilter);
        SymbolTable<FieldName> derivedFieldGuard = this.getDerivedFieldGuard();
        SymbolTable<String> functionGuard = this.getFunctionGuard();
        configuration.setDerivedFieldGuard(derivedFieldGuard);
        configuration.setFunctionGuard(functionGuard);
        return configuration;
    }

    public ModelEvaluatorFactory getModelEvaluatorFactory() {
        return this.modelEvaluatorFactory;
    }

    public ConfigurationBuilder setModelEvaluatorFactory(ModelEvaluatorFactory modelEvaluatorFactory) {
        this.modelEvaluatorFactory = modelEvaluatorFactory;
        return this;
    }

    public ValueFactoryFactory getValueFactoryFactory() {
        return this.valueFactoryFactory;
    }

    public ConfigurationBuilder setValueFactoryFactory(ValueFactoryFactory valueFactoryFactory) {
        this.valueFactoryFactory = valueFactoryFactory;
        return this;
    }

    public OutputFilter getOutputFilter() {
        return this.outputFilter;
    }

    public ConfigurationBuilder setOutputFilter(OutputFilter outputFilter) {
        this.outputFilter = outputFilter;
        return this;
    }

    public SymbolTable<FieldName> getDerivedFieldGuard() {
        return this.derivedFieldGuard;
    }

    public ConfigurationBuilder setDerivedFieldGuard(SymbolTable<FieldName> derivedFieldGuard) {
        this.derivedFieldGuard = derivedFieldGuard;
        return this;
    }

    public SymbolTable<String> getFunctionGuard() {
        return this.functionGuard;
    }

    public ConfigurationBuilder setFunctionGuard(SymbolTable<String> functionGuard) {
        this.functionGuard = functionGuard;
        return this;
    }
}

