/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.general_regression;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlTransient;
import org.dmg.pmml.DataType;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.general_regression.BaseCumHazardTables;
import org.dmg.pmml.general_regression.BaselineStratum;
import org.dmg.pmml.general_regression.PMMLAttributes;
import org.jpmml.evaluator.MapHolder;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.model.ReflectionUtil;

public class RichBaseCumHazardTables
extends BaseCumHazardTables
implements MapHolder<BaselineStratum> {
    @XmlTransient
    private DataType dataType = null;
    @XmlTransient
    private Map<?, BaselineStratum> baselineStratumMap = null;

    public RichBaseCumHazardTables(DataType dataType) {
        this.setDataType(dataType);
    }

    public RichBaseCumHazardTables(DataType dataType, BaseCumHazardTables baseCumHazardTables) {
        this.setDataType(dataType);
        ReflectionUtil.copyState((PMMLObject)baseCumHazardTables, (PMMLObject)this);
    }

    @Override
    public Map<?, BaselineStratum> getMap() {
        if (this.baselineStratumMap == null) {
            this.baselineStratumMap = ImmutableMap.copyOf(this.parseBaselineStrata());
        }
        return this.baselineStratumMap;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    private void setDataType(DataType dataType) {
        this.dataType = Objects.requireNonNull(dataType);
    }

    private Map<?, BaselineStratum> parseBaselineStrata() {
        DataType dataType = this.getDataType();
        LinkedHashMap<Object, BaselineStratum> result = new LinkedHashMap<Object, BaselineStratum>();
        List baselineStrata = this.getBaselineStrata();
        for (BaselineStratum baselineStratum : baselineStrata) {
            Object category = baselineStratum.getValue();
            if (category == null) {
                throw new MissingAttributeException((PMMLObject)baselineStratum, PMMLAttributes.BASELINESTRATUM_VALUE);
            }
            Object value = TypeUtil.parseOrCast(dataType, category);
            result.put(value, baselineStratum);
        }
        return result;
    }
}

