/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.model.ToStringHelper;

public class CollectionValue
extends FieldValue {
    private OpType opType = null;
    private List<?> ordering = null;

    CollectionValue(DataType dataType, OpType opType, Collection<?> value) {
        this(dataType, opType, null, value);
    }

    CollectionValue(DataType dataType, OpType opType, List<?> ordering, Collection<?> value) {
        super(dataType, value);
        this.setOpType(Objects.requireNonNull(opType));
        switch (opType) {
            case CONTINUOUS: 
            case CATEGORICAL: {
                if (ordering == null) break;
                throw new IllegalArgumentException();
            }
            case ORDINAL: {
                this.setOrdering(ordering);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public boolean isValid() {
        throw new EvaluationException("Collection value cannot be queried for validity");
    }

    @Override
    public int compareToValue(Object value) {
        throw new EvaluationException("Collection value cannot be used in comparison operations");
    }

    @Override
    public int compareToValue(FieldValue value) {
        throw new EvaluationException("Collection value cannot be used in comparison operations");
    }

    @Override
    public int hashCode() {
        List<?> ordering = this.getOrdering();
        if (ordering == null) {
            return super.hashCode();
        }
        return 31 * super.hashCode() + ordering.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof CollectionValue) {
            CollectionValue that = (CollectionValue)object;
            return super.equals(object) && Objects.equals(this.getOrdering(), that.getOrdering());
        }
        return false;
    }

    @Override
    protected ToStringHelper toStringHelper() {
        ToStringHelper helper = super.toStringHelper().add("ordering", this.getOrdering());
        return helper;
    }

    @Override
    public OpType getOpType() {
        return this.opType;
    }

    private void setOpType(OpType opType) {
        this.opType = opType;
    }

    @Override
    public List<?> getOrdering() {
        return this.ordering;
    }

    private void setOrdering(List<?> ordering) {
        this.ordering = ordering;
    }

    @Override
    public Collection<?> getValue() {
        return (Collection)super.getValue();
    }
}

