/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collection;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.CollectionValue;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.ScalarValue;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;

public class ContinuousValue
extends ScalarValue {
    ContinuousValue(DataType dataType, Object value) {
        super(dataType, value);
    }

    @Override
    public OpType getOpType() {
        return OpType.CONTINUOUS;
    }

    @Override
    public int compareToValue(Object value) {
        try {
            return super.compareToValue(value);
        }
        catch (IllegalArgumentException | TypeCheckException e) {
            Number number;
            try {
                number = (Number)TypeUtil.parseOrCast(DataType.DOUBLE, value);
            }
            catch (NumberFormatException nfeDouble) {
                throw e;
            }
            return this.asDouble().compareTo(number);
        }
    }

    @Override
    public int compareToValue(FieldValue value) {
        return super.compareToValue(value);
    }

    public static FieldValue create(DataType dataType, Object value) {
        if (value instanceof Collection) {
            return new CollectionValue(dataType, OpType.CONTINUOUS, (Collection)value);
        }
        switch (dataType) {
            case INTEGER: {
                return new ContinuousInteger(value);
            }
            case FLOAT: {
                return new ContinuousFloat(value);
            }
            case DOUBLE: {
                return new ContinuousDouble(value);
            }
        }
        return new ContinuousValue(dataType, value);
    }

    private static class ContinuousDouble
    extends ContinuousValue {
        ContinuousDouble(Object value) {
            super(DataType.DOUBLE, value);
            Double doubleValue = (Double)this.getValue();
            if (doubleValue.isNaN()) {
                this.setValid(false);
            }
        }

        @Override
        public int compareToValue(Object value) {
            if (value instanceof Double) {
                return this.asDouble().compareTo((Double)value);
            }
            return super.compareToValue(value);
        }

        @Override
        public boolean equalsValue(Object value) {
            if (value instanceof Double) {
                return this.asDouble().equals(value);
            }
            return super.equalsValue(value);
        }

        @Override
        public Number asNumber() {
            return (Number)this.getValue();
        }

        @Override
        public Double asDouble() {
            return (Double)this.getValue();
        }
    }

    private static class ContinuousFloat
    extends ContinuousValue {
        ContinuousFloat(Object value) {
            super(DataType.FLOAT, value);
            Float floatValue = (Float)this.getValue();
            if (floatValue.isNaN()) {
                this.setValid(false);
            }
        }

        @Override
        public int compareToValue(Object value) {
            if (value instanceof Float) {
                return this.asFloat().compareTo((Float)value);
            }
            return super.compareToValue(value);
        }

        @Override
        public boolean equalsValue(Object value) {
            if (value instanceof Float) {
                return this.asFloat().equals(value);
            }
            return super.equalsValue(value);
        }

        @Override
        public Number asNumber() {
            return (Number)this.getValue();
        }

        @Override
        public Float asFloat() {
            return (Float)this.getValue();
        }
    }

    private static class ContinuousInteger
    extends ContinuousValue {
        ContinuousInteger(Object value) {
            super(DataType.INTEGER, value);
        }

        @Override
        public int compareToValue(Object value) {
            if (value instanceof Integer) {
                return this.asInteger().compareTo((Integer)value);
            }
            return super.compareToValue(value);
        }

        @Override
        public boolean equalsValue(Object value) {
            if (value instanceof Integer) {
                return this.asInteger().equals(value);
            }
            return super.equalsValue(value);
        }

        @Override
        public Number asNumber() {
            return (Number)this.getValue();
        }

        @Override
        public Integer asInteger() {
            return (Integer)this.getValue();
        }
    }
}

