/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.dmg.pmml.Entity;
import org.jpmml.evaluator.HasEntityRegistry;
import org.jpmml.evaluator.TypeUtil;

public class EntityUtil {
    private EntityUtil() {
    }

    public static <E extends Entity<?>> String getId(E entity, HasEntityRegistry<E> hasEntityRegistry) {
        BiMap<String, E> entityRegistry = hasEntityRegistry.getEntityRegistry();
        return EntityUtil.getId(entity, entityRegistry);
    }

    public static <E extends Entity<?>> String getId(E entity, BiMap<String, E> entityRegistry) {
        Object id = entity.getId();
        if (id == null) {
            BiMap inversedEntityRegistry = entityRegistry.inverse();
            return (String)inversedEntityRegistry.get(entity);
        }
        return TypeUtil.format(id);
    }

    public static <E extends Entity<?>> ImmutableBiMap<String, E> buildBiMap(List<E> entities) {
        ImmutableBiMap.Builder<String, E> builder = new ImmutableBiMap.Builder<String, E>();
        builder = EntityUtil.putAll(entities, new AtomicInteger(1), builder);
        return builder.build();
    }

    public static <E extends Entity<?>> ImmutableBiMap.Builder<String, E> put(E entity, AtomicInteger index, ImmutableBiMap.Builder<String, E> builder) {
        String implicitId = String.valueOf(index.getAndIncrement());
        Object id = entity.getId();
        if (id == null) {
            id = implicitId;
        }
        return builder.put((Object)TypeUtil.format(id), entity);
    }

    public static <E extends Entity<?>> ImmutableBiMap.Builder<String, E> putAll(List<E> entities, AtomicInteger index, ImmutableBiMap.Builder<String, E> builder) {
        for (Entity entity : entities) {
            builder = EntityUtil.put(entity, index, builder);
        }
        return builder;
    }
}

