/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.Vector;

public class KeyValueAggregator<K, V extends Number> {
    private ValueFactory<V> valueFactory = null;
    private int capacity = 0;
    private Map<K, Vector<V>> map = new LinkedHashMap<K, Vector<V>>();

    protected KeyValueAggregator(ValueFactory<V> valueFactory, int capacity) {
        this.valueFactory = valueFactory;
        this.capacity = capacity;
    }

    public void init(Collection<K> keys) {
        if (!this.map.isEmpty()) {
            throw new IllegalStateException();
        }
        for (K key : keys) {
            this.ensureVector(key);
        }
    }

    public void add(K key, Number value) {
        Vector<V> values = this.ensureVector(key);
        values.add(value);
    }

    public void add(K key, Number coefficient, Number factor) {
        Vector<V> values = this.ensureVector(key);
        if (coefficient.doubleValue() != 1.0) {
            values.add(coefficient, factor);
        } else {
            values.add(factor);
        }
    }

    protected Vector<V> get(K key) {
        return this.map.get(key);
    }

    public void clear() {
        this.map.clear();
    }

    protected Set<K> keySet() {
        return this.map.keySet();
    }

    protected Collection<Vector<V>> values() {
        return this.map.values();
    }

    protected Set<Map.Entry<K, Vector<V>>> entrySet() {
        return this.map.entrySet();
    }

    protected Map<K, Value<V>> asTransformedMap(Function<Vector<V>, Value<V>> function) {
        return Maps.transformValues(this.map, function);
    }

    public ValueFactory<V> getValueFactory() {
        return this.valueFactory;
    }

    private Vector<V> ensureVector(K key) {
        Vector<V> values = this.map.get(key);
        if (values == null) {
            values = this.valueFactory.newVector(this.capacity);
            this.map.put(key, values);
        }
        return values;
    }
}

