/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlTransient;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.ValueStatusHolder;
import org.jpmml.model.ReflectionUtil;

public class RichDataField
extends DataField
implements ValueStatusHolder {
    @XmlTransient
    private Map<?, Integer> valueMap = null;
    @XmlTransient
    private boolean hasValidValues = false;

    public RichDataField() {
    }

    public RichDataField(DataField dataField) {
        ReflectionUtil.copyState((PMMLObject)dataField, (PMMLObject)this);
    }

    @Override
    public DataType getDataType() {
        DataType dataType = super.getDataType();
        if (dataType == null) {
            throw new MissingAttributeException((PMMLObject)this, PMMLAttributes.DATAFIELD_DATATYPE);
        }
        return dataType;
    }

    @Override
    public Map<?, Integer> getMap() {
        if (this.valueMap == null) {
            this.valueMap = ImmutableMap.copyOf(this.parseValues());
        }
        return this.valueMap;
    }

    @Override
    public boolean hasValidValues() {
        return this.hasValidValues;
    }

    private Map<Object, Integer> parseValues() {
        DataType dataType = this.getDataType();
        LinkedHashMap<Object, Integer> result = new LinkedHashMap<Object, Integer>();
        int validIndex = 0;
        List pmmlValues = this.getValues();
        block9: for (Value pmmlValue : pmmlValues) {
            Object objectValue = pmmlValue.getValue();
            if (objectValue == null) {
                throw new MissingAttributeException((PMMLObject)pmmlValue, PMMLAttributes.VALUE_VALUE);
            }
            Value.Property property = pmmlValue.getProperty();
            switch (property) {
                case VALID: {
                    Object value = TypeUtil.parseOrCast(dataType, objectValue);
                    result.put(value, ++validIndex);
                    continue block9;
                }
                case INVALID: {
                    Object value;
                    try {
                        value = TypeUtil.parseOrCast(dataType, objectValue);
                    }
                    catch (IllegalArgumentException | TypeCheckException e) {
                        continue block9;
                    }
                    result.put(value, FieldValue.STATUS_UNKNOWN_INVALID);
                    continue block9;
                }
                case MISSING: {
                    Object value;
                    try {
                        value = TypeUtil.parseOrCast(dataType, objectValue);
                    }
                    catch (IllegalArgumentException | TypeCheckException e) {
                        continue block9;
                    }
                    result.put(value, FieldValue.STATUS_MISSING);
                    continue block9;
                }
            }
            throw new UnsupportedAttributeException((PMMLObject)pmmlValue, (Enum<?>)property);
        }
        this.hasValidValues = validIndex > 0;
        return result;
    }
}

