/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import org.dmg.pmml.DataType;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.tree.DecisionTree;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.PMMLAttributes;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.model.visitors.AbstractVisitor;
import org.jpmml.model.visitors.Resettable;

public class NodeScoreParser
extends AbstractVisitor
implements Resettable {
    private MathContext mathContext = null;

    public void reset() {
        this.mathContext = null;
    }

    public void pushParent(PMMLObject parent) {
        super.pushParent(parent);
        if (parent instanceof TreeModel) {
            TreeModel treeModel = (TreeModel)parent;
            this.mathContext = treeModel.getMathContext();
        }
    }

    public PMMLObject popParent() {
        PMMLObject parent = super.popParent();
        if (parent instanceof TreeModel) {
            this.mathContext = null;
        }
        return parent;
    }

    public VisitorAction visit(DecisionTree decisionTree) {
        throw new UnsupportedOperationException();
    }

    public VisitorAction visit(TreeModel treeModel) {
        MiningFunction miningFunction = treeModel.getMiningFunction();
        if (miningFunction == null) {
            throw new MissingAttributeException((PMMLObject)treeModel, PMMLAttributes.TREEMODEL_MININGFUNCTION);
        }
        switch (miningFunction) {
            case REGRESSION: {
                break;
            }
            default: {
                return VisitorAction.SKIP;
            }
        }
        return super.visit(treeModel);
    }

    public VisitorAction visit(Node node) {
        Object score;
        if (node.hasScore() && (score = node.getScore()) instanceof String) {
            score = this.parseScore(score);
            node.setScore(score);
        }
        return super.visit(node);
    }

    private Object parseScore(Object score) {
        if (score == null) {
            return score;
        }
        try {
            switch (this.mathContext) {
                case DOUBLE: {
                    return TypeUtil.parseOrCast(DataType.DOUBLE, score);
                }
                case FLOAT: {
                    return TypeUtil.parseOrCast(DataType.FLOAT, score);
                }
            }
        }
        catch (IllegalArgumentException | TypeCheckException runtimeException) {
            // empty catch block
        }
        return score;
    }
}

