/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TransformationDictionary;
import org.jpmml.evaluator.DuplicateFieldException;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.model.visitors.FieldResolver;

abstract class AbstractParser
extends FieldResolver {
    private Map<FieldName, DataType> dataTypes = new HashMap<FieldName, DataType>();

    AbstractParser() {
    }

    public void reset() {
        super.reset();
        this.dataTypes.clear();
    }

    public PMMLObject popParent() {
        PMMLObject parent = super.popParent();
        if (parent instanceof Model) {
            this.dataTypes.clear();
        } else if (parent instanceof TransformationDictionary) {
            this.dataTypes.clear();
        } else if (parent instanceof LocalTransformations) {
            this.dataTypes.clear();
        }
        return parent;
    }

    protected DataType resolveDataType(FieldName name) {
        DataType dataType = this.dataTypes.get(name);
        if (dataType == null && !this.dataTypes.containsKey(name)) {
            Collection fields = this.getFields();
            for (Field field : fields) {
                if (!name.equals((Object)field.getName())) continue;
                if (dataType == null || dataType.equals((Object)field.getDataType())) {
                    dataType = field.getDataType();
                    continue;
                }
                dataType = null;
                break;
            }
            this.dataTypes.put(name, dataType);
        }
        return dataType;
    }

    protected DataType resolveTargetDataType(FieldName name) {
        DataType dataType = this.dataTypes.get(name);
        if (dataType == null && !this.dataTypes.containsKey(name)) {
            Collection fields = this.getFields();
            for (Field field : fields) {
                if (!name.equals((Object)field.getName())) continue;
                if (dataType != null) {
                    throw new DuplicateFieldException(name);
                }
                dataType = field.getDataType();
            }
            if (dataType == null) {
                throw new MissingFieldException(name);
            }
            this.dataTypes.put(name, dataType);
        }
        return dataType;
    }
}

