/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.HashSet;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.SymbolTable;

public class FieldNameSet
extends HashSet<String>
implements SymbolTable<String> {
    private int capacity = Integer.MAX_VALUE;

    public FieldNameSet() {
    }

    public FieldNameSet(int capacity) {
        super(2 * capacity);
        this.setCapacity(capacity);
    }

    public FieldNameSet(FieldNameSet parent) {
        super(parent);
        this.setCapacity(parent.getCapacity());
    }

    public FieldNameSet fork() {
        return new FieldNameSet(this);
    }

    @Override
    public void lock(String name) {
        int capacity = this.getCapacity();
        int size = this.size();
        if (size >= capacity) {
            throw new EvaluationException("Field reference chain is too long");
        }
        boolean unique = this.add(name);
        if (!unique) {
            throw new EvaluationException("Field " + PMMLException.formatKey(name) + " references itself");
        }
    }

    @Override
    public void release(String name) {
        this.remove(name);
    }

    public int getCapacity() {
        return this.capacity;
    }

    private void setCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
    }
}

