/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import jakarta.xml.bind.JAXBElement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.dmg.pmml.Cell;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasTable;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.NamespaceURIs;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Row;
import org.dmg.pmml.TableLocator;
import org.jpmml.evaluator.CacheUtil;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.MisplacedElementException;
import org.jpmml.evaluator.UnsupportedElementException;
import org.w3c.dom.Element;

public class InlineTableUtil {
    private static final LoadingCache<InlineTable, Table<Integer, String, Object>> contentCache = CacheUtil.buildLoadingCache(new CacheLoader<InlineTable, Table<Integer, String, Object>>(){

        public Table<Integer, String, Object> load(InlineTable inlineTable) {
            return Tables.unmodifiableTable(InlineTableUtil.parse(inlineTable));
        }
    });

    private InlineTableUtil() {
    }

    public static <E extends PMMLObject> InlineTable getInlineTable(E object) {
        InlineTable inlineTable = ((HasTable)object).getInlineTable();
        TableLocator tableLocator = ((HasTable)object).getTableLocator();
        if (tableLocator != null) {
            throw new UnsupportedElementException((PMMLObject)tableLocator);
        }
        return inlineTable;
    }

    public static Table<Integer, String, Object> getContent(InlineTable inlineTable) {
        return CacheUtil.getValue(inlineTable, contentCache);
    }

    static Table<Integer, String, Object> parse(InlineTable inlineTable) {
        HashBasedTable result = HashBasedTable.create();
        Integer rowKey = 1;
        List rows = inlineTable.getRows();
        for (Row row : rows) {
            List cells = row.getContent();
            for (Object cell : cells) {
                Object value;
                String column;
                if (cell instanceof Cell) {
                    Cell pmmlCell = (Cell)cell;
                    column = InlineTableUtil.parseColumn(pmmlCell.getName());
                    value = pmmlCell.getValue();
                } else {
                    if (cell instanceof Extension) continue;
                    if (cell instanceof PMMLObject) {
                        PMMLObject object = (PMMLObject)cell;
                        throw new MisplacedElementException(object);
                    }
                    if (cell instanceof JAXBElement) {
                        JAXBElement jaxbElement = (JAXBElement)cell;
                        column = InlineTableUtil.parseColumn(jaxbElement.getName());
                        value = jaxbElement.getValue();
                    } else if (cell instanceof Element) {
                        Element domElement = (Element)cell;
                        column = domElement.getTagName();
                        value = domElement.getTextContent();
                    } else {
                        if (cell instanceof String) {
                            String string = (String)cell;
                            if ("".equals(string.trim())) continue;
                            throw new InvalidElementException((PMMLObject)row);
                        }
                        throw new InvalidElementException((PMMLObject)row);
                    }
                }
                result.put((Object)rowKey, (Object)column, value);
            }
            rowKey = rowKey + 1;
        }
        return result;
    }

    public static String parseColumn(QName xmlName) {
        String prefix = xmlName.getPrefix();
        String localPart = xmlName.getLocalPart();
        if (prefix != null && !"".equals(prefix)) {
            return prefix + ":" + localPart;
        }
        return localPart;
    }

    static InlineTable format(Table<Integer, String, String> table) {
        InlineTable result = new InlineTable();
        Map tableRows = table.rowMap();
        int minRow = (Integer)Collections.min(tableRows.keySet());
        int maxRow = (Integer)Collections.max(tableRows.keySet());
        if (minRow != 1 || maxRow != tableRows.size()) {
            throw new IllegalArgumentException();
        }
        for (int i = minRow; i <= maxRow; ++i) {
            Map tableRow = (Map)tableRows.get(i);
            Row row = new Row();
            Set columns = tableRow.keySet();
            for (String column : columns) {
                String value = (String)tableRow.get(column);
                if (value == null) continue;
                QName xmlName = column.startsWith("data:") ? new QName("http://jpmml.org/jpmml-model/InlineTable", column.substring("data:".length()), "data") : new QName(NamespaceURIs.PMML_LATEST, column);
                JAXBElement cell = new JAXBElement(xmlName, String.class, (Object)value);
                row.addContent(new Object[]{cell});
            }
            result.addRows(new Row[]{row});
        }
        return result;
    }
}

