/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Field;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLElements;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.VerificationField;
import org.dmg.pmml.VerificationFields;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.ConfidenceDistribution;
import org.jpmml.evaluator.Configuration;
import org.jpmml.evaluator.EvaluationContext;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.HasGroupFields;
import org.jpmml.evaluator.InlineTableUtil;
import org.jpmml.evaluator.InputField;
import org.jpmml.evaluator.InputFieldUtil;
import org.jpmml.evaluator.InputMapper;
import org.jpmml.evaluator.InvalidAttributeException;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.ModelEvaluationContext;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.ModelField;
import org.jpmml.evaluator.ModelManager;
import org.jpmml.evaluator.OutputField;
import org.jpmml.evaluator.OutputFilter;
import org.jpmml.evaluator.OutputMap;
import org.jpmml.evaluator.OutputUtil;
import org.jpmml.evaluator.PMMLException;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.jpmml.evaluator.ResultMapper;
import org.jpmml.evaluator.SymbolTable;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueFactoryFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.VerificationUtil;
import org.jpmml.evaluator.VoteDistribution;

public abstract class ModelEvaluator<M extends Model>
extends ModelManager<M>
implements Evaluator {
    private Configuration configuration = null;
    private InputMapper inputMapper = null;
    private ResultMapper resultMapper = null;
    private ValueFactory<?> valueFactory = null;
    private Boolean parentCompatible = null;
    private Boolean pure = null;
    private Integer numberOfVisibleFields = null;

    protected ModelEvaluator() {
    }

    protected ModelEvaluator(PMML pmml, M model) {
        super(pmml, model);
        MathContext mathContext = model.getMathContext();
        switch (mathContext) {
            case FLOAT: 
            case DOUBLE: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)model, (Enum<?>)mathContext);
            }
        }
    }

    public void configure(Configuration configuration) {
        this.setConfiguration(Objects.requireNonNull(configuration));
        this.setValueFactory(null);
        this.resetInputFields();
        this.resetResultFields();
    }

    public boolean isParentCompatible() {
        if (this.parentCompatible == null) {
            this.parentCompatible = this.assessParentCompatibility();
        }
        return this.parentCompatible;
    }

    public boolean isPure() {
        if (this.pure == null) {
            this.pure = this.assessPurity();
        }
        return this.pure;
    }

    protected int getNumberOfVisibleFields() {
        if (this.numberOfVisibleFields == null) {
            ListMultimap<String, Field<?>> visibleFields = this.getVisibleFields();
            this.numberOfVisibleFields = visibleFields.size();
        }
        return this.numberOfVisibleFields;
    }

    @Override
    public ModelEvaluator<M> verify() {
        Object model = this.getModel();
        ModelVerification modelVerification = model.getModelVerification();
        if (modelVerification == null) {
            return this;
        }
        VerificationBatch batch = ModelEvaluator.parseModelVerification(modelVerification);
        List<Map<String, Object>> records = batch.getRecords();
        List<InputField> inputFields = this.getInputFields();
        if (this instanceof HasGroupFields) {
            HasGroupFields hasGroupFields = (HasGroupFields)((Object)this);
            records = EvaluatorUtil.groupRows(hasGroupFields, records);
        }
        List<TargetField> targetFields = this.getTargetFields();
        List<OutputField> outputFields = this.getOutputFields();
        Sets.SetView intersection = Sets.intersection(batch.keySet(), new LinkedHashSet(Lists.transform(outputFields, ModelField::getFieldName)));
        boolean disjoint = intersection.isEmpty();
        for (Map<String, Object> record : records) {
            VerificationField verificationField;
            String name;
            LinkedHashMap<String, FieldValue> arguments = new LinkedHashMap<String, FieldValue>();
            for (InputField inputField : inputFields) {
                String name2 = inputField.getFieldName();
                FieldValue value = inputField.prepare(record.get(name2));
                arguments.put(name2, value);
            }
            ModelEvaluationContext context = this.createEvaluationContext();
            context.setArguments(arguments);
            Map<String, ?> results = this.evaluateInternal(context);
            if (!disjoint) {
                for (OutputField outputField : outputFields) {
                    name = outputField.getFieldName();
                    verificationField = (VerificationField)batch.get(name);
                    if (verificationField == null) continue;
                    this.verify(record.get(name), results.get(name), verificationField.getPrecision(), verificationField.getZeroThreshold());
                }
                continue;
            }
            for (TargetField targetField : targetFields) {
                name = targetField.getFieldName();
                verificationField = (VerificationField)batch.get(name);
                if (verificationField == null) continue;
                Number precision = verificationField.getPrecision();
                Number zeroThreshold = verificationField.getZeroThreshold();
                this.verify(record.get(name), EvaluatorUtil.decode(results.get(name)), precision, zeroThreshold);
            }
        }
        return this;
    }

    private void verify(Object expected, Object actual, Number precision, Number zeroThreshold) {
        if (expected == null) {
            return;
        }
        if (!(actual instanceof Collection)) {
            DataType dataType = TypeUtil.getDataType(actual);
            expected = TypeUtil.parseOrCast(dataType, expected);
        }
        boolean acceptable = VerificationUtil.acceptable(expected, actual, precision.doubleValue(), zeroThreshold.doubleValue());
        if (!acceptable) {
            throw new EvaluationException("Values " + PMMLException.formatValue(expected) + " and " + PMMLException.formatValue(actual) + " do not match");
        }
    }

    public ModelEvaluationContext createEvaluationContext() {
        return new ModelEvaluationContext(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ?> evaluate(Map<String, ?> arguments) {
        Map<String, ?> results;
        Configuration configuration = this.ensureConfiguration();
        SymbolTable<String> prevDerivedFieldGuard = null;
        SymbolTable<String> derivedFieldGuard = configuration.getDerivedFieldGuard();
        SymbolTable<String> prevFunctionGuard = null;
        SymbolTable<String> functionGuard = configuration.getFunctionGuard();
        arguments = this.processArguments(arguments);
        ModelEvaluationContext context = this.createEvaluationContext();
        context.setArguments(arguments);
        try {
            if (derivedFieldGuard != null) {
                prevDerivedFieldGuard = EvaluationContext.DERIVEDFIELD_GUARD_PROVIDER.get();
                EvaluationContext.DERIVEDFIELD_GUARD_PROVIDER.set(derivedFieldGuard.fork());
            }
            if (functionGuard != null) {
                prevFunctionGuard = EvaluationContext.FUNCTION_GUARD_PROVIDER.get();
                EvaluationContext.FUNCTION_GUARD_PROVIDER.set(functionGuard.fork());
            }
            results = this.evaluateInternal(context);
        }
        finally {
            if (derivedFieldGuard != null) {
                EvaluationContext.DERIVEDFIELD_GUARD_PROVIDER.set(prevDerivedFieldGuard);
            }
            if (functionGuard != null) {
                EvaluationContext.FUNCTION_GUARD_PROVIDER.set(prevFunctionGuard);
            }
        }
        results = this.processResults(results);
        return results;
    }

    protected Map<String, ?> processArguments(final Map<String, ?> arguments) {
        final InputMapper inputMapper = this.getInputMapper();
        if (inputMapper != null) {
            AbstractMap<String, Object> remappedArguments = new AbstractMap<String, Object>(){

                @Override
                public Object get(Object key) {
                    return arguments.get(inputMapper.apply((String)key));
                }

                @Override
                public Set<Map.Entry<String, Object>> entrySet() {
                    throw new UnsupportedOperationException();
                }
            };
            return remappedArguments;
        }
        return arguments;
    }

    protected Map<String, ?> processResults(Map<String, ?> results) {
        ResultMapper resultMapper = this.getResultMapper();
        if (results instanceof OutputMap) {
            OutputMap outputMap = (OutputMap)results;
            outputMap.clearPrivate();
        }
        if (resultMapper != null) {
            if (results.isEmpty()) {
                return results;
            }
            if (results.size() == 1) {
                Map.Entry entry = (Map.Entry)Iterables.getOnlyElement(results.entrySet());
                return Collections.singletonMap(resultMapper.apply(entry.getKey()), entry.getValue());
            }
            LinkedHashMap remappedResults = new LinkedHashMap(2 * results.size());
            Set<Map.Entry<String, ?>> entries = results.entrySet();
            for (Map.Entry entry : entries) {
                remappedResults.put(resultMapper.apply(entry.getKey()), entry.getValue());
            }
            return remappedResults;
        }
        return results;
    }

    @Override
    protected List<InputField> filterInputFields(List<InputField> inputFields) {
        InputMapper inputMapper = this.getInputMapper();
        if (inputMapper != null) {
            inputFields = ModelEvaluator.updateNames(inputFields, inputMapper);
        }
        return inputFields;
    }

    @Override
    protected List<TargetField> filterTargetFields(List<TargetField> targetFields) {
        ResultMapper resultMapper = this.getResultMapper();
        if (resultMapper != null) {
            targetFields = ModelEvaluator.updateNames(targetFields, resultMapper);
        }
        return targetFields;
    }

    @Override
    protected List<OutputField> filterOutputFields(List<OutputField> outputFields) {
        ResultMapper resultMapper = this.getResultMapper();
        if (!outputFields.isEmpty()) {
            OutputFilter outputFilter = this.ensureOutputFilter();
            Iterator<OutputField> it = outputFields.iterator();
            while (it.hasNext()) {
                OutputField outputField = it.next();
                org.dmg.pmml.OutputField pmmlOutputField = outputField.getField();
                if (outputFilter.test(pmmlOutputField)) continue;
                it.remove();
            }
        }
        if (resultMapper != null) {
            outputFields = ModelEvaluator.updateNames(outputFields, resultMapper);
        }
        return outputFields;
    }

    public Map<String, ?> evaluateInternal(ModelEvaluationContext context) {
        Map<String, ?> predictions;
        ValueFactory<?> valueFactory;
        Object model = this.getModel();
        if (!model.isScorable()) {
            throw new EvaluationException("Model is not scorable", (PMMLObject)model);
        }
        MathContext mathContext = model.getMathContext();
        switch (mathContext) {
            case FLOAT: 
            case DOUBLE: {
                valueFactory = this.ensureValueFactory();
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)model, (Enum<?>)mathContext);
            }
        }
        MiningFunction miningFunction = model.getMiningFunction();
        switch (miningFunction) {
            case REGRESSION: {
                predictions = this.evaluateRegression(valueFactory, context);
                break;
            }
            case CLASSIFICATION: {
                predictions = this.evaluateClassification(valueFactory, context);
                break;
            }
            case CLUSTERING: {
                predictions = this.evaluateClustering(valueFactory, context);
                break;
            }
            case ASSOCIATION_RULES: {
                predictions = this.evaluateAssociationRules(valueFactory, context);
                break;
            }
            case SEQUENCES: {
                predictions = this.evaluateSequences(valueFactory, context);
                break;
            }
            case TIME_SERIES: {
                predictions = this.evaluateTimeSeries(valueFactory, context);
                break;
            }
            case MIXED: {
                predictions = this.evaluateMixed(valueFactory, context);
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)model, (Enum<?>)miningFunction);
            }
        }
        return OutputUtil.evaluate(predictions, context);
    }

    protected <V extends Number> Map<String, ?> evaluateRegression(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateDefault();
    }

    protected <V extends Number> Map<String, ?> evaluateClassification(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateDefault();
    }

    protected <V extends Number> Map<String, ?> evaluateClustering(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateDefault();
    }

    protected <V extends Number> Map<String, ?> evaluateAssociationRules(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateDefault();
    }

    protected <V extends Number> Map<String, ?> evaluateSequences(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateDefault();
    }

    protected <V extends Number> Map<String, ?> evaluateTimeSeries(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateDefault();
    }

    protected <V extends Number> Map<String, ?> evaluateMixed(ValueFactory<V> valueFactory, EvaluationContext context) {
        return this.evaluateDefault();
    }

    private <V extends Number> Map<String, ?> evaluateDefault() {
        Object model = this.getModel();
        MiningFunction miningFunction = model.getMiningFunction();
        throw new InvalidAttributeException((PMMLObject)model, (Enum<?>)miningFunction);
    }

    protected <V extends Number> Classification<Object, V> createClassification(ValueMap<Object, V> values) {
        Set<ResultFeature> resultFeatures = this.getResultFeatures();
        if (resultFeatures.contains(ResultFeature.PROBABILITY) || resultFeatures.contains(ResultFeature.RESIDUAL)) {
            return new ProbabilityDistribution<V>(values);
        }
        if (resultFeatures.contains(ResultFeature.CONFIDENCE)) {
            return new ConfidenceDistribution<V>(values);
        }
        return new VoteDistribution<V>(values);
    }

    protected boolean assessParentCompatibility() {
        List<InputField> inputFields = this.getInputFields();
        for (InputField inputField : inputFields) {
            Field<?> field = inputField.getField();
            MiningField miningField = inputField.getMiningField();
            if (!(field instanceof DataField) || InputFieldUtil.isDefault(field, miningField)) continue;
            return false;
        }
        return true;
    }

    protected boolean assessPurity() {
        List<InputField> inputFields = this.getInputFields();
        for (InputField inputField : inputFields) {
            MiningField miningField;
            Field<?> field = inputField.getField();
            if (InputFieldUtil.isDefault(field, miningField = inputField.getMiningField())) continue;
            return false;
        }
        return !this.hasLocalDerivedFields() && !this.hasOutputFields();
    }

    protected Configuration ensureConfiguration() {
        Configuration configuration = this.getConfiguration();
        if (this.configuration == null) {
            throw new IllegalStateException();
        }
        return this.configuration;
    }

    protected ModelEvaluatorFactory ensureModelEvaluatorFactory() {
        Configuration configuration = this.ensureConfiguration();
        return configuration.getModelEvaluatorFactory();
    }

    protected ValueFactoryFactory ensureValueFactoryFactory() {
        Configuration configuration = this.ensureConfiguration();
        return configuration.getValueFactoryFactory();
    }

    protected OutputFilter ensureOutputFilter() {
        Configuration configuration = this.ensureConfiguration();
        return configuration.getOutputFilter();
    }

    protected ValueFactory<?> ensureValueFactory() {
        ValueFactory<?> valueFactory = this.getValueFactory();
        if (valueFactory == null) {
            ValueFactoryFactory valueFactoryFactory = this.ensureValueFactoryFactory();
            MathContext mathContext = this.getMathContext();
            valueFactory = valueFactoryFactory.newValueFactory(mathContext);
            this.setValueFactory(valueFactory);
        }
        return valueFactory;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    private void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public InputMapper getInputMapper() {
        return this.inputMapper;
    }

    void setInputMapper(InputMapper inputMapper) {
        this.inputMapper = inputMapper;
        this.resetInputFields();
    }

    public ResultMapper getResultMapper() {
        return this.resultMapper;
    }

    void setResultMapper(ResultMapper resultMapper) {
        this.resultMapper = resultMapper;
        this.resetResultFields();
    }

    private ValueFactory<?> getValueFactory() {
        return this.valueFactory;
    }

    private void setValueFactory(ValueFactory<?> valueFactory) {
        this.valueFactory = valueFactory;
    }

    private static <F extends ModelField> List<F> updateNames(List<F> fields, Function<String, String> mapper) {
        for (ModelField field : fields) {
            String name = field.getFieldName();
            String mappedName = (String)mapper.apply((Object)name);
            if (mappedName == null || Objects.equals(mappedName, name)) continue;
            field.setName(mappedName);
        }
        return fields;
    }

    private static VerificationBatch parseModelVerification(ModelVerification modelVerification) {
        VerificationBatch result = new VerificationBatch();
        VerificationFields verificationFields = modelVerification.getVerificationFields();
        if (verificationFields == null) {
            throw new MissingElementException((PMMLObject)modelVerification, PMMLElements.MODELVERIFICATION_VERIFICATIONFIELDS);
        }
        for (VerificationField verificationField : verificationFields) {
            result.put(verificationField.getField(), verificationField);
        }
        InlineTable inlineTable = modelVerification.getInlineTable();
        if (inlineTable == null) {
            throw new MissingElementException((PMMLObject)modelVerification, PMMLElements.MODELVERIFICATION_INLINETABLE);
        }
        Table<Integer, String, Object> table = InlineTableUtil.getContent(inlineTable);
        ArrayList records = new ArrayList();
        Set rowKeys = table.rowKeySet();
        for (Integer rowKey : rowKeys) {
            Map row = table.row((Object)rowKey);
            LinkedHashMap record = new LinkedHashMap();
            for (VerificationField verificationField : verificationFields) {
                String fieldName = verificationField.getField();
                String column = verificationField.getColumn();
                if (column == null) {
                    column = fieldName;
                }
                if (!row.containsKey(column)) continue;
                record.put(fieldName, row.get(column));
            }
            records.add(record);
        }
        Integer recordCount = modelVerification.getRecordCount();
        if (recordCount != null && recordCount.intValue() != records.size()) {
            throw new InvalidElementException((PMMLObject)modelVerification);
        }
        result.setRecords(records);
        return result;
    }

    private static class VerificationBatch
    extends LinkedHashMap<String, VerificationField> {
        private List<Map<String, Object>> records = null;

        private VerificationBatch() {
        }

        public List<Map<String, Object>> getRecords() {
            return this.records;
        }

        private void setRecords(List<Map<String, Object>> records) {
            this.records = records;
        }
    }
}

