/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.FieldValue;
import org.xml.sax.Locator;

public abstract class PMMLException
extends RuntimeException {
    private PMMLObject context = null;

    public PMMLException(String message) {
        super(message);
    }

    public PMMLException(String message, PMMLObject context) {
        super(message);
        this.setContext(context);
    }

    @Override
    public synchronized PMMLException initCause(Throwable throwable) {
        return (PMMLException)super.initCause(throwable);
    }

    public PMMLException ensureContext(PMMLObject parentContext) {
        PMMLObject context = this.getContext();
        if (context == null) {
            this.setContext(parentContext);
        }
        return this;
    }

    @Override
    public String toString() {
        String message;
        StringBuilder sb = new StringBuilder();
        Class<?> clazz = this.getClass();
        sb.append(clazz.getName());
        PMMLObject context = this.getContext();
        if (context != null) {
            int lineNumber = -1;
            Locator locator = context.getLocator();
            if (locator != null) {
                lineNumber = locator.getLineNumber();
            }
            if (lineNumber != -1) {
                sb.append(" ").append("(at or around line ").append(lineNumber).append(" of the PMML document)");
            }
        }
        if ((message = this.getLocalizedMessage()) != null) {
            sb.append(":");
            sb.append(" ").append(message);
        }
        return sb.toString();
    }

    public PMMLObject getContext() {
        return this.context;
    }

    private void setContext(PMMLObject context) {
        this.context = context;
    }

    public static String formatKey(Object object) {
        return PMMLException.format(object);
    }

    public static String formatValue(Object object) {
        if (object instanceof FieldValue) {
            FieldValue fieldValue = (FieldValue)object;
            object = fieldValue.getValue();
        }
        return PMMLException.format(object);
    }

    public static String format(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            return "\"" + string + "\"";
        }
        return object != null ? String.valueOf(object) : null;
    }
}

