/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dmg.pmml.DataDictionary;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DefineFunction;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLElements;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.TransformationDictionary;
import org.jpmml.evaluator.HasPMML;
import org.jpmml.evaluator.IndexableUtil;
import org.jpmml.evaluator.MissingElementException;

public abstract class PMMLManager
implements HasPMML,
Serializable {
    private PMML pmml = null;
    private Map<String, DataField> dataFields = Collections.emptyMap();
    private Map<String, DerivedField> derivedFields = Collections.emptyMap();
    private Map<String, DefineFunction> defineFunctions = Collections.emptyMap();

    protected PMMLManager() {
    }

    protected PMMLManager(PMML pmml) {
        TransformationDictionary transformationDictionary;
        this.setPMML(Objects.requireNonNull(pmml));
        DataDictionary dataDictionary = pmml.getDataDictionary();
        if (dataDictionary == null) {
            throw new MissingElementException((PMMLObject)pmml, PMMLElements.PMML_DATADICTIONARY);
        }
        if (dataDictionary.hasDataFields()) {
            this.dataFields = ImmutableMap.copyOf(IndexableUtil.buildMap(dataDictionary.getDataFields(), PMMLAttributes.DATAFIELD_NAME));
        }
        if ((transformationDictionary = pmml.getTransformationDictionary()) != null && transformationDictionary.hasDerivedFields()) {
            this.derivedFields = ImmutableMap.copyOf(IndexableUtil.buildMap(transformationDictionary.getDerivedFields(), PMMLAttributes.DERIVEDFIELD_NAME));
        }
        if (transformationDictionary != null && transformationDictionary.hasDefineFunctions()) {
            this.defineFunctions = ImmutableMap.copyOf(IndexableUtil.buildMap(transformationDictionary.getDefineFunctions(), PMMLAttributes.DEFINEFUNCTION_NAME));
        }
    }

    public DataField getDataField(String name) {
        return this.dataFields.get(name);
    }

    public DerivedField getDerivedField(String name) {
        return this.derivedFields.get(name);
    }

    public DefineFunction getDefineFunction(String name) {
        return this.defineFunctions.get(name);
    }

    @Override
    public PMML getPMML() {
        return this.pmml;
    }

    private void setPMML(PMML pmml) {
        this.pmml = pmml;
    }

    protected static <K, V> Map<K, ? extends List<V>> toImmutableListMap(Map<K, List<V>> map) {
        Function function = new Function<List<V>, ImmutableList<V>>(){

            public ImmutableList<V> apply(List<V> list) {
                return ImmutableList.copyOf(list);
            }
        };
        return Maps.transformValues(map, (Function)function);
    }

    protected static <K, V> Map<K, ? extends Set<V>> toImmutableSetMap(Map<K, Set<V>> map) {
        Function function = new Function<Set<V>, ImmutableSet<V>>(){

            public ImmutableSet<V> apply(Set<V> set) {
                if (set instanceof EnumSet) {
                    EnumSet enumSet = (EnumSet)set;
                    return Sets.immutableEnumSet((Iterable)enumSet);
                }
                return ImmutableSet.copyOf(set);
            }
        };
        return Maps.transformValues(map, (Function)function);
    }

    protected static <K1, K2, V2> Map<K1, ? extends Map<K2, V2>> toImmutableMapMap(Map<K1, Map<K2, V2>> map) {
        Function function = new Function<Map<K2, V2>, ImmutableMap<K2, V2>>(){

            public ImmutableMap<K2, V2> apply(Map<K2, V2> map) {
                return ImmutableMap.copyOf(map);
            }
        };
        return Maps.transformValues(map, (Function)function);
    }
}

