/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ImmutableMap;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Value;
import org.jpmml.evaluator.InvalidAttributeException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.ValueStatusHolder;
import org.jpmml.model.ReflectionUtil;

public class RichDerivedField
extends DerivedField
implements ValueStatusHolder {
    @XmlTransient
    private Map<?, Integer> valueMap = null;

    public RichDerivedField() {
    }

    public RichDerivedField(DerivedField derivedField) {
        ReflectionUtil.copyState((PMMLObject)derivedField, (PMMLObject)this);
    }

    @Override
    public DataType getDataType() {
        DataType dataType = super.getDataType();
        if (dataType == null) {
            throw new MissingAttributeException((PMMLObject)this, PMMLAttributes.DERIVEDFIELD_DATATYPE);
        }
        return dataType;
    }

    @Override
    public Map<?, Integer> getMap() {
        if (this.valueMap == null) {
            this.valueMap = ImmutableMap.copyOf(this.parseValues());
        }
        return this.valueMap;
    }

    @Override
    public boolean hasValidValues() {
        return this.hasValues();
    }

    private Map<Object, Integer> parseValues() {
        DataType dataType = this.getDataType();
        LinkedHashMap<Object, Integer> result = new LinkedHashMap<Object, Integer>();
        int validIndex = 0;
        List pmmlValues = this.getValues();
        block4: for (Value pmmlValue : pmmlValues) {
            Object objectValue = pmmlValue.getValue();
            if (objectValue == null) {
                throw new MissingAttributeException((PMMLObject)pmmlValue, PMMLAttributes.VALUE_VALUE);
            }
            Value.Property property = pmmlValue.getProperty();
            switch (property) {
                case VALID: {
                    Object value = TypeUtil.parseOrCast(dataType, objectValue);
                    result.put(value, ++validIndex);
                    continue block4;
                }
                case INVALID: 
                case MISSING: {
                    throw new InvalidAttributeException((PMMLObject)pmmlValue, (Enum<?>)property);
                }
            }
            throw new UnsupportedAttributeException((PMMLObject)pmmlValue, (Enum<?>)property);
        }
        return result;
    }
}

