/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.DataType;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Target;
import org.dmg.pmml.TargetValue;
import org.jpmml.evaluator.Classification;
import org.jpmml.evaluator.HasReport;
import org.jpmml.evaluator.InvalidElementException;
import org.jpmml.evaluator.InvalidElementListException;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.ProbabilityDistribution;
import org.jpmml.evaluator.Regression;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.UndefinedResultException;
import org.jpmml.evaluator.UnsupportedAttributeException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.Vote;

public class TargetUtil {
    private TargetUtil() {
    }

    public static void computeResult(DataType dataType, Regression<?> regression) {
        regression.computeResult(dataType);
    }

    public static void computeResult(DataType dataType, Classification<?, ?> classification) {
        classification.computeResult(dataType);
    }

    public static void computeResult(DataType dataType, Vote vote) {
        vote.computeResult(dataType);
    }

    public static <V extends Number> Map<String, ?> evaluateRegressionDefault(ValueFactory<V> valueFactory, TargetField targetField) {
        Value<V> value;
        Target target = targetField.getTarget();
        if (target != null && target.hasTargetValues() && (value = TargetUtil.getDefaultValue(valueFactory, target)) != null) {
            return TargetUtil.evaluateRegression(targetField, value);
        }
        return Collections.singletonMap(targetField.getFieldName(), null);
    }

    public static <V extends Number> Map<String, ?> evaluateRegression(TargetField targetField, Value<V> value) {
        if ((value = TargetUtil.evaluateRegressionInternal(targetField, value)) instanceof HasReport) {
            Regression<V> result = new Regression<V>(value);
            return TargetUtil.evaluateRegression(targetField, result);
        }
        Object result = TypeUtil.cast(targetField.getDataType(), value.getValue());
        return Collections.singletonMap(targetField.getFieldName(), result);
    }

    public static <V extends Number> Map<String, ? extends Regression<V>> evaluateRegression(TargetField targetField, Regression<V> regression) {
        regression.computeResult(targetField.getDataType());
        return Collections.singletonMap(targetField.getFieldName(), regression);
    }

    public static <V extends Number> Value<V> evaluateRegressionInternal(TargetField targetField, Value<V> value) {
        Target target = targetField.getTarget();
        if (target != null) {
            return TargetUtil.processValue(target, value);
        }
        return value;
    }

    public static Map<String, ? extends Vote> evaluateVote(TargetField targetField, Vote vote) {
        vote.computeResult(targetField.getDataType());
        return Collections.singletonMap(targetField.getFieldName(), vote);
    }

    public static <V extends Number> Map<String, ? extends Classification<?, V>> evaluateClassificationDefault(ValueFactory<V> valueFactory, TargetField targetField) {
        ProbabilityDistribution<V> result;
        Target target = targetField.getTarget();
        if (target != null && target.hasTargetValues() && (result = TargetUtil.getPriorProbabilities(valueFactory, target)) != null) {
            return TargetUtil.evaluateClassification(targetField, result);
        }
        return Collections.singletonMap(targetField.getFieldName(), null);
    }

    public static <V extends Number> Map<String, ? extends Classification<?, V>> evaluateClassification(TargetField targetField, Classification<?, V> classification) {
        classification.computeResult(targetField.getDataType());
        return Collections.singletonMap(targetField.getFieldName(), classification);
    }

    public static <V extends Number> Value<V> processValue(Target target, Value<V> value) {
        Number min = target.getMin();
        Number max = target.getMax();
        if (min != null || max != null) {
            value.restrict(min != null ? (Number)min : (Number)Double.NEGATIVE_INFINITY, max != null ? (Number)max : (Number)Double.POSITIVE_INFINITY);
        }
        value.multiply(target.getRescaleFactor()).add(target.getRescaleConstant());
        Target.CastInteger castInteger = target.getCastInteger();
        if (castInteger == null) {
            return value;
        }
        switch (castInteger) {
            case ROUND: {
                return value.round();
            }
            case CEILING: {
                return value.ceiling();
            }
            case FLOOR: {
                return value.floor();
            }
        }
        throw new UnsupportedAttributeException((PMMLObject)target, (Enum<?>)castInteger);
    }

    public static TargetValue getTargetValue(Target target, Object value) {
        DataType dataType = TypeUtil.getDataType(value);
        List targetValues = target.getTargetValues();
        for (TargetValue targetValue : targetValues) {
            Object simpleValue = targetValue.getValue();
            if (simpleValue == null) {
                throw new MissingAttributeException((PMMLObject)targetValue, PMMLAttributes.TARGETVALUE_VALUE);
            }
            if (!value.equals(TypeUtil.parseOrCast(dataType, simpleValue))) continue;
            return targetValue;
        }
        return null;
    }

    private static <V extends Number> Value<V> getDefaultValue(ValueFactory<V> valueFactory, Target target) {
        if (!target.hasTargetValues()) {
            return null;
        }
        List targetValues = target.getTargetValues();
        if (targetValues.size() != 1) {
            throw new InvalidElementListException(targetValues);
        }
        TargetValue targetValue = (TargetValue)targetValues.get(0);
        Number defaultValue = targetValue.getDefaultValue();
        if (targetValue.getValue() != null || targetValue.getPriorProbability() != null) {
            throw new InvalidElementException((PMMLObject)targetValue);
        }
        if (defaultValue == null) {
            return null;
        }
        return valueFactory.newValue(defaultValue);
    }

    private static <V extends Number> ProbabilityDistribution<V> getPriorProbabilities(ValueFactory<V> valueFactory, Target target) {
        if (!target.hasTargetValues()) {
            return null;
        }
        ValueMap<Object, Value<V>> values = new ValueMap<Object, Value<V>>();
        Value<V> sum = valueFactory.newValue();
        List targetValues = target.getTargetValues();
        for (TargetValue targetValue : targetValues) {
            Object targetCategory = targetValue.getValue();
            if (targetCategory == null) {
                throw new MissingAttributeException((PMMLObject)targetValue, PMMLAttributes.TARGETVALUE_VALUE);
            }
            Number probability = targetValue.getPriorProbability();
            if (probability == null) {
                throw new MissingAttributeException((PMMLObject)targetValue, PMMLAttributes.TARGETVALUE_PRIORPROBABILITY);
            }
            if (targetValue.getDefaultValue() != null) {
                throw new InvalidElementException((PMMLObject)targetValue);
            }
            Value<V> value = valueFactory.newValue(probability);
            values.put(targetCategory, value);
            sum.add(value);
        }
        if (!sum.isOne()) {
            if (sum.isZero()) {
                throw new UndefinedResultException();
            }
            for (Value value : values) {
                value.divide(sum);
            }
        }
        return new ProbabilityDistribution(values);
    }
}

