/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.functions;

import java.util.List;
import org.apache.commons.math3.stat.descriptive.StorelessUnivariateStatistic;
import org.dmg.pmml.DataType;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.FieldValues;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.functions.AggregateFunction;

public abstract class AggregateMathFunction
extends AggregateFunction {
    public AggregateMathFunction(String name) {
        super(name);
    }

    public abstract StorelessUnivariateStatistic createStatistic();

    @Override
    public FieldValue evaluate(List<FieldValue> arguments) {
        StorelessUnivariateStatistic statistic = this.createStatistic();
        DataType dataType = null;
        for (int i = 0; i < arguments.size(); ++i) {
            FieldValue value = this.getOptionalArgument(arguments, i);
            if (FieldValueUtil.isMissing(value)) continue;
            statistic.increment(value.asNumber().doubleValue());
            dataType = dataType != null ? TypeUtil.getCommonDataType(dataType, value.getDataType()) : value.getDataType();
        }
        if (statistic.getN() == 0L) {
            return FieldValues.MISSING_VALUE;
        }
        Double result = statistic.getResult();
        return FieldValueUtil.create(OpType.CONTINUOUS, this.getResultDataType(dataType), result);
    }

    protected DataType getResultDataType(DataType dataType) {
        return dataType;
    }
}

