/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator.visitors;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dmg.pmml.Array;
import org.dmg.pmml.Cell;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldColumnPair;
import org.dmg.pmml.HasDataType;
import org.dmg.pmml.HasDefaultValue;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.HasMapMissingTo;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.InlineTable;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLElements;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Row;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.dmg.pmml.Value;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.baseline.FieldValue;
import org.dmg.pmml.baseline.FieldValueCount;
import org.dmg.pmml.general_regression.BaselineStratum;
import org.dmg.pmml.general_regression.Category;
import org.dmg.pmml.general_regression.PPCell;
import org.dmg.pmml.naive_bayes.PairCounts;
import org.dmg.pmml.regression.CategoricalPredictor;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.ExpressionUtil;
import org.jpmml.evaluator.InlineTableUtil;
import org.jpmml.evaluator.MissingAttributeException;
import org.jpmml.evaluator.MissingElementException;
import org.jpmml.evaluator.RichComplexArray;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.evaluator.visitors.AbstractParser;
import org.jpmml.model.XPathUtil;

public class ValueParser
extends AbstractParser {
    private Mode mode = null;
    public static final ThreadLocal<Mode> MODE_PROVIDER = new ThreadLocal<Mode>(){

        @Override
        public Mode initialValue() {
            return Mode.LOOSE;
        }
    };

    public ValueParser() {
        this(MODE_PROVIDER.get());
    }

    public ValueParser(Mode mode) {
        this.setMode(mode);
    }

    public VisitorAction visit(BaselineStratum baselineStartum) {
        return super.visit(baselineStartum);
    }

    public VisitorAction visit(CategoricalPredictor categoricalPredictor) {
        this.parseValue(categoricalPredictor);
        return super.visit(categoricalPredictor);
    }

    public VisitorAction visit(Category category) {
        return super.visit(category);
    }

    public VisitorAction visit(Constant constant) {
        Object value;
        boolean missing = constant.isMissing();
        if (!missing && !ExpressionUtil.isEmptyContent(value = constant.getValue())) {
            DataType dataType = constant.getDataType();
            if (dataType == null) {
                dataType = TypeUtil.getConstantDataType(value);
            }
            value = this.parseOrCast(dataType, value);
            constant.setValue(value);
        }
        return super.visit(constant);
    }

    public VisitorAction visit(Discretize discretize) {
        this.parseExpressionValues(discretize);
        return super.visit(discretize);
    }

    public VisitorAction visit(DiscretizeBin discretizeBin) {
        Object binValue;
        Discretize discretize = (Discretize)this.getParent();
        DataType dataType = discretize.getDataType();
        if (dataType != null && (binValue = discretizeBin.getBinValue()) != null) {
            binValue = this.parseOrCast(dataType, binValue);
            discretizeBin.setBinValue(binValue);
        }
        return super.visit(discretizeBin);
    }

    public VisitorAction visit(FieldValue fieldValue) {
        return super.visit(fieldValue);
    }

    public VisitorAction visit(FieldValueCount fieldValueCount) {
        return super.visit(fieldValueCount);
    }

    public VisitorAction visit(MapValues mapValues) {
        this.parseExpressionValues(mapValues);
        HashMap<String, DataType> dataTypes = new HashMap<String, DataType>();
        String outputColumn = mapValues.getOutputColumn();
        if (outputColumn == null) {
            throw new MissingAttributeException((PMMLObject)mapValues, PMMLAttributes.MAPVALUES_OUTPUTCOLUMN);
        }
        DataType outputDataType = mapValues.getDataType();
        if (outputDataType != null) {
            dataTypes.put(outputColumn, outputDataType);
        }
        if (mapValues.hasFieldColumnPairs()) {
            List fieldColumnPairs = mapValues.getFieldColumnPairs();
            for (FieldColumnPair fieldColumnPair : fieldColumnPairs) {
                String fieldName = fieldColumnPair.getField();
                if (fieldName == null) {
                    throw new MissingAttributeException((PMMLObject)fieldColumnPair, PMMLAttributes.FIELDCOLUMNPAIR_FIELD);
                }
                String column = fieldColumnPair.getColumn();
                if (column == null) {
                    throw new MissingAttributeException((PMMLObject)fieldColumnPair, PMMLAttributes.FIELDCOLUMNPAIR_COLUMN);
                }
                DataType dataType = this.resolveDataType(fieldName);
                dataTypes.put(column, dataType);
            }
        }
        this.parseCellValues(mapValues, dataTypes);
        return super.visit(mapValues);
    }

    public VisitorAction visit(MiningField miningField) {
        String fieldName = miningField.getName();
        if (fieldName == null) {
            throw new MissingAttributeException((PMMLObject)miningField, PMMLAttributes.MININGFIELD_NAME);
        }
        DataType dataType = this.resolveDataType(fieldName);
        if (dataType != null) {
            Object invalidValueReplacement;
            Object missingValueReplacement = miningField.getMissingValueReplacement();
            if (missingValueReplacement != null) {
                missingValueReplacement = this.safeParseOrCast(dataType, missingValueReplacement);
                miningField.setMissingValueReplacement(missingValueReplacement);
            }
            if ((invalidValueReplacement = miningField.getInvalidValueReplacement()) != null) {
                invalidValueReplacement = this.safeParseOrCast(dataType, invalidValueReplacement);
                miningField.setInvalidValueReplacement(invalidValueReplacement);
            }
        }
        return super.visit(miningField);
    }

    public VisitorAction visit(NormDiscrete normDiscrete) {
        this.parseValue(normDiscrete);
        return super.visit(normDiscrete);
    }

    public VisitorAction visit(PairCounts pairCounts) {
        return super.visit(pairCounts);
    }

    public VisitorAction visit(PPCell ppCell) {
        this.parseValue(ppCell);
        return super.visit(ppCell);
    }

    public VisitorAction visit(SimplePredicate simplePredicate) {
        if (simplePredicate.hasValue()) {
            this.parseValue(simplePredicate);
        }
        return super.visit(simplePredicate);
    }

    public VisitorAction visit(SimpleSetPredicate simpleSetPredicate) {
        String fieldName = simpleSetPredicate.getField();
        if (fieldName == null) {
            throw new MissingAttributeException((PMMLObject)simpleSetPredicate, PMMLAttributes.SIMPLESETPREDICATE_FIELD);
        }
        Array array = simpleSetPredicate.getArray();
        if (array == null) {
            throw new MissingElementException((PMMLObject)simpleSetPredicate, PMMLElements.SIMPLESETPREDICATE_ARRAY);
        }
        DataType dataType = this.resolveDataType(fieldName);
        if (dataType != null) {
            Object value = array.getValue();
            Set<Object> values = value instanceof List ? new LinkedHashSet((List)value) : (value instanceof Set ? (Set)value : new LinkedHashSet(ArrayUtil.parse(array)));
            try {
                array = new RichComplexArray(dataType).setType(array.getType()).setValue(values);
            }
            catch (IllegalArgumentException | TypeCheckException e) {
                Mode mode = this.getMode();
                if (mode == Mode.LOOSE) {
                    return super.visit(simpleSetPredicate);
                }
                throw e;
            }
            simpleSetPredicate.setArray(array);
        }
        return super.visit(simpleSetPredicate);
    }

    public VisitorAction visit(Value value) {
        Field field;
        DataType dataType;
        PMMLObject parent = this.getParent();
        Object simpleValue = value.getValue();
        if (simpleValue == null) {
            throw new MissingAttributeException((PMMLObject)value, PMMLAttributes.VALUE_VALUE);
        }
        if (parent instanceof Field && (dataType = (field = (Field)parent).getDataType()) != null) {
            simpleValue = this.safeParseOrCast(dataType, simpleValue);
            value.setValue(simpleValue);
        }
        return super.visit(value);
    }

    private <E extends PMMLObject & HasValue<E>> void parseValue(E hasValue) {
        String fieldName = ((HasFieldReference)hasValue).getField();
        if (fieldName == null) {
            throw new MissingAttributeException(MissingAttributeException.formatMessage(XPathUtil.formatElement(hasValue.getClass()) + "@field"), hasValue);
        }
        Object value = ((HasValue<E>)hasValue).getValue();
        if (value == null) {
            throw new MissingAttributeException(MissingAttributeException.formatMessage(XPathUtil.formatElement(hasValue.getClass()) + "@value"), hasValue);
        }
        DataType dataType = this.resolveDataType(fieldName);
        if (dataType != null) {
            value = this.parseOrCast(dataType, value);
            ((HasValue<E>)hasValue).setValue(value);
        }
    }

    private <E extends Expression & HasDefaultValue<E, Object>> void parseExpressionValues(E expression) {
        DataType dataType = ((HasDataType)expression).getDataType();
        if (dataType != null) {
            Object mapMissingTo;
            Object defaultValue = ((HasDefaultValue<E, Object>)expression).getDefaultValue();
            if (defaultValue != null) {
                defaultValue = this.parseOrCast(dataType, defaultValue);
                ((HasDefaultValue<E, Object>)expression).setDefaultValue(defaultValue);
            }
            if ((mapMissingTo = ((HasMapMissingTo)expression).getMapMissingTo()) != null) {
                mapMissingTo = this.parseOrCast(dataType, mapMissingTo);
                ((HasMapMissingTo)expression).setMapMissingTo(mapMissingTo);
            }
        }
    }

    private <E extends PMMLObject> void parseCellValues(E hasTable, Map<String, DataType> dataTypes) {
        InlineTable inlineTable = InlineTableUtil.getInlineTable(hasTable);
        if (inlineTable != null && inlineTable.hasRows()) {
            List rows = inlineTable.getRows();
            for (Row row : rows) {
                List cells = row.getContent();
                for (Object cell : cells) {
                    Cell pmmlCell;
                    String column;
                    DataType dataType;
                    if (!(cell instanceof Cell) || (dataType = dataTypes.get(column = InlineTableUtil.parseColumn((pmmlCell = (Cell)cell).getName()))) == null) continue;
                    Object value = pmmlCell.getValue();
                    value = this.parseOrCast(dataType, value);
                    pmmlCell.setValue(value);
                }
            }
        }
    }

    private Object parseOrCast(DataType dataType, Object value) {
        try {
            return TypeUtil.parseOrCast(dataType, value);
        }
        catch (IllegalArgumentException | TypeCheckException e) {
            if (this.mode == Mode.LOOSE) {
                return value;
            }
            throw e;
        }
    }

    private Object safeParseOrCast(DataType dataType, Object value) {
        try {
            return TypeUtil.parseOrCast(dataType, value);
        }
        catch (IllegalArgumentException | TypeCheckException e) {
            return value;
        }
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = Objects.requireNonNull(mode);
    }

    public static enum Mode {
        LOOSE,
        STRICT;

    }
}

