/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import java.util.List;
import org.dmg.pmml.LinearNorm;
import org.dmg.pmml.NormContinuous;
import org.dmg.pmml.OutlierTreatmentMethod;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.DoubleValue;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.NotImplementedException;
import org.jpmml.evaluator.TypeInfos;
import org.jpmml.evaluator.Value;
import org.jpmml.model.InvalidElementListException;
import org.jpmml.model.UnsupportedAttributeException;

public class NormalizationUtil {
    private NormalizationUtil() {
    }

    public static FieldValue normalize(NormContinuous normContinuous, FieldValue value) {
        Number result = NormalizationUtil.normalize(normContinuous, value.asNumber());
        return FieldValueUtil.create(TypeInfos.CONTINUOUS_DOUBLE, result);
    }

    public static Number normalize(NormContinuous normContinuous, Number value) {
        Value doubleValue = new DoubleValue(value);
        if ((doubleValue = NormalizationUtil.normalize(normContinuous, doubleValue)) == null) {
            return null;
        }
        return doubleValue.getValue();
    }

    public static <V extends Number> Value<V> normalize(NormContinuous normContinuous, Value<V> value) {
        LinearNorm end;
        LinearNorm start;
        List<LinearNorm> linearNorms = NormalizationUtil.ensureLinearNorms(normContinuous);
        int index = NormalizationUtil.binarySearch(linearNorms, (Function<LinearNorm, Number>)((Function)LinearNorm::requireOrig), value);
        if (index < 0 || index == linearNorms.size() - 1) {
            OutlierTreatmentMethod outlierTreatmentMethod = normContinuous.getOutliers();
            switch (outlierTreatmentMethod) {
                case AS_IS: {
                    if (index < 0) {
                        start = linearNorms.get(0);
                        end = linearNorms.get(1);
                        break;
                    }
                    start = linearNorms.get(linearNorms.size() - 2);
                    end = linearNorms.get(linearNorms.size() - 1);
                    break;
                }
                case AS_MISSING_VALUES: {
                    return null;
                }
                case AS_EXTREME_VALUES: {
                    if (index < 0) {
                        LinearNorm start2 = linearNorms.get(0);
                        return value.reset(start2.requireNorm());
                    }
                    LinearNorm end2 = linearNorms.get(linearNorms.size() - 1);
                    return value.reset(end2.requireNorm());
                }
                default: {
                    throw new UnsupportedAttributeException((PMMLObject)normContinuous, (Enum)outlierTreatmentMethod);
                }
            }
        } else {
            start = linearNorms.get(index);
            end = linearNorms.get(index + 1);
        }
        return value.normalize(start.requireOrig(), start.requireNorm(), end.requireOrig(), end.requireNorm());
    }

    public static Number denormalize(NormContinuous normContinuous, Number value) {
        Value doubleValue = new DoubleValue(value);
        doubleValue = NormalizationUtil.denormalize(normContinuous, doubleValue);
        return doubleValue.getValue();
    }

    public static <V extends Number> Value<V> denormalize(NormContinuous normContinuous, Value<V> value) {
        List<LinearNorm> linearNorms = NormalizationUtil.ensureLinearNorms(normContinuous);
        int index = NormalizationUtil.binarySearch(linearNorms, (Function<LinearNorm, Number>)((Function)LinearNorm::requireNorm), value);
        if (index < 0 || index == linearNorms.size() - 1) {
            throw new NotImplementedException();
        }
        LinearNorm start = linearNorms.get(index);
        LinearNorm end = linearNorms.get(index + 1);
        return value.denormalize(start.requireOrig(), start.requireNorm(), end.requireOrig(), end.requireNorm());
    }

    private static <V extends Number> int binarySearch(List<LinearNorm> linearNorms, Function<LinearNorm, Number> thresholdFunction, Value<V> value) {
        int low = 0;
        int high = linearNorms.size() - 1;
        while (low <= high) {
            int mid = low + (high - low) / 2;
            LinearNorm linearNorm = linearNorms.get(mid);
            Number threshold = (Number)thresholdFunction.apply((Object)linearNorm);
            if (value.compareTo(threshold) >= 0) {
                if (mid < linearNorms.size() - 1) {
                    LinearNorm nextLinearNorm = linearNorms.get(mid + 1);
                    Number nextThreshold = (Number)thresholdFunction.apply((Object)nextLinearNorm);
                    if (value.compareTo(nextThreshold) <= 0) {
                        return mid;
                    }
                } else {
                    return mid;
                }
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -1;
    }

    private static List<LinearNorm> ensureLinearNorms(NormContinuous normContinuous) {
        List linearNorms = normContinuous.requireLinearNorms();
        if (linearNorms.size() < 2) {
            throw new InvalidElementListException(linearNorms);
        }
        return linearNorms;
    }
}

