/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import org.dmg.pmml.Model;
import org.dmg.pmml.PMML;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.Visitable;
import org.dmg.pmml.adapters.NodeAdapter;
import org.dmg.pmml.tree.NodeTransformer;
import org.dmg.pmml.tree.SimplifyingNodeTransformer;
import org.jpmml.evaluator.InputMapper;
import org.jpmml.evaluator.ModelEvaluatorBuilder;
import org.jpmml.evaluator.ModelEvaluatorFactory;
import org.jpmml.evaluator.OutputFilter;
import org.jpmml.evaluator.PMMLTransformer;
import org.jpmml.evaluator.PMMLUtil;
import org.jpmml.evaluator.ResultMapper;
import org.jpmml.evaluator.SymbolTable;
import org.jpmml.evaluator.ValueFactoryFactory;
import org.jpmml.evaluator.visitors.ModelEvaluatorVisitorBattery;
import org.jpmml.model.JAXBUtil;
import org.jpmml.model.SAXUtil;
import org.jpmml.model.filters.ImportFilter;
import org.jpmml.model.visitors.LocatorNullifier;
import org.jpmml.model.visitors.LocatorTransformer;
import org.jpmml.model.visitors.VisitorBattery;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

public class LoadingModelEvaluatorBuilder
extends ModelEvaluatorBuilder {
    private Schema schema = null;
    private ValidationEventHandler validationEventHandler = null;
    private List<? extends XMLFilter> filters = null;
    private boolean locatable = false;
    private boolean mutable = false;
    private VisitorBattery visitors = new ModelEvaluatorVisitorBattery();

    public LoadingModelEvaluatorBuilder load(File file) throws IOException, ParserConfigurationException, SAXException, JAXBException {
        try (FileInputStream is = new FileInputStream(file);){
            LoadingModelEvaluatorBuilder loadingModelEvaluatorBuilder = this.load(is);
            return loadingModelEvaluatorBuilder;
        }
    }

    public LoadingModelEvaluatorBuilder load(File file, String modelName) throws IOException, ParserConfigurationException, SAXException, JAXBException {
        try (FileInputStream is = new FileInputStream(file);){
            LoadingModelEvaluatorBuilder loadingModelEvaluatorBuilder = this.load(is, modelName);
            return loadingModelEvaluatorBuilder;
        }
    }

    public LoadingModelEvaluatorBuilder load(InputStream is) throws ParserConfigurationException, SAXException, JAXBException {
        return this.load(is, (String)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadingModelEvaluatorBuilder load(InputStream is, String modelName) throws ParserConfigurationException, SAXException, JAXBException {
        PMML pmml;
        Schema schema = this.getSchema();
        ValidationEventHandler validationEventHandler = this.getValidationEventHandler();
        List<? extends XMLFilter> filters = this.getFilters();
        boolean locatable = this.getLocatable();
        boolean mutable = this.getMutable();
        VisitorBattery visitors = this.getVisitors();
        Unmarshaller unmarshaller = JAXBUtil.createUnmarshaller();
        unmarshaller.setSchema(schema);
        unmarshaller.setEventHandler(validationEventHandler);
        if (filters == null) {
            filters = Collections.singletonList(new ImportFilter());
        }
        SAXSource source = SAXUtil.createFilteredSource((InputStream)is, (XMLFilter[])filters.toArray(new XMLFilter[filters.size()]));
        NodeTransformer defaultNodeTransformer = (NodeTransformer)NodeAdapter.NODE_TRANSFORMER_PROVIDER.get();
        try {
            NodeAdapter.NODE_TRANSFORMER_PROVIDER.set(mutable ? null : SimplifyingNodeTransformer.INSTANCE);
            pmml = (PMML)unmarshaller.unmarshal((Source)source);
        }
        finally {
            NodeAdapter.NODE_TRANSFORMER_PROVIDER.set(defaultNodeTransformer);
        }
        LocatorTransformer locatorHandler = locatable ? new LocatorTransformer() : new LocatorNullifier();
        locatorHandler.applyTo((Visitable)pmml);
        if (visitors != null && !visitors.isEmpty()) {
            visitors.applyTo((Visitable)pmml);
        }
        Model model = PMMLUtil.findModel(pmml, modelName);
        this.setPMML(pmml);
        this.setModel(model);
        return this;
    }

    public <E extends Exception> LoadingModelEvaluatorBuilder transform(PMMLTransformer<E> transformer) throws E {
        PMML pmml = this.getPMML();
        Model model = this.getModel();
        if (pmml == null || model == null) {
            throw new IllegalStateException();
        }
        String modelName = model.getModelName();
        PMML transformedPMML = transformer.apply(pmml);
        if (transformedPMML == null) {
            return this;
        }
        Model transformedModel = PMMLUtil.findModel(transformedPMML, modelName);
        this.setPMML(transformedPMML);
        this.setModel(transformedModel);
        return this;
    }

    @Override
    public LoadingModelEvaluatorBuilder clone() {
        return (LoadingModelEvaluatorBuilder)super.clone();
    }

    @Override
    protected LoadingModelEvaluatorBuilder setPMML(PMML pmml) {
        return (LoadingModelEvaluatorBuilder)super.setPMML(pmml);
    }

    @Override
    protected LoadingModelEvaluatorBuilder setModel(Model model) {
        return (LoadingModelEvaluatorBuilder)super.setModel(model);
    }

    @Override
    public LoadingModelEvaluatorBuilder setModelEvaluatorFactory(ModelEvaluatorFactory modelEvaluatorFactory) {
        return (LoadingModelEvaluatorBuilder)super.setModelEvaluatorFactory(modelEvaluatorFactory);
    }

    @Override
    public LoadingModelEvaluatorBuilder setValueFactoryFactory(ValueFactoryFactory valueFactoryFactory) {
        return (LoadingModelEvaluatorBuilder)super.setValueFactoryFactory(valueFactoryFactory);
    }

    @Override
    public LoadingModelEvaluatorBuilder setOutputFilter(OutputFilter outputFilter) {
        return (LoadingModelEvaluatorBuilder)super.setOutputFilter(outputFilter);
    }

    @Override
    public LoadingModelEvaluatorBuilder setDerivedFieldGuard(SymbolTable<String> derivedFieldGuard) {
        return (LoadingModelEvaluatorBuilder)super.setDerivedFieldGuard(derivedFieldGuard);
    }

    @Override
    public LoadingModelEvaluatorBuilder setFunctionGuard(SymbolTable<String> functionGuard) {
        return (LoadingModelEvaluatorBuilder)super.setFunctionGuard(functionGuard);
    }

    @Override
    public LoadingModelEvaluatorBuilder setExtraResultFeatures(Set<ResultFeature> extraResultFeatures) {
        return (LoadingModelEvaluatorBuilder)super.setExtraResultFeatures(extraResultFeatures);
    }

    @Override
    public LoadingModelEvaluatorBuilder setInputMapper(InputMapper inputMapper) {
        return (LoadingModelEvaluatorBuilder)super.setInputMapper(inputMapper);
    }

    @Override
    public LoadingModelEvaluatorBuilder setResultMapper(ResultMapper resultMapper) {
        return (LoadingModelEvaluatorBuilder)super.setResultMapper(resultMapper);
    }

    @Override
    public LoadingModelEvaluatorBuilder setCheckSchema(boolean checkSchema) {
        return (LoadingModelEvaluatorBuilder)super.setCheckSchema(checkSchema);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public LoadingModelEvaluatorBuilder setSchema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public ValidationEventHandler getValidationEventHandler() {
        return this.validationEventHandler;
    }

    public LoadingModelEvaluatorBuilder setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        this.validationEventHandler = validationEventHandler;
        return this;
    }

    public List<? extends XMLFilter> getFilters() {
        return this.filters;
    }

    public LoadingModelEvaluatorBuilder setFilters(List<? extends XMLFilter> filters) {
        this.filters = filters;
        return this;
    }

    public boolean getLocatable() {
        return this.locatable;
    }

    public LoadingModelEvaluatorBuilder setLocatable(boolean locatable) {
        this.locatable = locatable;
        return this;
    }

    public boolean getMutable() {
        return this.mutable;
    }

    public LoadingModelEvaluatorBuilder setMutable(boolean mutable) {
        this.mutable = mutable;
        return this;
    }

    public VisitorBattery getVisitors() {
        return this.visitors;
    }

    public LoadingModelEvaluatorBuilder setVisitors(VisitorBattery visitors) {
        this.visitors = visitors;
        return this;
    }
}

