/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Field;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningField;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.ResultFeature;
import org.dmg.pmml.Target;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitable;
import org.jpmml.evaluator.DefaultDataField;
import org.jpmml.evaluator.DuplicateFieldException;
import org.jpmml.evaluator.EvaluationException;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.HasModel;
import org.jpmml.evaluator.IndexableUtil;
import org.jpmml.evaluator.InputField;
import org.jpmml.evaluator.InvisibleFieldException;
import org.jpmml.evaluator.MissingFieldException;
import org.jpmml.evaluator.OutputField;
import org.jpmml.evaluator.PMMLManager;
import org.jpmml.evaluator.ResidualInputField;
import org.jpmml.evaluator.SyntheticTargetField;
import org.jpmml.evaluator.TargetField;
import org.jpmml.evaluator.VariableField;
import org.jpmml.model.UnsupportedElementException;
import org.jpmml.model.visitors.FieldResolver;

public abstract class ModelManager<M extends Model>
extends PMMLManager
implements HasModel<M> {
    private M model = null;
    private DefaultDataField defaultDataField = null;
    private Map<String, MiningField> miningFields = Collections.emptyMap();
    private Map<String, DerivedField> localDerivedFields = Collections.emptyMap();
    private Map<String, Target> targets = Collections.emptyMap();
    private Map<String, org.dmg.pmml.OutputField> outputFields = Collections.emptyMap();
    private Set<ResultFeature> resultFeatures = Collections.emptySet();
    private List<InputField> inputFields = null;
    private List<InputField> activeInputFields = null;
    private List<TargetField> targetResultFields = null;
    private List<OutputField> outputResultFields = null;
    private ListMultimap<String, Field<?>> visibleFields = null;

    protected ModelManager() {
    }

    protected ModelManager(PMML pmml, M model) {
        super(pmml);
        Output output;
        Targets targets;
        LocalTransformations localTransformations;
        this.setModel(model);
        MiningFunction miningFunction = model.requireMiningFunction();
        MiningSchema miningSchema = model.requireMiningSchema();
        if (miningSchema.hasMiningFields()) {
            this.miningFields = ImmutableMap.copyOf(IndexableUtil.buildMap(miningSchema.getMiningFields()));
        }
        if ((localTransformations = model.getLocalTransformations()) != null && localTransformations.hasDerivedFields()) {
            this.localDerivedFields = ImmutableMap.copyOf(IndexableUtil.buildMap(localTransformations.getDerivedFields()));
        }
        if ((targets = model.getTargets()) != null && targets.hasTargets()) {
            this.targets = Collections.unmodifiableMap(IndexableUtil.buildMap(targets.getTargets()));
        }
        if ((output = model.getOutput()) != null && output.hasOutputFields()) {
            this.outputFields = ImmutableMap.copyOf(IndexableUtil.buildMap(output.getOutputFields()));
            this.resultFeatures = Sets.immutableEnumSet(ModelManager.collectResultFeatures(output));
        }
    }

    public MiningFunction getMiningFunction() {
        M model = this.getModel();
        return model.requireMiningFunction();
    }

    public MathContext getMathContext() {
        M model = this.getModel();
        return model.getMathContext();
    }

    @Override
    public DataField getDataField(String name) {
        if (Objects.equals(Evaluator.DEFAULT_TARGET_NAME, name)) {
            return this.getDefaultDataField();
        }
        return super.getDataField(name);
    }

    public DefaultDataField getDefaultDataField() {
        if (this.defaultDataField != null) {
            return this.defaultDataField;
        }
        MiningFunction miningFunction = this.getMiningFunction();
        switch (miningFunction) {
            case REGRESSION: {
                MathContext mathContext = this.getMathContext();
                switch (mathContext) {
                    case FLOAT: {
                        return DefaultDataField.CONTINUOUS_FLOAT;
                    }
                }
                return DefaultDataField.CONTINUOUS_DOUBLE;
            }
            case CLASSIFICATION: 
            case CLUSTERING: {
                return DefaultDataField.CATEGORICAL_STRING;
            }
        }
        return null;
    }

    public void setDefaultDataField(DefaultDataField defaultDataField) {
        this.defaultDataField = defaultDataField;
    }

    public MiningField getMiningField(String name) {
        if (Objects.equals(Evaluator.DEFAULT_TARGET_NAME, name)) {
            return null;
        }
        return this.miningFields.get(name);
    }

    protected boolean hasLocalDerivedFields() {
        return !this.localDerivedFields.isEmpty();
    }

    public DerivedField getLocalDerivedField(String name) {
        return this.localDerivedFields.get(name);
    }

    public Target getTarget(String name) {
        return this.targets.get(name);
    }

    protected boolean hasOutputFields() {
        return !this.outputFields.isEmpty();
    }

    public org.dmg.pmml.OutputField getOutputField(String name) {
        return this.outputFields.get(name);
    }

    public boolean hasResultFeature(ResultFeature resultFeature) {
        Set<ResultFeature> resultFeatures = this.getResultFeatures();
        return resultFeatures.contains(resultFeature);
    }

    public void addResultFeatures(Set<ResultFeature> resultFeatures) {
        this.resultFeatures = Sets.immutableEnumSet((Iterable)Iterables.concat(this.resultFeatures, resultFeatures));
    }

    protected Set<ResultFeature> getResultFeatures() {
        return this.resultFeatures;
    }

    public List<InputField> getInputFields() {
        if (this.inputFields == null) {
            List<InputField> inputFields = this.filterInputFields(this.createInputFields());
            this.inputFields = ImmutableList.copyOf(inputFields);
        }
        return this.inputFields;
    }

    public List<InputField> getActiveFields() {
        if (this.activeInputFields == null) {
            List<InputField> activeInputFields = this.filterInputFields(this.createInputFields(MiningField.UsageType.ACTIVE));
            this.activeInputFields = ImmutableList.copyOf(activeInputFields);
        }
        return this.activeInputFields;
    }

    public List<TargetField> getTargetFields() {
        if (this.targetResultFields == null) {
            List<TargetField> targetResultFields = this.filterTargetFields(this.createTargetFields());
            this.targetResultFields = ImmutableList.copyOf(targetResultFields);
        }
        return this.targetResultFields;
    }

    public TargetField getTargetField() {
        List<TargetField> targetFields = this.getTargetFields();
        if (targetFields.size() != 1) {
            throw this.createMiningSchemaException("Expected 1 target field, got " + targetFields.size() + " target fields");
        }
        TargetField targetField = targetFields.get(0);
        return targetField;
    }

    public String getTargetName() {
        TargetField targetField = this.getTargetField();
        return targetField.getFieldName();
    }

    TargetField findTargetField(String name) {
        List<TargetField> targetFields = this.getTargetFields();
        if (targetFields.size() == 1) {
            TargetField targetField = targetFields.get(0);
            if (Objects.equals(targetField.getFieldName(), name)) {
                return targetField;
            }
        } else {
            for (TargetField targetField : targetFields) {
                if (!Objects.equals(targetField.getFieldName(), name)) continue;
                return targetField;
            }
        }
        return null;
    }

    public List<OutputField> getOutputFields() {
        if (this.outputResultFields == null) {
            List<OutputField> outputResultFields = this.filterOutputFields(this.createOutputFields());
            this.outputResultFields = ImmutableList.copyOf(outputResultFields);
        }
        return this.outputResultFields;
    }

    protected void resetInputFields() {
        this.inputFields = null;
        this.activeInputFields = null;
    }

    protected void resetResultFields() {
        this.targetResultFields = null;
        this.outputResultFields = null;
    }

    protected Field<?> resolveField(String name) {
        ListMultimap<String, Field<?>> visibleFields = this.getVisibleFields();
        List fields = visibleFields.get((Object)name);
        if (fields.isEmpty()) {
            return null;
        }
        if (fields.size() == 1) {
            return (Field)fields.get(0);
        }
        throw new DuplicateFieldException(name);
    }

    protected ListMultimap<String, Field<?>> getVisibleFields() {
        if (this.visibleFields == null) {
            this.visibleFields = this.collectVisibleFields();
        }
        return this.visibleFields;
    }

    protected EvaluationException createMiningSchemaException(String message) {
        M model = this.getModel();
        MiningSchema miningSchema = model.requireMiningSchema();
        return new EvaluationException(message, (PMMLObject)miningSchema);
    }

    protected List<InputField> createInputFields() {
        List<InputField> inputFields = this.getActiveFields();
        List<OutputField> outputFields = this.getOutputFields();
        if (!outputFields.isEmpty()) {
            ArrayList<InputField> expandedInputFields = null;
            for (OutputField outputField : outputFields) {
                DataField dataField;
                org.dmg.pmml.OutputField pmmlOutputField = outputField.getField();
                if (pmmlOutputField.getResultFeature() != ResultFeature.RESIDUAL) continue;
                int depth = outputField.getDepth();
                if (depth > 0) {
                    throw new UnsupportedElementException((PMMLObject)pmmlOutputField);
                }
                String targetFieldName = pmmlOutputField.getTargetField();
                if (targetFieldName == null) {
                    targetFieldName = this.getTargetName();
                }
                if ((dataField = this.getDataField(targetFieldName)) == null) {
                    throw new MissingFieldException(targetFieldName, (PMMLObject)pmmlOutputField);
                }
                MiningField miningField = this.getMiningField(targetFieldName);
                if (miningField == null) {
                    throw new InvisibleFieldException(targetFieldName, (PMMLObject)pmmlOutputField);
                }
                ResidualInputField residualInputField = new ResidualInputField(dataField, miningField);
                if (expandedInputFields == null) {
                    expandedInputFields = new ArrayList<InputField>(inputFields);
                }
                expandedInputFields.add(residualInputField);
            }
            if (expandedInputFields != null) {
                return expandedInputFields;
            }
        }
        return inputFields;
    }

    protected List<InputField> createInputFields(MiningField.UsageType usageType) {
        M model = this.getModel();
        ArrayList<InputField> inputFields = new ArrayList<InputField>();
        MiningSchema miningSchema = model.requireMiningSchema();
        if (miningSchema.hasMiningFields()) {
            List miningFields = miningSchema.getMiningFields();
            for (MiningField miningField : miningFields) {
                String fieldName = miningField.requireName();
                if (miningField.getUsageType() != usageType) continue;
                Object field = this.getDataField(fieldName);
                if (field == null) {
                    field = new VariableField(fieldName);
                }
                InputField inputField = new InputField((Field<?>)field, miningField);
                inputFields.add(inputField);
            }
        }
        return inputFields;
    }

    protected List<InputField> filterInputFields(List<InputField> inputFields) {
        return inputFields;
    }

    protected List<TargetField> createTargetFields() {
        DefaultDataField defaultDataField;
        M model = this.getModel();
        ArrayList<TargetField> targetFields = new ArrayList<TargetField>();
        MiningSchema miningSchema = model.requireMiningSchema();
        if (miningSchema.hasMiningFields()) {
            List miningFields = miningSchema.getMiningFields();
            block3: for (MiningField miningField : miningFields) {
                String fieldName = miningField.requireName();
                MiningField.UsageType usageType = miningField.getUsageType();
                switch (usageType) {
                    case PREDICTED: 
                    case TARGET: {
                        break;
                    }
                    default: {
                        continue block3;
                    }
                }
                DataField dataField = this.getDataField(fieldName);
                if (dataField == null) {
                    throw new MissingFieldException(miningField);
                }
                Target target = this.getTarget(fieldName);
                TargetField targetField = new TargetField(dataField, miningField, target);
                targetFields.add(targetField);
            }
        }
        if (targetFields.isEmpty() && (defaultDataField = this.getDefaultDataField()) != null) {
            Target target = this.getTarget(defaultDataField.requireName());
            SyntheticTargetField targetField = new SyntheticTargetField(defaultDataField, target);
            targetFields.add(targetField);
        }
        return targetFields;
    }

    protected List<TargetField> filterTargetFields(List<TargetField> targetFields) {
        return targetFields;
    }

    protected List<OutputField> createOutputFields() {
        M model = this.getModel();
        Output output = model.getOutput();
        ArrayList<OutputField> outputFields = new ArrayList<OutputField>();
        if (output != null && output.hasOutputFields()) {
            List pmmlOutputFields = output.getOutputFields();
            for (org.dmg.pmml.OutputField pmmlOutputField : pmmlOutputFields) {
                OutputField outputField = new OutputField(pmmlOutputField);
                outputFields.add(outputField);
            }
        }
        return outputFields;
    }

    protected List<OutputField> filterOutputFields(List<OutputField> outputFields) {
        return outputFields;
    }

    private ListMultimap<String, Field<?>> collectVisibleFields() {
        PMML pmml = this.getPMML();
        M model = this.getModel();
        ArrayListMultimap visibleFields = ArrayListMultimap.create();
        FieldResolver fieldResolver = new FieldResolver((Model)model, (ListMultimap)visibleFields){
            final /* synthetic */ Model val$model;
            final /* synthetic */ ListMultimap val$visibleFields;
            {
                this.val$model = model;
                this.val$visibleFields = listMultimap;
            }

            public PMMLObject popParent() {
                PMMLObject parent = super.popParent();
                if (Objects.equals(this.val$model, parent)) {
                    Model model = (Model)parent;
                    Collection fields = this.getFields(new PMMLObject[]{model});
                    for (Field field : fields) {
                        this.val$visibleFields.put((Object)field.requireName(), (Object)field);
                    }
                }
                return parent;
            }
        };
        fieldResolver.applyTo((Visitable)pmml);
        return ImmutableListMultimap.copyOf((Multimap)visibleFields);
    }

    @Override
    public M getModel() {
        return this.model;
    }

    private void setModel(M model) {
        this.model = (Model)Objects.requireNonNull(model);
    }

    protected static Set<ResultFeature> collectResultFeatures(Output output) {
        EnumSet<ResultFeature> result = EnumSet.noneOf(ResultFeature.class);
        if (output != null && output.hasOutputFields()) {
            List pmmlOutputFields = output.getOutputFields();
            for (org.dmg.pmml.OutputField pmmlOutputField : pmmlOutputFields) {
                String segmentId = pmmlOutputField.getSegmentId();
                if (segmentId != null) continue;
                result.add(pmmlOutputField.getResultFeature());
            }
        }
        return result;
    }

    protected static Map<String, Set<ResultFeature>> collectSegmentResultFeatures(Output output) {
        LinkedHashMap<String, Set<ResultFeature>> result = new LinkedHashMap<String, Set<ResultFeature>>();
        List pmmlOutputFields = output.getOutputFields();
        for (org.dmg.pmml.OutputField pmmlOutputField : pmmlOutputFields) {
            String segmentId = pmmlOutputField.getSegmentId();
            if (segmentId == null) continue;
            EnumSet<ResultFeature> resultFeatures = (EnumSet<ResultFeature>)result.get(segmentId);
            if (resultFeatures == null) {
                resultFeatures = EnumSet.noneOf(ResultFeature.class);
                result.put(segmentId, resultFeatures);
            }
            resultFeatures.add(pmmlOutputField.getResultFeature());
        }
        return result;
    }
}

