/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import com.google.common.base.Function;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jpmml.evaluator.HasProbability;
import org.jpmml.evaluator.KeyValueAggregator;
import org.jpmml.evaluator.UndefinedResultException;
import org.jpmml.evaluator.Value;
import org.jpmml.evaluator.ValueFactory;
import org.jpmml.evaluator.ValueMap;
import org.jpmml.evaluator.Vector;

public class ProbabilityAggregator<V extends Number>
extends KeyValueAggregator<Object, V> {
    private List<HasProbability> hasProbabilities = null;
    private int size = 0;
    private Vector<V> weights = null;

    protected ProbabilityAggregator(ValueFactory<V> valueFactory, int capacity) {
        this(valueFactory, capacity, false);
    }

    protected ProbabilityAggregator(ValueFactory<V> valueFactory, int capacity, boolean weighted) {
        super(valueFactory, capacity);
        if (capacity > 0) {
            this.hasProbabilities = new ArrayList<HasProbability>(capacity);
        }
        if (weighted) {
            this.weights = valueFactory.newVector(0);
        }
    }

    public void add(HasProbability hasProbability) {
        if (this.weights != null) {
            throw new IllegalStateException();
        }
        if (this.hasProbabilities != null) {
            this.hasProbabilities.add(hasProbability);
        }
        Set categories = hasProbability.getCategories();
        for (Object category : categories) {
            Double probability = hasProbability.getProbability(category);
            this.add(category, (Number)probability);
        }
        ++this.size;
    }

    public void add(Number[] probabilities) {
        if (this.weights != null || this.hasProbabilities != null) {
            throw new IllegalStateException();
        }
        Collection mapValues = this.values();
        if (mapValues.size() != probabilities.length) {
            throw new IllegalArgumentException();
        }
        Iterator valueIt = mapValues.iterator();
        int i = 0;
        while (valueIt.hasNext()) {
            Vector values = valueIt.next();
            values.add(probabilities[i]);
            ++i;
        }
        ++this.size;
    }

    @Override
    public void add(HasProbability hasProbability, Number weight) {
        if (this.weights == null) {
            throw new IllegalStateException();
        }
        if (weight.doubleValue() < 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.hasProbabilities != null) {
            this.hasProbabilities.add(hasProbability);
        }
        Set categories = hasProbability.getCategories();
        for (Object category : categories) {
            Double probability = hasProbability.getProbability(category);
            this.add(category, weight, probability);
        }
        ++this.size;
        this.weights.add(weight);
    }

    @Override
    public void add(Number[] probabilities, Number weight) {
        if (this.weights == null || this.hasProbabilities != null) {
            throw new IllegalStateException();
        }
        Collection mapValues = this.values();
        if (mapValues.size() != probabilities.length) {
            throw new IllegalArgumentException();
        }
        if (weight.doubleValue() < 0.0) {
            throw new IllegalArgumentException();
        }
        Iterator valueIt = mapValues.iterator();
        int i = 0;
        while (valueIt.hasNext()) {
            Vector values = valueIt.next();
            if (weight.doubleValue() != 1.0) {
                values.add(weight, probabilities[i]);
            } else {
                values.add(probabilities[i]);
            }
            ++i;
        }
        ++this.size;
        this.weights.add(weight);
    }

    public ValueMap<Object, V> averageMap() {
        if (this.weights != null) {
            throw new IllegalStateException();
        }
        Function function = new Function<Vector<V>, Value<V>>(){
            private int size;
            {
                this.size = ProbabilityAggregator.this.size;
            }

            public Value<V> apply(Vector<V> values) {
                if (this.size == 0) {
                    throw new UndefinedResultException();
                }
                return values.sum().divide(this.size);
            }
        };
        return new ValueMap(this.asTransformedMap(function));
    }

    public ValueMap<Object, V> weightedAverageMap() {
        if (this.weights == null) {
            throw new IllegalStateException();
        }
        Function function = new Function<Vector<V>, Value<V>>(){
            private Value<V> weightSum;
            {
                this.weightSum = ProbabilityAggregator.this.weights.sum();
            }

            public Value<V> apply(Vector<V> values) {
                if (this.weightSum.isZero()) {
                    throw new UndefinedResultException();
                }
                return values.sum().divide(this.weightSum);
            }
        };
        return new ValueMap(this.asTransformedMap(function));
    }

    public ValueMap<Object, V> maxMap(Collection<?> categories) {
        if (this.hasProbabilities == null) {
            throw new IllegalStateException();
        }
        if (this.weights != null) {
            throw new IllegalStateException();
        }
        Map maxMap = this.asTransformedMap(Vector::max);
        Map.Entry winnerEntry = ProbabilityAggregator.getWinner(maxMap, categories);
        if (winnerEntry == null) {
            return new ValueMap();
        }
        Object category = winnerEntry.getKey();
        Value maxProbability = winnerEntry.getValue();
        ArrayList<HasProbability> contributors = new ArrayList<HasProbability>();
        Vector values = this.get(category);
        int max = values.size();
        for (int i = 0; i < max; ++i) {
            Value probability = values.get(i);
            if (maxProbability.compareTo(probability) != 0) continue;
            HasProbability contributor = this.hasProbabilities.get(i);
            contributors.add(contributor);
        }
        return this.averageMap(contributors);
    }

    public ValueMap<Object, V> medianMap(Collection<?> categories) {
        if (this.hasProbabilities == null) {
            throw new IllegalStateException();
        }
        if (this.weights != null) {
            throw new IllegalStateException();
        }
        Map medianMap = this.asTransformedMap(Vector::median);
        Map.Entry winnerEntry = ProbabilityAggregator.getWinner(medianMap, categories);
        if (winnerEntry == null) {
            return new ValueMap();
        }
        Object category = winnerEntry.getKey();
        Value medianProbability = winnerEntry.getValue();
        ArrayList<HasProbability> contributors = new ArrayList<HasProbability>();
        double minDifference = Double.MAX_VALUE;
        Vector values = this.get(category);
        int max = values.size();
        for (int i = 0; i < max; ++i) {
            Value probability = values.get(i);
            double difference = Math.abs(medianProbability.doubleValue() - probability.doubleValue());
            if (difference < minDifference) {
                contributors.clear();
                minDifference = difference;
            }
            if (!(difference <= minDifference)) continue;
            HasProbability contributor = this.hasProbabilities.get(i);
            contributors.add(contributor);
        }
        return this.averageMap(contributors);
    }

    private ValueMap<Object, V> averageMap(List<HasProbability> hasProbabilities) {
        ValueFactory valueFactory = this.getValueFactory();
        if (hasProbabilities.size() == 1) {
            HasProbability hasProbability = hasProbabilities.get(0);
            ValueMap result = new ValueMap();
            Set categories = this.keySet();
            for (Object category : categories) {
                Double probability = hasProbability.getProbability(category);
                Value value = valueFactory.newValue(probability);
                result.put(category, value);
            }
            return result;
        }
        Average aggregator = new Average(valueFactory);
        aggregator.init(this.keySet());
        int max = hasProbabilities.size();
        for (int i = 0; i < max; ++i) {
            HasProbability hasProbability = hasProbabilities.get(i);
            aggregator.add(hasProbability);
        }
        return aggregator.averageMap();
    }

    private static <V extends Number> Map.Entry<Object, Value<V>> getWinner(Map<?, Value<V>> values, Collection<?> categories) {
        AbstractMap.SimpleEntry maxEntry = null;
        if (categories == null) {
            categories = values.keySet();
        }
        for (Object category : categories) {
            Value<V> value = values.get(category);
            if (value == null || maxEntry != null && ((Value)maxEntry.getValue()).compareTo(value) >= 0) continue;
            maxEntry = new AbstractMap.SimpleEntry(category, value);
        }
        return maxEntry;
    }

    public static class Median<V extends Number>
    extends ProbabilityAggregator<V> {
        public Median(ValueFactory<V> valueFactory, int capacity) {
            super(valueFactory, capacity);
        }
    }

    public static class Max<V extends Number>
    extends ProbabilityAggregator<V> {
        public Max(ValueFactory<V> valueFactory, int capacity) {
            super(valueFactory, capacity);
        }
    }

    public static class WeightedAverage<V extends Number>
    extends ProbabilityAggregator<V> {
        public WeightedAverage(ValueFactory<V> valueFactory) {
            super(valueFactory, 0, true);
        }
    }

    public static class Average<V extends Number>
    extends ProbabilityAggregator<V> {
        public Average(ValueFactory<V> valueFactory) {
            super(valueFactory, 0);
        }
    }
}

