/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.Array;
import org.dmg.pmml.DataType;
import org.dmg.pmml.HasType;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.HasValueSet;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.CategoricalValue;
import org.jpmml.evaluator.ContinuousValue;
import org.jpmml.evaluator.FieldValueUtil;
import org.jpmml.evaluator.OrdinalValue;
import org.jpmml.evaluator.SetHolder;
import org.jpmml.evaluator.TypeCheckException;
import org.jpmml.evaluator.TypeInfo;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.model.ToStringHelper;
import org.jpmml.model.temporals.Date;
import org.jpmml.model.temporals.DateTime;
import org.jpmml.model.temporals.Instant;
import org.jpmml.model.temporals.Time;

public abstract class FieldValue
implements TypeInfo,
Serializable {
    private DataType dataType = null;
    private Object value = null;
    static final Integer STATUS_UNKNOWN_VALID = Integer.MAX_VALUE;
    static final Integer STATUS_MISSING = 0;
    static final Integer STATUS_UNKNOWN_INVALID = Integer.MIN_VALUE;

    FieldValue() {
    }

    FieldValue(DataType dataType, Object value) {
        this.setDataType(dataType);
        this.setValue(value);
    }

    public abstract boolean isValid();

    public abstract int compareToValue(Object var1);

    public abstract int compareToValue(FieldValue var1);

    public FieldValue cast(HasType<?> hasType) {
        DataType dataType = hasType.getDataType();
        OpType opType = hasType.getOpType();
        boolean equal = true;
        if (dataType == null) {
            dataType = this.getDataType();
        } else {
            equal &= this.getDataType() == dataType;
        }
        if (opType == null) {
            opType = this.getOpType();
        } else {
            equal &= this.getOpType() == opType;
        }
        if (equal) {
            return this;
        }
        return FieldValue.create(opType, dataType, this.getValue());
    }

    public FieldValue cast(TypeInfo typeInfo) {
        DataType dataType = typeInfo.getDataType();
        OpType opType = typeInfo.getOpType();
        if (this.getDataType() == dataType && this.getOpType() == opType) {
            return this;
        }
        return FieldValue.create(typeInfo, this.getValue());
    }

    public int compareTo(HasValue<?> hasValue) {
        return this.compareToValue(hasValue.requireValue());
    }

    public boolean equals(HasValue<?> hasValue) {
        return this.equalsValue(hasValue.requireValue());
    }

    public boolean isIn(HasValueSet<?> hasValueSet) {
        Array array = hasValueSet.requireArray();
        if (array instanceof SetHolder) {
            SetHolder setHolder = (SetHolder)array;
            return setHolder.contains(this.getDataType(), this.getValue());
        }
        List<?> values = ArrayUtil.getContent(array);
        int max = values.size();
        for (int i = 0; i < max; ++i) {
            Object value = values.get(i);
            if (!this.equalsValue(value)) continue;
            return true;
        }
        return false;
    }

    public boolean isIn(Collection<FieldValue> values) {
        for (FieldValue value : values) {
            if (FieldValueUtil.isMissing(value) || !this.equalsValue(value)) continue;
            return true;
        }
        return false;
    }

    public boolean equalsValue(Object value) {
        value = TypeUtil.parseOrCast(this.getDataType(), value);
        return this.getValue().equals(value);
    }

    public boolean equalsValue(FieldValue value) {
        return this.equalsValue(value.getValue());
    }

    public Collection<?> asCollection() {
        return TypeUtil.cast(Collection.class, this.getValue());
    }

    public String asString() {
        return (String)this.getValue(DataType.STRING);
    }

    public Number asNumber() {
        Object value = this.getValue();
        if (value instanceof Number) {
            return (Number)value;
        }
        return (Number)this.getValue(DataType.DOUBLE);
    }

    public Integer asInteger() {
        return (Integer)this.getValue(DataType.INTEGER);
    }

    public Float asFloat() {
        Number number = this.asNumber();
        return Float.valueOf(number.floatValue());
    }

    public Double asDouble() {
        Number number = this.asNumber();
        return number.doubleValue();
    }

    public Boolean asBoolean() {
        return (Boolean)this.getValue(DataType.BOOLEAN);
    }

    public Date asDate() {
        return (Date)this.getValue(DataType.DATE);
    }

    public Time asTime() {
        return (Time)this.getValue(DataType.TIME);
    }

    public DateTime asDateTime() {
        return (DateTime)this.getValue(DataType.DATE_TIME);
    }

    public Instant<?> asInstant() {
        DataType dataType = this.getDataType();
        switch (dataType) {
            case DATE: 
            case TIME: 
            case DATE_TIME: {
                return TypeUtil.cast(Instant.class, this.getValue());
            }
        }
        try {
            return this.asDateTime();
        }
        catch (TypeCheckException tceDateTime) {
            try {
                return this.asDate();
            }
            catch (TypeCheckException typeCheckException) {
                try {
                    return this.asTime();
                }
                catch (TypeCheckException typeCheckException2) {
                    throw tceDateTime;
                }
            }
        }
    }

    Object getValue(DataType dataType) {
        if (this.getDataType() == dataType) {
            return this.getValue();
        }
        return TypeUtil.parseOrCast(dataType, this.getValue());
    }

    public int hashCode() {
        return 31 * (this.getOpType().hashCode() ^ this.getDataType().hashCode()) + this.getValue().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof FieldValue) {
            FieldValue that = (FieldValue)object;
            return this.getOpType() == that.getOpType() && this.getDataType() == that.getDataType() && this.getValue().equals(that.getValue());
        }
        return false;
    }

    public String toString() {
        ToStringHelper helper = this.toStringHelper();
        return helper.toString();
    }

    protected ToStringHelper toStringHelper() {
        ToStringHelper helper = new ToStringHelper((Object)this).add("opType", (Object)this.getOpType()).add("dataType", (Object)this.getDataType()).add("value", this.getValue());
        return helper;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    private void setDataType(DataType dataType) {
        this.dataType = Objects.requireNonNull(dataType);
    }

    public Object getValue() {
        return this.value;
    }

    private void setValue(Object value) {
        this.value = Objects.requireNonNull(value);
    }

    public static FieldValue create(OpType opType, DataType dataType, Object value) {
        if (opType == null || dataType == null) {
            throw new IllegalArgumentException();
        }
        switch (opType) {
            case CONTINUOUS: {
                return ContinuousValue.create(dataType, value);
            }
            case CATEGORICAL: {
                return CategoricalValue.create(dataType, value);
            }
            case ORDINAL: {
                return OrdinalValue.create(dataType, (List)null, value);
            }
        }
        throw new IllegalArgumentException();
    }

    public static FieldValue create(TypeInfo typeInfo, Object value) {
        if (typeInfo == null) {
            throw new IllegalArgumentException();
        }
        DataType dataType = typeInfo.getDataType();
        OpType opType = typeInfo.getOpType();
        switch (opType) {
            case CONTINUOUS: {
                return ContinuousValue.create(dataType, value);
            }
            case CATEGORICAL: {
                return CategoricalValue.create(dataType, value);
            }
            case ORDINAL: {
                List<?> ordering = typeInfo.getOrdering();
                return OrdinalValue.create(dataType, ordering, value);
            }
        }
        throw new IllegalArgumentException();
    }
}

