/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.dmg.pmml.Array;
import org.dmg.pmml.DataType;
import org.dmg.pmml.MatCell;
import org.dmg.pmml.Matrix;
import org.dmg.pmml.PMMLObject;
import org.jpmml.evaluator.ArrayUtil;
import org.jpmml.evaluator.TypeUtil;
import org.jpmml.model.InvalidElementException;
import org.jpmml.model.UnsupportedAttributeException;

public class MatrixUtil {
    private static final Comparator<MatCell> rowComparator = new Comparator<MatCell>(){

        @Override
        public int compare(MatCell left, MatCell right) {
            return left.requireRow() - right.requireRow();
        }
    };
    private static final Comparator<MatCell> columnComparator = new Comparator<MatCell>(){

        @Override
        public int compare(MatCell left, MatCell right) {
            return left.requireCol() - right.requireCol();
        }
    };

    private MatrixUtil() {
    }

    public static RealMatrix asRealMatrix(Matrix matrix) {
        Integer nbRows = matrix.getNbRows();
        Integer nbCols = matrix.getNbCols();
        List arrays = matrix.getArrays();
        List matCells = matrix.getMatCells();
        Integer nbMax = null;
        Matrix.Kind kind = matrix.getKind();
        switch (kind) {
            case DIAGONAL: 
            case SYMMETRIC: {
                if (nbCols == null) break;
                if (nbMax == null) {
                    nbMax = nbCols;
                    break;
                }
                if (nbCols.intValue() == nbMax.intValue()) break;
                throw new InvalidElementException((PMMLObject)matrix);
            }
        }
        switch (kind) {
            case DIAGONAL: {
                if (arrays.size() != 1) break;
                Array array = (Array)arrays.get(0);
                List<? extends Number> elements = ArrayUtil.asNumberList(array);
                int max = elements.size();
                if (nbMax != null && max != nbMax) {
                    throw new InvalidElementException((PMMLObject)matrix);
                }
                RealMatrix result = MatrixUtils.createRealMatrix((int)max, (int)max);
                Number offDiagDefault = matrix.getOffDiagDefault();
                if (offDiagDefault != null && offDiagDefault.doubleValue() == 0.0) {
                    offDiagDefault = null;
                }
                for (int i = 0; i < max; ++i) {
                    Number element = elements.get(i);
                    result.setEntry(i, i, element.doubleValue());
                    if (offDiagDefault == null) continue;
                    for (int j = 0; j < max; ++j) {
                        if (i == j) continue;
                        result.setEntry(i, j, offDiagDefault.doubleValue());
                    }
                }
                return result;
            }
            case SYMMETRIC: {
                if (arrays.isEmpty()) break;
                int max = arrays.size();
                if (nbMax != null && max != nbMax) {
                    throw new InvalidElementException((PMMLObject)matrix);
                }
                RealMatrix result = MatrixUtils.createRealMatrix((int)max, (int)max);
                for (int i = 0; i < max; ++i) {
                    Array array = (Array)arrays.get(i);
                    List<? extends Number> elements = ArrayUtil.asNumberList(array);
                    for (int j = 0; j <= i; ++j) {
                        Number element = elements.get(j);
                        result.setEntry(i, j, element.doubleValue());
                        if (i == j) continue;
                        result.setEntry(j, i, element.doubleValue());
                    }
                }
                return result;
            }
            case ANY: {
                Number offDiagDefault;
                Number diagDefault;
                MatCell matCell;
                if (!arrays.isEmpty()) {
                    if (nbRows != null && arrays.size() != nbRows.intValue()) {
                        throw new InvalidElementException((PMMLObject)matrix);
                    }
                    RealMatrix result = null;
                    for (int i = 0; i < arrays.size(); ++i) {
                        Array array = (Array)arrays.get(i);
                        List<? extends Number> elements = ArrayUtil.asNumberList(array);
                        if (nbCols != null && elements.size() != nbCols.intValue()) {
                            throw new InvalidElementException((PMMLObject)matrix);
                        }
                        if (result == null) {
                            result = MatrixUtils.createRealMatrix((int)arrays.size(), (int)elements.size());
                        }
                        for (int j = 0; j < elements.size(); ++j) {
                            Number element = elements.get(j);
                            result.setEntry(i, j, element.doubleValue());
                        }
                    }
                    return result;
                }
                if (matCells.isEmpty()) break;
                if (nbRows == null) {
                    matCell = Collections.max(matCells, rowComparator);
                    nbRows = matCell.requireRow();
                }
                if (nbCols == null) {
                    matCell = Collections.max(matCells, columnComparator);
                    nbCols = matCell.requireCol();
                }
                if ((diagDefault = matrix.getDiagDefault()) != null && diagDefault.doubleValue() == 0.0) {
                    diagDefault = null;
                }
                if ((offDiagDefault = matrix.getOffDiagDefault()) != null && offDiagDefault.doubleValue() == 0.0) {
                    offDiagDefault = null;
                }
                RealMatrix result = MatrixUtils.createRealMatrix((int)nbRows, (int)nbCols);
                if (diagDefault != null || offDiagDefault != null) {
                    for (int i = 0; i < nbRows; ++i) {
                        for (int j = 0; j < nbCols; ++j) {
                            if (i == j) {
                                if (diagDefault == null) continue;
                                result.setEntry(i, j, diagDefault.doubleValue());
                                continue;
                            }
                            if (offDiagDefault == null) continue;
                            result.setEntry(i, j, offDiagDefault.doubleValue());
                        }
                    }
                }
                for (MatCell matCell2 : matCells) {
                    Number value = (Number)TypeUtil.parseOrCast(DataType.DOUBLE, matCell2.getValue());
                    result.setEntry(matCell2.requireRow() - 1, matCell2.requireCol() - 1, value.doubleValue());
                }
                return result;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)matrix, (Enum)kind);
            }
        }
        throw new InvalidElementException((PMMLObject)matrix);
    }

    public static Number getElementAt(Matrix matrix, int row, int column) {
        List arrays = matrix.getArrays();
        List matCells = matrix.getMatCells();
        Matrix.Kind kind = matrix.getKind();
        switch (kind) {
            case DIAGONAL: {
                if (arrays.size() != 1) break;
                Array array = (Array)arrays.get(0);
                List<? extends Number> elements = ArrayUtil.asNumberList(array);
                if (row == column) {
                    return elements.get(row - 1);
                }
                int min = 1;
                int max = elements.size();
                if (row < min || row > max || column < min || column > max) {
                    throw new IndexOutOfBoundsException();
                }
                return matrix.getOffDiagDefault();
            }
            case SYMMETRIC: {
                if (arrays.isEmpty()) break;
                if (column > row) {
                    int temp = row;
                    row = column;
                    column = temp;
                }
                return MatrixUtil.getArrayValue(arrays, row, column);
            }
            case ANY: {
                if (!arrays.isEmpty()) {
                    return MatrixUtil.getArrayValue(arrays, row, column);
                }
                if (matCells.isEmpty()) break;
                if (row < 1 || column < 1) {
                    throw new IndexOutOfBoundsException();
                }
                Number value = MatrixUtil.getMatCellValue(matCells, row, column);
                if (value == null) {
                    if (row == column) {
                        return matrix.getDiagDefault();
                    }
                    return matrix.getOffDiagDefault();
                }
                return value;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)matrix, (Enum)kind);
            }
        }
        throw new InvalidElementException((PMMLObject)matrix);
    }

    private static Number getArrayValue(List<Array> arrays, int row, int column) {
        Array array = arrays.get(row - 1);
        List<? extends Number> elements = ArrayUtil.asNumberList(array);
        return elements.get(column - 1);
    }

    private static Number getMatCellValue(List<MatCell> matCells, int row, int column) {
        int max = matCells.size();
        for (int i = 0; i < max; ++i) {
            MatCell matCell = matCells.get(i);
            if (matCell.requireRow() != row || matCell.requireCol() != column) continue;
            return (Number)TypeUtil.parseOrCast(DataType.DOUBLE, matCell.getValue());
        }
        return null;
    }

    public static int getRows(Matrix matrix) {
        Integer nbRows = matrix.getNbRows();
        if (nbRows != null) {
            return nbRows;
        }
        List arrays = matrix.getArrays();
        List matCells = matrix.getMatCells();
        Matrix.Kind kind = matrix.getKind();
        switch (kind) {
            case DIAGONAL: {
                if (arrays.size() != 1) break;
                Array array = (Array)arrays.get(0);
                return ArrayUtil.getSize(array);
            }
            case SYMMETRIC: {
                if (arrays.isEmpty()) break;
                return arrays.size();
            }
            case ANY: {
                if (!arrays.isEmpty()) {
                    return arrays.size();
                }
                if (matCells.isEmpty()) break;
                MatCell matCell = Collections.max(matCells, rowComparator);
                return matCell.requireRow();
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)matrix, (Enum)kind);
            }
        }
        throw new InvalidElementException((PMMLObject)matrix);
    }

    public static int getColumns(Matrix matrix) {
        Integer nbCols = matrix.getNbCols();
        if (nbCols != null) {
            return nbCols;
        }
        List arrays = matrix.getArrays();
        List matCells = matrix.getMatCells();
        Matrix.Kind kind = matrix.getKind();
        switch (kind) {
            case DIAGONAL: {
                if (arrays.size() != 1) break;
                Array array = (Array)arrays.get(0);
                return ArrayUtil.getSize(array);
            }
            case SYMMETRIC: {
                if (arrays.isEmpty()) break;
                return arrays.size();
            }
            case ANY: {
                if (!arrays.isEmpty()) {
                    Array array = (Array)arrays.get(arrays.size() - 1);
                    return ArrayUtil.getSize(array);
                }
                if (matCells.isEmpty()) break;
                MatCell matCell = Collections.max(matCells, columnComparator);
                return matCell.requireCol();
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)matrix, (Enum)kind);
            }
        }
        throw new InvalidElementException((PMMLObject)matrix);
    }
}

