/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.evaluator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jpmml.evaluator.TableUtil;

public class Table {
    private List<String> columns = null;
    private List<Exception> exceptions = new ArrayList<Exception>();
    private Map<String, List<?>> values = new HashMap();

    public Table() {
        this(new ArrayList<String>());
    }

    public Table(List<String> columns) {
        this.setColumns(columns);
    }

    public int getNumberOfRows() {
        List<Exception> exceptions = this.getExceptions();
        int result = exceptions.size();
        Map<String, List<?>> columnValues = this.getValues();
        Set<Map.Entry<String, List<?>>> entries = columnValues.entrySet();
        for (Map.Entry entry : entries) {
            List values = (List)entry.getValue();
            result = Math.max(result, values.size());
        }
        return result;
    }

    public int getNumberOfColumns() {
        List<String> columns = this.getColumns();
        return columns.size();
    }

    public void canonicalize() {
        List<String> columns = this.getColumns();
        int numberOfRows = this.getNumberOfRows();
        List<Exception> exceptions = this.getExceptions();
        TableUtil.ensureSize(exceptions, numberOfRows);
        for (String column : columns) {
            List<?> values = this.getValues(column);
            if (values == null) {
                values = new ArrayList(numberOfRows);
                this.setValues(column, values);
            }
            TableUtil.ensureSize(values, numberOfRows);
        }
    }

    protected boolean ensureColumn(String column) {
        List<String> columns = this.getColumns();
        if (!columns.contains(column)) {
            columns.add(column);
            return true;
        }
        return false;
    }

    public boolean addColumn(String column) {
        return this.ensureColumn(column);
    }

    public boolean removeColumn(String column) {
        List<String> columns = this.getColumns();
        boolean result = columns.remove(column);
        if (result) {
            Map<String, List<?>> columnValues = this.getValues();
            columnValues.remove(column);
        }
        return result;
    }

    public boolean hasExceptions() {
        List<Exception> exceptions = this.getExceptions();
        for (int i = 0; i < exceptions.size(); ++i) {
            Exception exception = exceptions.get(i);
            if (exception == null) continue;
            return true;
        }
        return false;
    }

    public Exception getException(int index) {
        List<Exception> exceptions = this.getExceptions();
        return TableUtil.get(exceptions, index);
    }

    public void setException(int index, Exception exception) {
        List<Exception> exceptions = this.getExceptions();
        TableUtil.set(exceptions, index, exception);
    }

    protected List<?> ensureValues(String column) {
        Map<String, List<?>> columnValues = this.getValues();
        List<?> values = columnValues.get(column);
        if (values == null) {
            this.ensureColumn(column);
            values = new ArrayList();
            columnValues.put(column, values);
        }
        return values;
    }

    public List<?> getValues(String column) {
        Map<String, List<?>> columnValues = this.getValues();
        return columnValues.get(column);
    }

    public void setValues(String column, List<?> values) {
        Map<String, List<?>> columnValues = this.getValues();
        this.ensureColumn(column);
        columnValues.put(column, values);
    }

    public List<String> getColumns() {
        return this.columns;
    }

    void setColumns(List<String> columns) {
        this.columns = Objects.requireNonNull(columns);
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public Map<String, List<?>> getValues() {
        return this.values;
    }
}

